/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id: //kmgmt/bc.rf.repository.service/60NW_SP_COR/src/_appproperties/java/api/com/sapportals/wcm/repository/service/appproperties/IAppProperty.java#3 $
 */

package com.sapportals.wcm.repository.service.appproperties;

import com.sapportals.wcm.WcmException;
import com.sapportals.wcm.repository.IPropertyName;
import com.sapportals.wcm.repository.enum.PropertyType;
import java.util.Date;
import java.util.List;

/**
 * An application-defined and personalized property of a resource object in any
 * repository. <p>
 *
 * Copyright (c) SAP AG 2001-2004
 * @author m.breitenfelder@sap.com
 * @version $Id: //kmgmt/bc.rf.repository.service/dev/src/_appproperties/java/api/com/sapportals/wcm/repository/service/appproperties/IAppProperty.java#3
 *      $
 */
public interface IAppProperty {

  /**
   * Returns the property name
   *
   * @return The property name object
   */
  IPropertyName getPropertyName();

  /**
   * Returns the property data type
   *
   * @return The property type constant
   */
  PropertyType getType();

  /**
   * Returns true if it is a multi-valued property
   *
   * @return multivalued
   */
  boolean isMultivalued();

  /**
   * Returns a flag indicating of the properties should be copied if copy() is
   * called on the resource
   *
   * @return Boolean value
   */
  boolean isCopyEnabled();


  /**
   * Returns the user ID if the property is personalized, null otherwise
   *
   * @return The user ID
   */
  String getUserID();

  /**
   * Get the property value converted to a string.
   *
   * @return A String value or null if it is a multi-valued property
   */
  String getValueAsString();

  /**
   * Get the property value if the type is {@link PropertyType#BOOLEAN} or <code>null</code>
   * otherwise.
   *
   * @return The value
   */
  Boolean getBooleanValue();

  /**
   * Get the property value if the type is {@link PropertyType#INTEGER} or <code>null</code>
   * otherwise.
   *
   * @return The value
   */
  Integer getIntegerValue();

  /**
   * Get the property value if the type is {@link PropertyType#LONG} or <code>null</code>
   * otherwise.
   *
   * @return The value
   */
  Long getLongValue();

  /**
   * Get the property value if the type is {@link PropertyType#DATE} or <code>null</code>
   * otherwise.
   *
   * @return The value
   */
  Date getDateValue();

  /**
   * Get the property value if the type is {@link PropertyType#STRING} or {@link PropertyType#XML}, or <code>null</code> otherwise.
   *
   * @return The value
   */
  String getStringValue();

  /**
   * Returns a list of property values if the property is defined as
   * multi-valued, <code>null</code> otherwise
   *
   * @return values
   * @exception WcmException Exception raised in failure situation
   */
  List getValues()
    throws WcmException;
}

