/*
 * Copyright (c) 2003 by SAP AG. All Rights Reserved.
 *
 * SAP, mySAP, mySAP.com and other SAP products and
 * services mentioned herein as well as their respective
 * logos are trademarks or registered trademarks of
 * SAP AG in Germany and in several other countries all
 * over the world. MarketSet and Enterprise Buyer are
 * jointly owned trademarks of SAP AG and Commerce One.
 * All other product and service names mentioned are
 * trademarks of their respective companies.
 *
 * @version $Id: //kmgmt/bc.rf.repository.service/60NW_SP_COR/src/_appproperties/java/api/com/sapportals/wcm/repository/service/appproperties/AppProperty.java#3 $
 */

package com.sapportals.wcm.repository.service.appproperties;

import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

import com.sapportals.wcm.WcmException;
import com.sapportals.wcm.repository.IPropertyName;
import com.sapportals.wcm.repository.XMLMarkup;
import com.sapportals.wcm.repository.enum.PropertyType;

/**
 * An application-defined property of a resource object in any repository. <p>
 *
 * Copyright (c) SAP AG 2001-2004
 * @author m.breitenfelder@sap.com
 * @version $Id: //kmgmt/bc.rf.repository.service/dev/src/_appproperties/java/api/com/sapportals/wcm/repository/service/appproperties/AppProperty.java#3
 *      $
 */
public class AppProperty implements IAppProperty {

  private long id = 0L;

  protected IPropertyName name = null;
  protected Object value = null;
  protected PropertyType type = null;
  protected String userID = null;
  protected boolean enableCopy = false;
  protected boolean isMultivalued = false;
  protected List values = null;

  public AppProperty(IPropertyName name, String value, String userID, boolean enableCopy)
    throws WcmException {
    if (name == null) {
      throw new java.lang.NullPointerException("name is null");
    }
    this.name = name;
    this.type = PropertyType.STRING;
    this.value = value;
    this.userID = userID;
    this.enableCopy = enableCopy;
    this.isMultivalued = false;
  }

  public AppProperty(IPropertyName name, Date value, String userID, boolean enableCopy)
    throws WcmException {
    if (name == null) {
      throw new java.lang.NullPointerException("name is null");
    }
    this.name = name;
    this.type = PropertyType.DATE;
    this.value = value;
    this.userID = userID;
    this.enableCopy = enableCopy;
    this.isMultivalued = false;
  }

  public AppProperty(IPropertyName name, Integer value, String userID, boolean enableCopy)
    throws WcmException {
    if (name == null) {
      throw new java.lang.NullPointerException("name is null");
    }
    this.name = name;
    this.type = PropertyType.INTEGER;
    this.value = value;
    this.userID = userID;
    this.enableCopy = enableCopy;
    this.isMultivalued = false;
  }

  public AppProperty(IPropertyName name, Long value, String userID, boolean enableCopy)
    throws WcmException {
    if (name == null) {
      throw new java.lang.NullPointerException("name is null");
    }
    this.name = name;
    this.type = PropertyType.LONG;
    this.value = value;
    this.userID = userID;
    this.enableCopy = enableCopy;
    this.isMultivalued = false;
  }

  public AppProperty(IPropertyName name, Boolean value, String userID, boolean enableCopy)
    throws WcmException {
    if (name == null) {
      throw new java.lang.NullPointerException("name is null");
    }
//    if (value == null) throw new java.lang.NullPointerException("value is null");
    this.name = name;
    this.type = PropertyType.BOOLEAN;
    this.value = value;
    this.userID = userID;
    this.enableCopy = enableCopy;
    this.isMultivalued = false;
  }

  public AppProperty(IPropertyName name, XMLMarkup value, String userID, boolean enableCopy)
    throws WcmException {
    if (name == null) {
      throw new java.lang.NullPointerException("name is null");
    }
    this.name = name;
    this.type = PropertyType.XML;
    this.value = value;
    this.userID = userID;
    this.enableCopy = enableCopy;
    this.isMultivalued = false;
  }

  public AppProperty(IPropertyName name, PropertyType type, List values, String userID,
    boolean enableCopy)
    throws WcmException {
    if (name == null) {
      throw new java.lang.NullPointerException("name is null");
    }
    if (type == null) {
      throw new java.lang.NullPointerException("type is null");
    }
    this.name = name;
    this.type = type;
    this.userID = userID;
    this.enableCopy = enableCopy;
    this.isMultivalued = true;

    if (values != null) {
      Iterator it = values.iterator();
      while (it.hasNext()) {
        validateType(it.next());
      }
      this.values = new ArrayList(values);
    }
  }


  public IPropertyName getPropertyName() {
    return this.name;
  }

  public PropertyType getType() {
    return this.type;
  }

  public boolean isMultivalued() {
    return this.isMultivalued;
  }

  public String getUserID() {
    return this.userID;
  }

  public String getValueAsString() {
    if (this.value != null) {
      if (this.value instanceof Date) {
        return DateFormat.getDateTimeInstance(DateFormat.LONG, DateFormat.LONG).format((Date)this.value);
      }
      else {
        return this.value.toString();
      }
    }
    else {
      return null;
    }
  }

  public Boolean getBooleanValue() {
    if (this.value instanceof Boolean) {
      return (Boolean)this.value;
    }
    else {
      return null;
    }
  }

  public Integer getIntegerValue() {
    if (this.value instanceof Integer) {
      return (Integer)this.value;
    }
    else {
      return null;
    }
  }

  public Long getLongValue() {
    if (this.value instanceof Long) {
      return (Long)this.value;
    }
    else {
      return null;
    }
  }

  public Date getDateValue() {
    if (this.value instanceof Date) {
      return (Date)this.value;
    }
    else {
      return null;
    }
  }

  public String getStringValue() {
    if (this.value instanceof String) {
      return (String)this.value;
    }
    else {
      return null;
    }

  }

  public synchronized List getValues()
    throws WcmException {
    if (!isMultivalued()) {
      return null;
    }
    return this.values;
  }


  public boolean isCopyEnabled() {
    return this.enableCopy;
  }

  public String toString() {
    if (this.isMultivalued) {
      return "name= " + this.name + ", value =" + this.values.toString() + ", userID=" + this.userID;
    }
    else {
      return "name= " + this.name + ", value =" + this.value.toString() + ", userID=" + this.userID;
    }
  }

  //////////////////////////////////////////////////////////////////////////////

  public void setPropertyID(long id) {
    this.id = id;
  }

  public long getPropertyID() {
    return this.id;
  }

  protected void validateType(Object v)
    throws WcmException {
    if (this.type.equals(PropertyType.BOOLEAN)) {
      if (!(v instanceof Boolean)) {
        throw new WcmException("Wrong instance, expected Boolean");
      }
    }
    else if (this.type.equals(PropertyType.DATE)) {
      if (!(v instanceof Date)) {
        throw new WcmException("Wrong instance, expected Date");
      }
    }
    else if (this.type.equals(PropertyType.INTEGER)) {
      if (!(v instanceof Integer)) {
        throw new WcmException("Wrong instance, expected Integer");
      }
    }
    else if (this.type.equals(PropertyType.LONG)) {
      if (!(v instanceof Long)) {
        throw new WcmException("Wrong instance, expected Longean");
      }
    }
    else if (this.type.equals(PropertyType.STRING)) {
      if (!(v instanceof String)) {
        throw new WcmException("Wrong instance, expected String");
      }
    }
    else if (this.type.equals(PropertyType.XML)) {
      if (!(v instanceof XMLMarkup)) {
        throw new WcmException("Wrong instance, expected String");
      }
    }
  }
}
