<!-------------------------------------------------------------------------------->
<!--																			-->
<!--  module: MyNavigation.js													-->
<!--																			-->
<!--  ------------------------------------------------------------------------  -->
<!--																			-->
<!--  responsible:  Markus Oezgen												-->
<!--																			-->
<!--  special area: Web Navigation												-->
<!--																			-->
<!--  description:  Sample personalization file for the web navigation control	-->
<!--																			-->
<!--  see also:																	-->
<!--																			-->
<!--  ------------------------------------------------------------------------  -->
<!--																			-->
<!--  ========== licence begin LGPL												-->
<!--  Copyright (C) 2000 SAP AG													-->
<!--																			-->
<!--  This library is free software; you can redistribute it and/or				-->
<!--  modify it under the terms of the GNU Lesser General Public				-->
<!--  License as published by the Free Software Foundation; either				-->
<!--  version 2.1 of the License, or (at your option) any later version.		-->
<!--																			-->
<!--  This library is distributed in the hope that it will be useful,			-->
<!--  but WITHOUT ANY WARRANTY; without even the implied warranty of			-->
<!--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU			-->
<!--  Lesser General Public License for more details.							-->
<!--																			-->
<!--  You should have received a copy of the GNU Lesser General Public			-->
<!--  License along with this library; if not, write to the Free Software		-->
<!--  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA -->
<!--  ========== licence end													-->
<!--																			-->
<!-------------------------------------------------------------------------------->

// User-defined tree menu data.

Navigations.addNavigation(new navigation("Web Server", "Web Server", "Navigation", "", "", true, true, 7));

// Define the items for the top-level of the tree menu.
Navigations.items[0].addNode(new node("Global Settings", "waadmin?GlobalSettings", "Details"));
Navigations.items[0].addNode(new node("Session Pools"));
Navigations.items[0].addNode(new node("Services"));
Navigations.items[0].addNode(new node("COM Services"));

// Session Pools
Navigations.items[0].nodes[1].addNode(new node("SP 1", "waadmin?SessionPool&Name=SP 1", "Details"));

// Services
Navigations.items[0].nodes[2].addNode(new node("Service 1", "waadmin?Service&Name=1", "Details"));
Navigations.items[0].nodes[2].addNode(new node("Service 2", "waadmin?Service&Name=2", "Details"));

// COM Services
Navigations.items[0].nodes[3].addNode(new node("COM Service 1", "waadmin?COMService&Name=1", "Details"));
Navigations.items[0].nodes[3].addNode(new node("COM Service 2", "waadmin?COMService&Name=1", "Details"));


///////////////////////////////////////////////////////////////////////////////
//
// Send this function as your own refresh navigation function to your
// navigation.js frame
//
///////////////////////////////////////////////////////////////////////////////

function refreshNavigation() {

  // window.frames[1]
  // is the frame where your navigation control is displayed
  //
  // waadmin.wa?Service=Navigation&Refresh=1
  // is your show/refresh navigation service

  window.frames[1].location.href="waadmin.wa?Service=Navigation&Refresh=1"

}
