// Copyright by SAP AG, 2000

// 7/8/99 9:40 pm
// Made var height in engage() a global variable so that
// it could be easier accessed, and placed in the preferences are
// at the top of the script.
// Added alltrays function and altered engage so that
// trays are made visible as well as invisble.

// 7/7/99 original script

// Variables for rollovers
var icon_open = new Image();
var icon_close = new Image();
var icon_open_note = new Image();
var icon_close_note = new Image();
icon_open.src = "/WARoot/Images/arrowc.gif";
icon_close.src = "/WARoot/Images/arrowo.gif";
icon_open_note.src = "/WARoot/Images/arrowc.gif";
icon_close_note.src = "/WARoot/Images/arrowo.gif";

// Preferences. these could be determined by
// a cookie or some other server variable.
if (document.all || document.layers) {
	// Number of trays of user
	var trayNUM = 6;

	// Where trays will start
	var trayHEIGHT = 0

	// Whether the window will scroll if the
	// new information of a tray is not visible
	var SCROLLING = false;

	// Whether a window is open or not.
	// These would probably be held in a cookie
	// but also need to be saved to the server
	// at some point.
	var isOPEN = new Array(trayNUM);
	isOPEN[0] = false;
	isOPEN[1] = false;
	isOPEN[2] = false;
	isOPEN[3] = false;
	isOPEN[4] = false;
	isOPEN[5] = false;
	}

	// auto detect browser, set appropriate #
	var ns_ie_adjust = 7;

// FUNCTION MAKE_VISIBLE
// This function makes the lower part of a tray visible or hidden
// Called by closeopen_trays() and engage()
function make_visible(tray_num,vis_hid) {
	var tray
	if (document.all) tray = eval("document.all.extraytemplate" + tray_num + ".style");
	else tray =  eval("document.extraytemplate" + tray_num);
	tray.visibility = vis_hid;
	}

// FUNCTION GET_NEW_TRAY
// This function gets a tray layer object.
// The extra variable that is passed to function determines whether
// the layer object is the normal portion or the lower portion of
// the tray.
// Called by closeopen_trays() and engage()
function get_new_tray(extra,tray) {
	if (document.all) return eval(extra + "traytemplate" + tray);
	else return eval("document." + extra + "traytemplate" + tray);
	}

// FUNCTION SCROLLWINDOW
// This function checks to see if the lower portion of
// a tray is below the fold or not.
// If it is, the window is scrolled.
// Called by closeopen_trays()
function scrollwindow(currentray,extratray,plus_or_minus) {

	if (document.all) {
		// false means that the tray will be aligned to the bottom
		// of the window. if it was true the tray would be scrolled
		// all the way to the top
		extratray.scrollIntoView(false)
		}
	else {
		if (extratray.top - window.pageYOffset > window.innerHeight)
			window.scrollBy(0, plus_or_minus * currentray.clip.bottom);
		}
	}

// FUNCTION CLOSEOPEN_TRAYS
// This is the main function, which opens and closes windows
// it makes the lower tray visible or hidden
// and then runs through a loop moving all the
// layers that follow the open (or closed) tray.
// It then calls the scrolling function
// Called by check_openclose()
function closeopen_trays(plus_or_minus,tray_num) {
	if (plus_or_minus == 1) make_visible(tray_num,"visible");
	else  make_visible(tray_num,"hidden");


	var opentray = get_new_tray('ex',tray_num);
	var newtray;
	var extratray;

	// Adds or subtracts the height of the opening or closing layer
	// from all the layers below it.
	// The for loop moves through the trays so treats the upper
	// and lower tray portion at the same time.
	// The plus_or_minus variable allows us to use the same function
	// for both opening and closing.
	// The -10 is so that the lower tray covers up the lower shadow of the
	// tray above.
	for (tray = tray_num + 1; tray <= trayNUM; tray++ ) {
		// The upper part of a tray
		newtray = get_new_tray('', tray);

		// offsetHeight for Netscape fix... calculate to - 17 pixels
		if (document.all) newtray.style.pixelTop += plus_or_minus * (opentray.offsetHeight-ns_ie_adjust);
		else newtray.top += plus_or_minus * (opentray.clip.bottom -7);

		// The lower part of a tray
		extratray = get_new_tray('ex',tray);

		// offsetHeight for Netscape fix... calculate to - 17 pixels
		if (document.all) extratray.style.pixelTop += plus_or_minus * (opentray.offsetHeight-ns_ie_adjust);
		else extratray.top +=  plus_or_minus * (opentray.clip.bottom-7);
		}

	// Checks to see if SCROLLING is on and calls the scrollwindow function
	if(SCROLLING) scrollwindow(get_new_tray('',tray_num),opentray,plus_or_minus);
	}

// FUNCTION check_openclose
// This function checks to see if there are 4.0 browsers
// it then checks to see if the tray is already open or not
// and then calls the appropriate action.
// It also changes the icon appropriately.
// This function is called when a user clicks on the
// open or close icon in the HTML
function check_openclose(tray) {
	if (document.all || document.layers) {
		if (isOPEN[tray - 1]) closeopen_trays(-1,tray);
		else closeopen_trays(1,tray);

		isOPEN[tray - 1] = !isOPEN[tray - 1];

		swap_icon(tray)
		}
	else alert("3.0 browsers will require server action to open or close layers")

	return false;
	}

// FUNCTION SWAP_ICON
// This function is a swaps the icons
// Called by engage()
function swap_icon(tray) {
	if (document.all) icon_image = eval("document.icon" + tray);
	else icon_image = eval("document.traytemplate" + tray + ".document.icon" + tray);
	if (isOPEN[tray-1]) icon_image.src = icon_close.src;
	else icon_image.src = icon_open.src;
	}

// FUNCTION ENGAGE
// This function checks all the layers to see if they are open or not
// and then moves them to the correct position.
// The function checks the height of the layer and adds it to an
// overall height counter (trayHEIGHT) so that it can place the next layer.
// The starting height needs to be predetermined so that the layout
// is correct.
// It is called after the page loads (the page needs to be written before
// heights of layers can be determined.
function expand() {
	if (document.all || document.layers) {

		var icon_image;
		var newtray;
		var height = trayHEIGHT;

		// Moves through all the trays.
		for (tray = 1; tray <= trayNUM; tray++ ) {
			newtray = get_new_tray('', tray);
			var extratray;

			// The upper tray.
			if (document.all) {
				newtray.style.pixelTop = height;
				height += newtray.offsetHeight;
				}
			else {
				newtray.top = height;
				height += newtray.clip.bottom;
				}

			// The lower tray.
			// We have to check if the tray is open or not.
			// The -10 is to cover up the lowe shadow of the
			// tray above.
			extratray = get_new_tray('ex',tray);
			if (document.all) {
				extratray.style.pixelTop = height-7;
				if (isOPEN[tray-1]) {
					height += extratray.offsetHeight -7;
					extratray.style.visibility = "visible";
					}
				else extratray.style.visibility = "hidden";
				}
			else {
				extratray.top = height-7;
				if (isOPEN[tray-1]) {
					height += extratray.clip.bottom -7;
					extratray.visibility = "visible";
					}
				else extratray.visibility = "hidden";
				}

			// Puts in the appropriate icon.
			swap_icon(tray);
			}
		}
	else alert("this is best viewed with a 4.0 browser")
	}


// FUNCTION ALLTRAY
// Changes of state of all layers to closed or open
// called engage() function to carry out DHTML
// Called by clicking on top level blue control buttons in the HTML
function alltray(open_close) {
	for (tray = 1; tray <= trayNUM; tray++) {
		if (open_close == 'close') isOPEN[tray - 1] = false;
		else isOPEN[tray - 1] = true;
		}

	expand();

	return false;
	}

// FUNCTION SWAP
// Rollover function for the open and close icons.
// The on_off variable is so that the icon does not stay highlighted when
// a user opens or closes an icon.
// Called when a user rollsover a icon on a layer.
function swap(tray,on_off) {
	if (document.all) icon_image = eval("document.icon" + tray);
	else icon_image = eval("document.traytemplate" + tray + ".document.icon" + tray);

	if (on_off == 'off') {
		if (icon_image.src == icon_open.src || icon_image.src == icon_open_note.src) icon_image.src = icon_open.src;
		else if (icon_image.src == icon_close.src || icon_image.src == icon_close_note.src) icon_image.src = icon_close.src;
		}
	else {
		if (icon_image.src == icon_open.src || icon_image.src == icon_open_note.src) icon_image.src = icon_open_note.src;
		else if (icon_image.src == icon_close.src || icon_image.src == icon_close_note.src) icon_image.src = icon_close_note.src;
		}
	}
