package com.sap.caf.rt.security.util;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;

import javax.ejb.CreateException;
import javax.naming.NamingException;

import com.sap.caf.metamodel.Attribute;
import com.sap.caf.metamodel.BusinessEntityInterface;
import com.sap.caf.metamodel.DataObject;
import com.sap.caf.rt.bol.IDependentObject;
import com.sap.caf.rt.exception.CAFCreateException;
import com.sap.caf.rt.exception.DataAccessException;
import com.sap.caf.rt.exception.ServiceException;
import com.sap.caf.rt.exception.CAFPermissionException;
import com.sap.caf.rt.metamodel.MetaModel;
import com.sap.caf.rt.security.acl.impl.CAFPermissionLocal;
import com.sap.caf.rt.security.acl.impl.CAFPermissionLocalHome;
import com.sap.caf.rt.security.acl.impl.businessrule.BusinessRuleLocal;
import com.sap.caf.rt.security.acl.impl.businessrule.BusinessRuleLocalHome;
import com.sap.caf.rt.security.acl.impl.businessrule.BusinessRuleVo;
import com.sap.caf.rt.security.acl.impl.condition.ConditionLocal;
import com.sap.caf.rt.security.acl.impl.condition.ConditionLocalHome;
import com.sap.caf.rt.security.acl.impl.condition.ConditionVo;
import com.sap.caf.rt.security.acl.impl.objectattribute.ObjectAttributeLocal;
import com.sap.caf.rt.security.acl.impl.objectattribute.ObjectAttributeLocalHome;
import com.sap.caf.rt.security.acl.impl.objectattribute.ObjectAttributeVo;
import com.sap.caf.rt.security.acl.impl.objecttype.ObjectTypeLocal;
import com.sap.caf.rt.security.acl.impl.objecttype.ObjectTypeLocalHome;
import com.sap.caf.rt.srv.util.EJBHomeFactory;
import com.sap.caf.rt.util.CAFPublicLogger;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.Severity;

/**
 * @author c5051699
 */

public class CAFPermissionUtil {

	private static final String APPLICATION = CAFPermissionUtil.class.getName();
	private static final Location LOGGER = Location.getLocation(APPLICATION);
	private static final String JARMREQPREFIX = "CAF:RT:security:";
	private static final String JARMREQUEST = JARMREQPREFIX+APPLICATION;

	private static final String BUSINESSRULE_JNDI = "/localejbs/sap.com/caf.runtime/BusinessRule";
	private static final String OBJECTATTRIBUTE_JNDI = "/localejbs/sap.com/caf.runtime/ObjectAttribute";
	private static final String CONDITION_JNDI = "/localejbs/sap.com/caf.runtime/Condition";
	private static final String CAFPERMISSION_JNDI = "/localejbs/sap.com/caf.runtime/CAFPermissionBean";
	private static final String OBJECTTYPE_JNDI = "/localejbs/sap.com/caf.runtime/ObjectType";

	private static MetaModel m_mmr = null;
	
	public CAFPermissionUtil() {
	}

	public static BusinessRuleLocal getBusinessRuleLocal() throws CAFCreateException {
		final String method = "getBusinessRuleLocal()";

		try {
			EJBHomeFactory ejbFactory = EJBHomeFactory.getInstance();

			BusinessRuleLocalHome businessRuleLocalHome = 
				(BusinessRuleLocalHome) ejbFactory.getLocalHome(BUSINESSRULE_JNDI);
			BusinessRuleLocal businessRuleLocal = businessRuleLocalHome.create();

			return businessRuleLocal;
		} catch (NamingException e) {
			CAFPublicLogger.traceThrowableT(Severity.ERROR, LOGGER, method, e.getMessage(), e);
			throw new CAFCreateException(e.getMessage());
		} catch (CreateException e) {
			CAFPublicLogger.traceThrowableT(Severity.ERROR, LOGGER, method, e.getMessage(), e);
			throw new CAFCreateException(e.getMessage());
		}
	}

	public static ObjectTypeLocal getObjectTypeLocal() throws CAFCreateException {
		final String method = "getObjectTypeLocal()";

		try {
			EJBHomeFactory ejbFactory = EJBHomeFactory.getInstance();

			ObjectTypeLocalHome objectTypeLocalHome = 
				(ObjectTypeLocalHome) ejbFactory.getLocalHome(OBJECTTYPE_JNDI);
			ObjectTypeLocal objectTypeLocal = objectTypeLocalHome.create();

			return objectTypeLocal;
		} catch (NamingException e) {
			CAFPublicLogger.traceThrowableT(Severity.ERROR, LOGGER, method, e.getMessage(), e);
			throw new CAFCreateException(e.getMessage());
		} catch (CreateException e) {
			CAFPublicLogger.traceThrowableT(Severity.ERROR, LOGGER, method, e.getMessage(), e);
			throw new CAFCreateException(e.getMessage());
		}
	}

	public static ObjectAttributeLocal getObjectAttributeLocal() throws CAFCreateException {
		final String method = "getObjectAttributeLocal()";

		try {
			final EJBHomeFactory ejbFactory = EJBHomeFactory.getInstance();
			
			ObjectAttributeLocalHome objectAttributeLocalHome =
				(ObjectAttributeLocalHome) ejbFactory.getLocalHome(OBJECTATTRIBUTE_JNDI);
			ObjectAttributeLocal objectAttributeLocal = objectAttributeLocalHome.create();	
			
			return objectAttributeLocal;
		} catch (NamingException e) {
			CAFPublicLogger.traceThrowableT(Severity.ERROR, LOGGER, method, e.getMessage(), e);
			throw new CAFCreateException(e.getMessage());
		} catch (CreateException e) {
			CAFPublicLogger.traceThrowableT(Severity.ERROR, LOGGER, method, e.getMessage(), e);
			throw new CAFCreateException(e.getMessage());
		}
	}
	
	public static ConditionLocal getConditionLocal() throws CAFCreateException {
		final String method = "getConditionLocal()";

		try {
			final EJBHomeFactory ejbFactory = EJBHomeFactory.getInstance();
				
			ConditionLocalHome conditionLocalHome =
				(ConditionLocalHome) ejbFactory.getLocalHome(CONDITION_JNDI);
			ConditionLocal conditionLocal = conditionLocalHome.create(); 
				
			return conditionLocal;
		} catch (NamingException e) {
			CAFPublicLogger.traceThrowableT(Severity.ERROR, LOGGER, method, e.getMessage(), e);
			throw new CAFCreateException(e.getMessage());
		} catch (CreateException e) {
			CAFPublicLogger.traceThrowableT(Severity.ERROR, LOGGER, method, e.getMessage(), e);
			throw new CAFCreateException(e.getMessage());
		}
	}

	public static boolean remoteCheckAclPermission(Object obj,String userId,String permissionName,String objectType) throws CAFPermissionException, CAFCreateException {
		final String method = "remoteCheckAclPermission";

		try {
			final EJBHomeFactory ejbFactory = EJBHomeFactory.getInstance();
				
			CAFPermissionLocalHome permissionLocalHome =
				(CAFPermissionLocalHome) ejbFactory.getLocalHome(CAFPERMISSION_JNDI);
			CAFPermissionLocal permissionLocal = permissionLocalHome.create(); 

			return permissionLocal.checkAclPermission(obj, userId, permissionName, objectType).booleanValue();
		} catch (NamingException e) {
			CAFPublicLogger.traceThrowableT(Severity.INFO, LOGGER, method, e.getMessage(), e);
			throw new CAFCreateException(e.getMessage());
		} catch (Exception e) {
			CAFPublicLogger.traceThrowableT(Severity.INFO, LOGGER, method, e.getMessage(), e);
			throw new CAFPermissionException(e);
		}
	}

	public static ArrayList fetchAttributeSet(String objectTypeID) throws ServiceException {
		final String method = "fetchAttributeSet(String)";
		CAFPublicLogger.entering(null, JARMREQUEST, method, LOGGER, 1);

		try {
			ObjectAttributeLocal objectAttributeLocal = getObjectAttributeLocal();
			Collection objectAttributes = objectAttributeLocal.findByObjectTypeID(objectTypeID);
			ArrayList result = new ArrayList();
			for (Iterator it = objectAttributes.iterator(); it.hasNext();) {
				ObjectAttributeVo objectAttributeVo = (ObjectAttributeVo)it.next();
				result.add(objectAttributeVo.getObjectAttributeName());
			}
			return result;
		} catch (Exception _e) {
			throw new ServiceException(_e.getLocalizedMessage());
		} finally {
			CAFPublicLogger.exiting(null, JARMREQUEST, method, LOGGER, 1);
		}
	}

	public static ArrayList fetchBusinessRules(String objectType) throws ServiceException {
		final String method = "fetchBusinessRules(String)";
		CAFPublicLogger.entering(null, JARMREQUEST, method, LOGGER, 1);

		CAFBusinessRuleList cafBusinessRuleList = null;
		try {
			BusinessRuleLocal businessRuleLocal = getBusinessRuleLocal();
			ConditionLocal conditionLocal = getConditionLocal();

			Collection businessRules = businessRuleLocal.findByObjectType(objectType);
			
			if (businessRules == null) {
				return new ArrayList(); 
			}
			
			Collection businessRulesCopy = new ArrayList(businessRules);
			BusinessRuleVo businessRuleVoCopy = (BusinessRuleVo)businessRulesCopy.iterator().next();
			String objectTypeID = businessRuleVoCopy.getObjectTypeID();

			final ArrayList attrList = (ArrayList)CAFPermissionCache.getAttributeSetFromCache(objectTypeID);
			
			cafBusinessRuleList = new CAFBusinessRuleList(businessRules.size(), attrList);
			for (Iterator it = businessRules.iterator(); it.hasNext();) {
				BusinessRuleVo businessRuleVo = (BusinessRuleVo)it.next();
				Collection conditions = conditionLocal.findByBusinessRule(businessRuleVo.getKey());
				CAFBusinessRuleBean cafBusinessRuleBean = new CAFBusinessRuleBean(businessRuleVo.getKey());
				for (Iterator iter = conditions.iterator(); iter.hasNext();) {
					ConditionVo conditionVo = (ConditionVo)iter.next();
					StringTokenizer valueToken = new StringTokenizer(conditionVo.getAttributeValue(), "_", false);
					String lowValue = valueToken.nextToken();
					String highValue = valueToken.nextToken();
					String operator = valueToken.nextToken();
					
					CAFBusinessConditionBean cafBusinessConditionBean =
						new CAFBusinessConditionBean(
								conditionVo.getKey(),
								conditionVo.getAttributeName(),
								lowValue,
								highValue,
								operator,
								cafBusinessRuleList.getAttributeIndex(conditionVo.getAttributeName()));
								
					cafBusinessRuleBean.addCondition(cafBusinessConditionBean);
				}
				cafBusinessRuleList.add(cafBusinessRuleBean);
			}
		} catch (Exception e) {
			throw new ServiceException(e.getLocalizedMessage());
		} finally {
			CAFPublicLogger.exiting(null, JARMREQUEST, method, LOGGER, 1);
		}
		return cafBusinessRuleList;
	}

	public static IDependentObject getDependentObject(String objectID,String objectType) throws ServiceException {
		final String method = "getDependentObject(String, String)";
		try {
			final EJBHomeFactory ejbFactory = EJBHomeFactory.getInstance();
			String jndiName = "/localejbs/" + objectType + "Service";

			Object objectLocalHome = (Object) ejbFactory.getLocalHome(jndiName);

			Method createLocal = objectLocalHome.getClass().getMethod("create", new Class[] {});
			Object bean = createLocal.invoke(objectLocalHome, new Object[] {});

			Method methodRead = bean.getClass().getMethod("read", new Class[] { String.class });
			Object ejbRef = methodRead.invoke(bean, new Object[] { objectID });

			return (IDependentObject) ejbRef;
		} catch (Exception e) {
			CAFPublicLogger.traceThrowableT(Severity.ERROR, LOGGER, method, e.getMessage(), e);
			throw new ServiceException(e.getMessage());
		}
	}

	public static Collection getDependentObjects(
		String objectType,
		java.util.Map mapNameToFilter)
		throws ServiceException {
		final String method = "getDependentObjects(String, Map)";
		try {
			final EJBHomeFactory ejbFactory = EJBHomeFactory.getInstance();
			String jndiName = "/localejbs/" + objectType + "Service";

			Object objectLocalHome = (Object) ejbFactory.getLocalHome(jndiName);

			Method createLocal =
				objectLocalHome.getClass().getMethod("create", new Class[] {});
			Object bean = createLocal.invoke(objectLocalHome, new Object[] {});

			Method methodRead = bean.getClass().getMethod("findByMultipleParameters",
					new Class[] { Map.class, boolean.class, String.class });
			Object ejbRef = methodRead.invoke(bean, new Object[] { mapNameToFilter, Boolean.FALSE, "getDependentObjects" });

			return (Collection) ejbRef;
		} catch (Exception e) {
			CAFPublicLogger.traceThrowableT(Severity.ERROR, LOGGER, method, e.getMessage(), e);
			throw new ServiceException(e.getMessage());
		}
	}
	
	private static synchronized MetaModel getMetaModel() throws ServiceException {
		String method = "getMetaModel()";
		
		if (m_mmr==null) {
			try {
				m_mmr = new MetaModel();
			} catch (DataAccessException e) {
				CAFPublicLogger.traceThrowableT(Severity.ERROR, LOGGER, method, e.getMessage(), e);
				throw new ServiceException(e.getMessage());
			}
		}
		return m_mmr;
	}
	
	public static synchronized BusinessEntityInterface getBusinessEntityInterfaceByObjectName(String objectName) throws DataAccessException, ServiceException{
		return getMetaModel().getBusinessEntityInterfaceByObjectName(objectName);
	}

	public static synchronized BusinessEntityInterface getBusinessEntityInterfaceByGUID(String guid) throws DataAccessException, ServiceException {
		return getMetaModel().getBusinessEntityInterfaceByGUID(guid);
	}

	public static synchronized DataObject getDataObjectByGUID(String guid) throws DataAccessException, ServiceException {
		return getMetaModel().getDataObjectByGUID(guid);
	}

	public static synchronized DataObject getDataObject(String qualifiedName) throws DataAccessException, ServiceException {
		return getMetaModel().getDataObject(qualifiedName);
	}

	public static synchronized Map getAttributes(String qualifiedName) throws DataAccessException, ServiceException {
		return getMetaModel().getAttributes(qualifiedName);
	}

	public static synchronized Attribute getAttribute(String guid) throws DataAccessException, ServiceException {
		return getMetaModel().getAttribute(guid);
	}
	
}
