package com.sap.caf.rt.security.util;

import java.util.HashMap;
import java.util.Iterator;


public class CAFPermissionOperator
{
  public static final String BT = new String ("BT");
  public static final String EQ = new String ("EQ");
  public static final String GE = new String ("GE");
  public static final String GT = new String ("GT");
  public static final String LE = new String ("LE");
  public static final String LT = new String ("LT");

  private static final HashMap enum = new HashMap();

  private String name = "";
  private CAFPermissionOperator(String name) {
  	this.name = name;
  }

  static {
         final CAFPermissionOperator c0 = new CAFPermissionOperator(BT);
         enum.put(BT,c0);
         final CAFPermissionOperator c1 = new CAFPermissionOperator(EQ);
         enum.put(EQ,c1);
         final CAFPermissionOperator c2 = new CAFPermissionOperator(GE);
         enum.put(GE,c2);
         final CAFPermissionOperator c3 = new CAFPermissionOperator(GT);
         enum.put(GT,c3);
         final CAFPermissionOperator c4 = new CAFPermissionOperator(LE);
         enum.put(LE,c4);
         final CAFPermissionOperator c5 = new CAFPermissionOperator(LT);
         enum.put(LT,c5);
         }

  /**
   *  Returns the name corresponding instance of this class   
   *  @param name Name of the specified action as String 
   *  @return the corresponding object or null if no object exists
   *                         for the name             
   * */
  public static CAFPermissionOperator valueOf(String name) {
    if (name == null) { 
    	return null; 
    } 

    return (CAFPermissionOperator) enum.get(name);
  }

  /**
   *  Returns the name of this CAFPermissionOperator object  
   *  @return the name of the CAFPermissionOperator object
   * */
  public String getName() {
  	return name;
  }

  /**
   *  Returns the value of this CAFPermissionOperator object  
   *  @return the value of the CAFPermissionOperator object
   * */
  public String toString() {
  	return name;
  }

  /**
   *  Returns Collection of this CAFPermissionOperator objects as an iterator object 
   *  @return the name of the CAFPermissionOperator objects as an iterator object 
   * */
  public static Iterator getAllOperators() {
  	return enum.values().iterator();
  }

}
