package com.sap.caf.rt.security.util;

import java.util.HashMap;
import java.util.Iterator;

import com.sap.security.api.acl.IAclManager;

public class CAFPermissionName 
{
	
	public static final String create = "create";
	public static final String read = "read";
	public static final String update = "update";
	public static final String delete = "delete";
	//public static final String authorize = "authorize";
	public static final String owner = IAclManager.OWNER_PERMISSION;
	public static final String fullcontrol = "fullcontrol";
  
	public static final String remove = "remove";
	public static final String write = "write";
	
	private static final HashMap enum = new HashMap();
	
	private String name = "";
	private CAFPermissionName(String name) {
		this.name = name;
	}

	static {
		   enum.put(delete,new CAFPermissionName(delete));
		   enum.put(fullcontrol,new CAFPermissionName(fullcontrol));
		   enum.put(update,new CAFPermissionName(update));
		   enum.put(owner,new CAFPermissionName(owner));
		   enum.put(read,new CAFPermissionName(read));
		   enum.put(create,new CAFPermissionName(create));
		   //enum.put(authorize,new CAFPermissionName(authorize));
		   enum.put(remove,new CAFPermissionName(remove));
		   enum.put(write,new CAFPermissionName(write));
	  }

	/**
	 *  Returns the name corresponding instance of this class   
	 *  @param name Name of the specified action as String 
	 *  @return the corresponding object or null if no object exists
	 *                         for the name             
	 * */
	public static CAFPermissionName valueOf(String name) {
	  return (name == null) ? null : (CAFPermissionName) enum.get(name);  
	}

	/**
	 *  Returns the name of this CAFPermissionName object  
	 *  @return the name of the CAFPermissionName object
	 * */
	public String getName() {
		return name;
	}

	/**
	 *  Returns the value of this CAFPermissionName object  
	 *  @return the value of the CAFPermissionName object
	 * */
	public String toString() {
		return name;
	}

	/**
	 *  Returns Collection of this CAFPermissionName objects as an iterator object 
	 *  @return Collection of this CAFPermissionName objects as an iterator object
	 * */
	public static Iterator getAllNames() {
		return enum.values().iterator();
	}

}
