/*
 * Created on Aug 14, 2003
 *
 * To change the template for this generated file go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
package com.sap.caf.rt.security.util;

import java.util.ArrayList;
import java.util.Properties;

import com.sap.caf.rt.exception.CAFPermissionException;
import com.sap.ip.basecomps.cache.*;

/**
 * @author i006085
 *
 * To change the template for this generated type comment go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
public class CAFPermissionCache {
	private static CacheAccess mCacheParamAccess; 
	private static CacheAccess mCacheRuleAccess;
	private static CacheAccess mCachePermissionAccess;

	private static final String CAF_ACL_PARAMETER_GROUP = "CAF_ACL_PARAM_GROUP";
	private static final String CAF_ACL_BUSINESSRULE_GROUP = "CAF_ACL_RULE_GROUP";
	private static final String CAF_ACL_PERMISSION_GROUP = "CAF_ACL_PERM_GROUP";
	private static final String CAF_PARAM_CACHEID = CAF_ACL_PARAMETER_GROUP;
	private static final String CAF_RULE_CACHE_ID = CAF_ACL_BUSINESSRULE_GROUP;
	private static final String CAF_PERMISSION_CACHEID = CAF_ACL_PERMISSION_GROUP;
	private static final String CAF_ACL_LIFETIME = "lifetime";
	private static final String LT_UNLIMITED = "-1";
	private static final String WT_SIGNLETON = "1";
	private static final String LT_PERMISSION = "900000"; // 15 min
	
	private static final String CAF_ACL_WEIGHT = "weight";
	private static final String ACCESS_GRANDED = "accessGranded";
	private static final String ACCESS_DENIED = "accessDenied";

//	static {
//		try {
//			invalidCache();			
//		} catch (Exception ex) {
//		}
//	}
	public static Object getAttributeSetFromCache(String objectTypeID) throws CAFPermissionException {
		CacheAccess ma = 
			getCacheAccess(getCacheParamAccess(),CAF_PARAM_CACHEID,CAF_ACL_PARAMETER_GROUP,LT_UNLIMITED);
		Object cObj = null;
		try {
			cObj = ma.get(objectTypeID);
		} catch (Exception _ex) {
			throw new CAFPermissionException("AUTH_CACHE_READ", new Object[] {"AttributeSet", objectTypeID});
		}
		if (cObj == null) { 
			try {
				ArrayList al = CAFPermissionUtil.fetchAttributeSet(objectTypeID);
				ma.put(objectTypeID, al);
				cObj = al;
			} catch (Exception _ex) {	
				throw new CAFPermissionException("AUTH_CACHE_READ", new Object[] {"AttributeSet", objectTypeID});
			}
		}
		return cObj; 
	}
    
	public static Object getBusinessRuleFromCache(String objectType) throws CAFPermissionException {
		CacheAccess ma = getCacheAccess(getCacheRuleAccess(), CAF_RULE_CACHE_ID, CAF_ACL_BUSINESSRULE_GROUP, LT_UNLIMITED);
		Object cObj = null;
		
		try {
			cObj = ma.get(objectType);
		} catch (Exception _ex) {
			throw new CAFPermissionException("AUTH_CACHE_READ", new Object[] {"BusinessRule", objectType});
		}

		try {
			if (cObj == null) { 
				cObj = CAFPermissionUtil.fetchBusinessRules(objectType);
				ma.put(objectType,cObj);
			}
		} catch (Exception _ex) {
			try {
				ma.delete(objectType);	
			} catch (Exception e) {
				new CAFPermissionException (e);
			}

			throw new CAFPermissionException("AUTH_NO_BUSINESSRULE", new Object[] {objectType});
		}
		
		return cObj; 
	}

	public static void cacheAllowedAccess(String accessCacheKey) throws CAFPermissionException {
		cacheAllowedAccess(accessCacheKey, true);
	}
	
	
	public static void cacheAllowedAccess(String accessCacheKey, boolean allowed) throws CAFPermissionException {
		CacheAccess cacheAccess =getCacheAccess(getCachePermissionAccess(), CAF_PERMISSION_CACHEID, 
			CAF_ACL_PERMISSION_GROUP,LT_PERMISSION);
		try {
			cacheAccess.put(accessCacheKey, allowed ? ACCESS_GRANDED : ACCESS_DENIED);
		} catch (Exception _ex) {
			throw new CAFPermissionException(_ex);
		}
	}

	/**
	 * Check permission for ACL
	 * @param accessCacheKey
	 * @return Boolean.TRUE if allowed, Boolean.FALSE if denied, null if value not cached, error
	 * @throws PermissionException
	 */
	public static Boolean getAllowed(String accessCacheKey) throws CAFPermissionException {
		CacheAccess cacheAccess = 
			getCacheAccess(getCachePermissionAccess(), CAF_PERMISSION_CACHEID, CAF_ACL_PERMISSION_GROUP,LT_PERMISSION);
		try {
			// Not neccessary to compare strings, we just need to know if key exists and not expired
			String val = (String)cacheAccess.get(accessCacheKey); 
			return (val == null) ? null : ((ACCESS_GRANDED.equals(val)) ? Boolean.TRUE : Boolean.FALSE) ;
		} catch (Exception ex) {
			throw new CAFPermissionException(ex);
			//CAFPublicLogger.LOC_CAF.catching(ex);
			// cache does not work
//			return null;
		}
	}	

	public static boolean isAllowed(String accessCacheKey) throws CAFPermissionException {
		Boolean res = getAllowed(accessCacheKey);
		return (res == null) ? false : res.booleanValue();  
	}	

	public static void invalidCache ()throws CAFPermissionException {
		if (getCacheParamAccess() != null) { 
			invalidParamCache();
		}
			
		if (getCacheRuleAccess() != null) {
			invalidRuleCache();
		}
					
		if (getCachePermissionAccess() != null) {
			invalidPermissionCache();
		}
	}	

	public static void invalidParamCache () throws CAFPermissionException {
		try {
			if (getCacheParamAccess() != null) {
				CacheAccess.destroyRegion(CAF_PARAM_CACHEID);
				setCacheParamAccess(null);
			}
		} catch (CacheException e) {
			new CAFPermissionException (e);
		}
	}

	public static void invalidRuleCache () throws CAFPermissionException {
		try {
			if (getCacheRuleAccess() != null) {
				CacheAccess.destroyRegion(CAF_RULE_CACHE_ID);
				setCacheRuleAccess(null);
			}
		} catch (CacheException _e) {
			throw new CAFPermissionException (_e);
		}
	}

	public static void invalidPermissionCache() throws CAFPermissionException {
		getCacheAccess(getCachePermissionAccess(), CAF_PERMISSION_CACHEID, CAF_ACL_PERMISSION_GROUP,LT_UNLIMITED);
		try {
			if (getCachePermissionAccess() != null) {
				CacheAccess.destroyRegion(CAF_PERMISSION_CACHEID);
				setCachePermissionAccess(null);
			}
		} catch (CacheException _e) {
			throw new CAFPermissionException (_e);
		}
	}

	private static CacheAccess getCacheParamAccess() {
		return 	mCacheParamAccess;	
	}
	private static void setCacheParamAccess(CacheAccess mCacheAccess) {
		mCacheParamAccess = mCacheAccess;	
	}

	private static CacheAccess getCacheRuleAccess() {
		return 	mCacheRuleAccess;	
	}
	private static void setCacheRuleAccess(CacheAccess mCacheAccess) {
		mCacheRuleAccess = mCacheAccess;	
	}

	private static CacheAccess getCachePermissionAccess() {
		return 	mCachePermissionAccess;	
	}
	private static void setCachePermissionAccess(CacheAccess cacheAccess) {
		mCachePermissionAccess = cacheAccess;	
	}

	private static CacheAccess getCacheAccess(CacheAccess mCacheAccess,String cacheId, 
		String domainName, String lifeTime)	throws CAFPermissionException {
		if (mCacheAccess == null) {
			Properties props = new Properties();
			props.put("consistency-domain.domain.name", domainName);
			props.put(CAF_ACL_LIFETIME, lifeTime);
			props.put(CAF_ACL_WEIGHT,WT_SIGNLETON);
			Attributes mDefaultAttributes = new Attributes(props);
			try
			{
				CacheAccess.defineRegion(cacheId,mDefaultAttributes);
				
				mCacheAccess = CacheAccess.getAccess(cacheId);
			}
			catch (CacheNotAvailableException cnaex)
			{
				throw new CAFPermissionException("AUTH_CACHE_CREATE", new Object[] {cacheId, cnaex.getMessage()});
			}
			catch (ObjectExistsException oee)
			{
				try {
					mCacheAccess = CacheAccess.getAccess(cacheId);
				} catch (Exception ex) {
					throw new CAFPermissionException("AUTH_CACHE_ACCESS", new Object[] {cacheId});
				}	
			}
			catch (Exception ex) {
				throw new CAFPermissionException("AUTH_CACHE_ACCESS", new Object[] {cacheId});
			}

			if (CAF_ACL_PARAMETER_GROUP.equals(cacheId)){
				setCacheParamAccess(mCacheAccess);
			}
				
			if (CAF_ACL_BUSINESSRULE_GROUP.equals(cacheId)) {
				setCacheRuleAccess(mCacheAccess);
			}
				
			if (CAF_ACL_PERMISSION_GROUP.equals(cacheId)) {
				setCachePermissionAccess(mCacheAccess);
			}
		}
		return mCacheAccess;
	}

}
