package com.sap.caf.rt.security.util;


import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

/**
 * @author c5047345
 */
public class CAFBusinessRuleList extends ArrayList {
	private static final Class[] NO_ARGUMENTS = new Class[0];
	private static final Object[] NO_PARAMETERS = new Class[0];
	private static final String KEY_METHOD = "getKey";

	private static final Comparator CONDITIONS_OBJECT_COMPARATOR = new Comparator()
	{
		public int compare(final Object o1, final Object o2)
		{
			final CAFBusinessConditionBean co1 = (CAFBusinessConditionBean)o1;
			final CAFBusinessConditionBean co2 = (CAFBusinessConditionBean)o2;
			
			return co1.getattributeName().compareTo(co2.getattributeName());			
		}
	};

	private List m_attributeList;
	private Method[] m_getMethodList;
	private Method keyMethod;

	public CAFBusinessRuleList(int rulesSize,List attributeList) {
		super(rulesSize);
		setAttributes(attributeList);
		m_getMethodList = new Method[attributeList.size()];
	}

//	public Object getKey(Object object) throws Exception {
//		if (keyMethod == null || !keyMethod.getDeclaringClass().isInstance(object)) {
//			keyMethod = object.getClass().getMethod(KEY_METHOD, NO_ARGUMENTS);
//		}
//		return keyMethod.invoke(object, NO_PARAMETERS);
//	}

	public Object getProperty(Object object, String attributeName) {
		return null;
	}

	public Method getMethod(Object object, int attributeIndex) throws NoSuchMethodException {
		Method method = m_getMethodList[attributeIndex];
		if (method == null || !method.getDeclaringClass().isInstance(object)) {
			synchronized (this) {
				final String attrName = (String) m_attributeList.get(attributeIndex);
				final String methodName =
					"get" + attrName.substring(0, 1).toUpperCase() + attrName.substring(1);
				method = object.getClass().getMethod(methodName, NO_ARGUMENTS);
				m_getMethodList[attributeIndex] = method;
			}
		}
		return method;
	}

	private void setAttributes(List attributeList) {
		m_attributeList = attributeList;
	}

	public int getAttributeIndex(String attribute) {
		final int size = m_attributeList.size();
		for (int i = 0; i < size; i++) {
			if (attribute.equals(m_attributeList.get(i))) {
				return i;
			}
		}
		return -1;
	}
	
	public Object[] getEmptyAttributeCache() {
		return new Object[m_attributeList.size()];		
	}
	
	public boolean objectFulfillBusinessRuleCondition(Object object,int businessRuleIndex,
		Object[] attrCache) throws Exception {
			
		CAFBusinessRuleBean businessRule = getBusinessRule(businessRuleIndex);
	
		List conditionList = businessRule.getConditions();
		
		//sort by Attribute name
		//TODO: Sorting move to retrieveBusinessRulesList? 
		Collections.sort(conditionList, CONDITIONS_OBJECT_COMPARATOR);
		
		String previousAttributeName = "";
		boolean resultOperationOR = true;
		boolean resultOperationAND = true;
		
		for(int i=0, size = conditionList.size(); i<size; i++) {
			CAFBusinessConditionBean condition = (CAFBusinessConditionBean)conditionList.get(i);
			
			//get the value of an attribute by index
			int attrIndex = condition.getAttributeIndex();
			Object attrValue = attrCache[attrIndex]; 
			if (object!=null && attrValue==null) {
				Method method = getMethod(object,attrIndex);
				attrValue = method.invoke(object,NO_PARAMETERS);
				attrCache[attrIndex] = attrValue; 
			}
			 
			String currentAttributeName = condition.getattributeName();
			//if attribute is new
			if (!previousAttributeName.equals(currentAttributeName)) {
				//perform AND operation between previous set of the same attributes and current set
				resultOperationAND = resultOperationAND && resultOperationOR;
				//if result of AND operation is False, then final result is False in any case
				if (!resultOperationAND) {
					return false;
				}
				resultOperationOR = false;
			}
			//perform OR operation between results of condition of the same attributes
			//in case attribute is a Collection
			if (attrValue instanceof Collection) {
				boolean resultForCollectionAttributeAND = true;
				//iterate through all values of collection with performing AND operation
				for (Iterator iter = ((Collection)attrValue).iterator();iter.hasNext();) {
					resultForCollectionAttributeAND = resultForCollectionAttributeAND && condition.valueFulfillCondition(iter.next());
				}
				resultOperationOR = resultOperationOR || resultForCollectionAttributeAND;
			} else {
				resultOperationOR = resultOperationOR || condition.valueFulfillCondition(attrValue);
			}
			previousAttributeName = currentAttributeName;
		}
		//perform AND operation between previous set of the same attributes and last
		resultOperationAND = resultOperationAND && resultOperationOR;
		return resultOperationAND;
	}
	
	public CAFBusinessRuleBean getBusinessRule(int index) {
		return (CAFBusinessRuleBean)get(index);
	}
}
