package com.sap.caf.rt.security.util;

import java.text.DateFormat;
import java.util.Date;

import com.sap.caf.rt.util.CAFPublicLogger;
import com.sap.caf.rt.exception.CAFPermissionException;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.Severity;

/**
 * @author c5047345
 *
 * To change the template for this generated type comment go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
public class CAFBusinessConditionBean {

	private static final String APPLICATION = CAFBusinessConditionBean.class.getName();
	private static final Location LOGGER = Location.getLocation(APPLICATION);
	private static final String JARMREQPREFIX = "CAF:RT:security:";
	private static final String JARMREQUEST = JARMREQPREFIX+APPLICATION;

	private static final DateFormat DATE_FORMAT = DateFormat.getDateInstance();

	private String m_conditionID;
	private String m_attributeName;
	private String m_operator;

	private int m_attributeIndex;

	private Integer m_intLowValue;
	private Date m_dateLowValue;
	private String m_strLowValue;

	private Integer m_intHighValue;
	private Date m_dateHighValue;
	private String m_strHighValue;

	private boolean equal = false;
	private boolean between = false;
	private boolean greaterThan = false;
	private boolean greaterEqual = false;
	private boolean lessThan = false;
	private boolean lessEqual = false;
	private boolean notEqual = false;

	public CAFBusinessConditionBean(String conditionID, String attrName, String lowValue, 
		String highValue, String operator,int attributeIndex) throws CAFPermissionException {
			
			String method = "CAFBusinessConditionBean(String, String, String, String, String, int)";

			m_conditionID = conditionID;
			m_attributeName = attrName;
			m_strLowValue = lowValue;
			m_strHighValue = highValue;
			m_attributeIndex = attributeIndex;

			try {
				m_intLowValue = Integer.valueOf(lowValue);
				m_intHighValue = Integer.valueOf(highValue);
			} catch (Exception e) {
				String message = "Condition "+getConditionId()+ " " + "can't be considered for Integer values :"+e.getMessage();
				CAFPublicLogger.traceThrowableT(Severity.ERROR,LOGGER,method,message,e);
			}

			try {
				m_dateLowValue = DATE_FORMAT.parse(lowValue);
				m_dateHighValue = DATE_FORMAT.parse(highValue);
			} catch (Exception e) {
				String message = "Condition "+getConditionId()+ " " + "can't be considered for Date values :"+e.getMessage();
				CAFPublicLogger.traceThrowableT(Severity.ERROR,LOGGER,method,message,e);
			}

			m_operator = operator;
			if (m_operator.startsWith(CAFPermissionOperator.BT)) {
				between = true;
			} else if (m_operator.startsWith(CAFPermissionOperator.EQ)) {
				equal = true;
			} else if (m_operator.startsWith(CAFPermissionOperator.GT)) {
				greaterThan = true;
			} else if (m_operator.startsWith(CAFPermissionOperator.GE)) {
				greaterEqual = true;
			} else if (m_operator.startsWith(CAFPermissionOperator.LT)) {
				lessThan = true;
			} else if (m_operator.startsWith(CAFPermissionOperator.LE)) {
				lessEqual = true;
			} else	{
		
				throw new CAFPermissionException(
					"AUTH_CONDITION_OPERATOR", new Object[] {m_operator, conditionID});
			}
	}

	public String getConditionId() {
		return m_conditionID;
	}

	public String getattributeName() {
		return m_attributeName;
	}

	public String getLowValue() {
		return m_strLowValue;
	}

	public String getHighValue() {
		return m_strHighValue;
	}

	public String getOperator() {
		return m_operator;
	}

	public boolean isBetween() {
		return between;
	}

	public boolean isEqual() {
		return equal;
	}

	public boolean isGreaterThan() {
		return greaterThan;
	}

	public boolean isGreaterEqual() {
		return greaterEqual;
	}

	public boolean isLessThan() {
		return lessThan;
	}

	public boolean isLessEqual() {
		return lessEqual;
	}

	public boolean isNotEqual() {
		return notEqual; 
	}

	public int getAttributeIndex() {
		return m_attributeIndex;
	}

	protected boolean valueFulfillCondition(Object value) throws CAFPermissionException {
		if (value==null) {
			return false;
		}
		Comparable lowValue;
		Comparable highValue;
		if (value instanceof String) {
			lowValue = m_strLowValue;
			highValue = m_strHighValue;
		} else if (value instanceof Integer) {
			lowValue = m_intLowValue;
			highValue = m_intHighValue;
		} else if (value instanceof Date) {
			lowValue = m_dateLowValue;
			highValue = m_dateHighValue;
		} else {
			throw new CAFPermissionException("AUTH_CONDITION_DATATYPE", new Object[] {value.getClass().getName(), getattributeName()});			
		}

		if (isEqual()) {
			return lowValue.equals(value);
		} if (isNotEqual()) {
			return !lowValue.equals(value);
		} else if (isBetween()) {
			return lowValue.compareTo(value) <= 0 && highValue.compareTo(value) >= 0;
		} else if (isGreaterThan()) {
			return lowValue.compareTo(value) < 0;
		} else if (isGreaterEqual()) {
			return lowValue.compareTo(value) <= 0;
		} else if (isLessThan()) {
			return lowValue.compareTo(value) > 0;
		} else if (isLessEqual()) {
			return lowValue.compareTo(value) >= 0;
		} else {
			return false;
		}
	}
	

}
