package com.sap.caf.rt.security.srv;

import java.security.BasicPermission;

/**
 * @author d025479
 *
 * To change the template for this generated type comment go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */

public final class ServicePermission extends BasicPermission
{

  /**
   * constructor
   *
   * @param String permission name
   */
  public ServicePermission(String name)
  {
    super(name);
  }

  /**
   * The action of java.security.BasicPermission are redirected to the
   * permission String. This allows to inherit the behaviour from BasicPermission
   * while at the same time support simple configuration in UME via permission value
   * which in turn uses the action argument to pass the value
   *
   * @param String name, the permission name
   * @param String value, argument that allows further specification in addition to the name
   */
  public ServicePermission(String name, String value)
  {
    super(name + "." + value);
  }
  
}