/*
 * Created on May 10, 2004
 *
 * To change the template for this generated file go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
package com.sap.caf.rt.security.bol;

import java.util.Collection;

import com.sap.caf.rt.bol.EntityServiceBase;
import com.sap.caf.rt.exception.BEException;
import com.sap.caf.rt.security.acl.impl.CAFPermission;
import com.sap.caf.rt.util.CAFPublicLogger;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.Severity;

/**
 * @author trendafil-m
 *
 * To change the template for this generated type comment go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
public abstract class EntityServiceAuth extends EntityServiceBase {

	private static final String APPLICATION = EntityServiceAuth.class.getName();
	private static final Location LOGGER = Location.getLocation(APPLICATION);
	private static final String JARMREQPREFIX = "CAF:RT:security:";
	private static final String JARMREQUEST = JARMREQPREFIX+APPLICATION;

	public void addAuthUser(String userId, String permission, String primaryKey) throws BEException {
		final String method = "addAuthUser(String, String, String)";
		CAFPublicLogger.entering(null, JARMREQUEST, method, LOGGER, 1);

		String user = sessionContext.getCallerPrincipal().getName();
		try {
			CAFPermission.createPermission(user,primaryKey,permission,userId);
		} catch (Exception e) {
			CAFPublicLogger.traceThrowableT(Severity.DEBUG,LOGGER,method,e.getMessage(),e);
			throw new BEException(e);
		} finally {
			CAFPublicLogger.exiting(null, JARMREQUEST, method, LOGGER, 1);
		}
	}

	public void removeAuthUser(String userId,String permission,String primaryKey) throws BEException {
		final String method = "removeAuthUser(String, String, String)";
		CAFPublicLogger.entering(null, JARMREQUEST, method, LOGGER, 1);

		String user = sessionContext.getCallerPrincipal().getName();
		try {
			CAFPermission.removePermission(user,primaryKey,permission,userId);
		} catch (Exception e) {
			CAFPublicLogger.traceThrowableT(Severity.DEBUG,LOGGER,method,e.getMessage(),e);
			throw new BEException(e);
		} finally {
			CAFPublicLogger.exiting(null, JARMREQUEST, method, LOGGER, 1);
		}
	}

	public Collection getAuthUser(String permission,String primaryKey) throws BEException {
		final String method = "getAuthUser(String, String)";
		CAFPublicLogger.entering(null, JARMREQUEST, method, LOGGER, 1);

		String user = sessionContext.getCallerPrincipal().getName();
		Collection result = null;
		try {
			result = CAFPermission.retrievePermission(user,primaryKey,permission,user);
		} catch (Exception e) {
			CAFPublicLogger.traceThrowableT(Severity.DEBUG,LOGGER,method,e.getMessage(),e);
			throw new BEException(e);
		} finally {
			CAFPublicLogger.exiting(null, JARMREQUEST, method, LOGGER, 1);
		}
		return result;
	}
}