package com.sap.caf.rt.security.acl.impl.permission;

import java.util.Collections;
import java.util.Date;
import java.util.List;

import com.sap.caf.rt.bol.IDependentObject;
import com.sap.caf.rt.bol.pk.AbstractPrimaryKey;

/**
 * @author c5051699
 */
public class PermissionVo implements IDependentObject {

	public static final String PROVIDER = "sap.com";
	public static final String APPLICATION = "caf.core";
	public static final String BE_SRV_NAME = "Permission";
	public static final String OBJECT_NAME = PROVIDER + "/" + APPLICATION + "/" + BE_SRV_NAME;

	private String key;
	private String permissionName;
	private String principalName;
	private String principalID;
	private String businessRuleID;
	private String nameBackUp;
	private String principalType;
	private String createdBy;
	private String changedBy;
	private Date createdAt;
	private Date changedAt;


	public AbstractPrimaryKey getPK() {
		return new PermissionPK(key);
	}

	/* (non-Javadoc)
	 * @see com.sap.caf.rt.security.util.IDependentObject#getObjectType()
	 */
	public String getObjectType() {
		return OBJECT_NAME;
	}

	/* (non-Javadoc)
	 * @see com.sap.caf.rt.security.util.IDependentObject#getPropertyList()
	 */
	public List getPropertyList() {
		return Collections.EMPTY_LIST;
	}

	/* (non-Javadoc)
	 * @see com.sap.caf.rt.security.util.IDependentObject#getProperty(java.lang.String)
	 */
	public Object getProperty(String propertyName) {
		return null;
	}

	/* (non-Javadoc)
	 * @see com.sap.caf.rt.security.util.IDependentObject#setProperty(java.lang.String, java.lang.Object)
	 */
	public void setProperty(String propertyName, Object propertyValue) {
	}


	/**
	 * @return
	 */
	public Date getChangedAt() {
		return changedAt;
	}

	/**
	 * @return
	 */
	public String getChangedBy() {
		return changedBy;
	}

	/**
	 * @return
	 */
	public String getKey() {
		return key;
	}

	/**
	 * @return
	 */
	public Date getCreatedAt() {
		return createdAt;
	}

	/**
	 * @return
	 */
	public String getCreatedBy() {
		return createdBy;
	}

	/**
	 * @return
	 */
	public String getBusinessRuleID() {
		return businessRuleID;
	}


	/**
	 * @param Date
	 */
	public void setChangedAt(Date date) {
		changedAt = date;
	}

	/**
	 * @param string
	 */
	public void setChangedBy(String string) {
		changedBy = string;
	}

	/**
	 * @param string
	 */
	public void setKey(String string) {
		key = string;
	}

	/**
	 * @param Date
	 */
	public void setCreatedAt(Date date) {
		createdAt = date;
	}

	/**
	 * @param string
	 */
	public void setCreatedBy(String string) {
		createdBy = string;
	}

	/**
	 * @param string
	 */
	public void setBusinessRuleID(String string) {
		businessRuleID = string;
	}


	/**
	 * @return
	 */
	public String getNameBackUp()
	{
		return nameBackUp;
	}

	/**
	 * @return
	 */
	public String getPermissionName()
	{
		return permissionName;
	}

	/**
	 * @return
	 */
	public String getPrincipalID()
	{
		return principalID;
	}

	/**
	 * @return
	 */
	public String getPrincipalName()
	{
		return principalName;
	}

	/**
	 * @return
	 */
	public String getPrincipalType()
	{
		return principalType;
	}

	/**
	 * @param string
	 */
	public void setNameBackUp(String string)
	{
		nameBackUp = string;
	}

	/**
	 * @param string
	 */
	public void setPermissionName(String string)
	{
		permissionName = string;
	}

	/**
	 * @param string
	 */
	public void setPrincipalID(String string)
	{
		principalID = string;
	}

	/**
	 * @param string
	 */
	public void setPrincipalName(String string)
	{
		principalName = string;
	}

	/**
	 * @param string
	 */
	public void setPrincipalType(String string)
	{
		principalType = string;
	}

}
