package com.sap.caf.rt.security.acl.impl.objectvalue;

import java.util.Collections;
import java.util.Date;
import java.util.List;

import com.sap.caf.rt.bol.IDependentObject;
import com.sap.caf.rt.bol.pk.AbstractPrimaryKey;

/**
 * @author c5051699
 */
public class ObjectValueVo implements IDependentObject {

	public static final String PROVIDER = "sap.com";
	public static final String APPLICATION = "caf.core";
	public static final String BE_SRV_NAME = "ObjectValue";
	public static final String OBJECT_NAME = PROVIDER + "/" + APPLICATION + "/" + BE_SRV_NAME;

	private String key;
	private String createdBy;
	private String changedBy;
	private Date createdAt;
	private Date changedAt;
	private String objectTypeID;
	private String objectID;
	private String attributeName;
	private String attributeValue;

	public ObjectValueVo() {
	}

	public ObjectValueVo(String key, String objectTypeID, String objectID, String attributeName, String attributeValue) {
		this.key = key;
		this.objectTypeID = objectTypeID;
		this.objectID = objectID;
		this.attributeName = attributeName;
		this.attributeValue = attributeValue;
	}

	public AbstractPrimaryKey getPK() {
		return new ObjectValuePK(key);
	}

	/* (non-Javadoc)
	 * @see com.sap.caf.rt.security.util.IDependentObject#getObjectID()
	 */
	public String getObjectID() {
		return objectID;
	}

	/* (non-Javadoc)
	 * @see com.sap.caf.rt.security.util.IDependentObject#getPropertyList()
	 */
	public List getPropertyList() {
		return Collections.EMPTY_LIST;
	}

	/* (non-Javadoc)
	 * @see com.sap.caf.rt.security.util.IDependentObject#getProperty(java.lang.String)
	 */
	public Object getProperty(String propertyName) {
		return null;
	}

	/* (non-Javadoc)
	 * @see com.sap.caf.rt.security.util.IDependentObject#setProperty(java.lang.String, java.lang.Object)
	 */
	public void setProperty(String propertyName, Object propertyValue) {
	}

	/**
	 * @return
	 */
	public String getObjectTypeID() {
		return objectTypeID;
	}

	/**
	 * @return
	 */
	public Date getChangedAt() {
		return changedAt;
	}

	/**
	 * @return
	 */
	public String getChangedBy() {
		return changedBy;
	}

	/**
	 * @return
	 */
	public Date getCreatedAt() {
		return createdAt;
	}

	/**
	 * @return
	 */
	public String getCreatedBy() {
		return createdBy;
	}

	/**
	 * @return
	 */
	public String getKey() {
		return key;
	}

	/**
	 * @return
	 */
	public String getAttributeName() {
		return attributeName;
	}

	/**
	 * @return
	 */
	public String getAttributeValue() {
		return attributeValue;
	}

	/**
	 * @param string
	 */
	public void setObjectTypeID(String string) {
		objectTypeID = string;
	}

	/**
	 * @param string
	 */
	public void setObjectID(String string) {
		objectID = string;
	}

	/**
	 * @param timestamp
	 */
	public void setChangedAt(Date date) {
		changedAt = date;
	}

	/**
	 * @param string
	 */
	public void setChangedBy(String string) {
		changedBy = string;
	}

	/**
	 * @param timestamp
	 */
	public void setCreatedAt(Date timestamp) {
		createdAt = timestamp;
	}

	/**
	 * @param string
	 */
	public void setCreatedBy(String string) {
		createdBy = string;
	}

	/**
	 * @param string
	 */
	public void setKey(String string) {
		key = string;
	}

	/**
	 * @param string
	 */
	public void setAttributeValue(String string) {
		attributeValue = string;
	}

	/**
	 * @param string
	 */
	public void setAttributeName(String string) {
		attributeName = string;
	}

	public String getObjectType() {
		return OBJECT_NAME;
	}

}