package com.sap.caf.rt.security.acl.impl.objectvalue;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.StringTokenizer;

import javax.ejb.SessionBean;

import com.sap.caf.metamodel.Attribute;
import com.sap.caf.metamodel.DataObject;
import com.sap.caf.rt.bol.IDependentObject;
import com.sap.caf.rt.exception.ServiceException;
import com.sap.caf.rt.security.acl.impl.SecurityServiceBase;
import com.sap.caf.rt.security.util.CAFPermissionUtil;
import com.sap.caf.rt.util.CAFPublicLogger;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.Severity;
/**
 * @ejbLocal <{com.sap.caf.rt.security.acl.impl.objectvalue.ObjectValueLocal}>
 * @ejbLocalHome <{com.sap.caf.rt.security.acl.impl.objectvalue.ObjectValueLocalHome}>
 * @stateless 
 */

/**
 * @author c5051699
 */

public class ObjectValueBean extends SecurityServiceBase implements SessionBean {

	private static final String APPLICATION = ObjectValueBean.class.getName();
	private static final Location LOGGER = Location.getLocation(APPLICATION);
	private static final String JARMREQPREFIX = "CAF:RT:security:";
	private static final String JARMREQUEST = JARMREQPREFIX+APPLICATION;

	public Collection findByObjectID(String objectID, String objectTypeID) throws ServiceException {
		final String method = "findByObjectID(String, String)";
		CAFPublicLogger.entering(null, JARMREQUEST, method, LOGGER, 1);

		Collection result = null;
		try {
			IDependentObject object = CAFPermissionUtil.getDependentObject(objectID, objectTypeID) ;
			result = getObjectValues(object, objectTypeID) ;
		} catch (Exception e) {
			getSessionContext().setRollbackOnly();
			CAFPublicLogger.traceThrowableT(Severity.ERROR, LOGGER, method, e.getMessage(), e);
			throw new ServiceException(e);
		} finally {
			CAFPublicLogger.exiting(null, JARMREQUEST, method, LOGGER, 1);
		}
		return result;
	}

	public ObjectValueVo findByPrimaryKey(String objectValueID) throws ServiceException {
		final String method = "findByPrimaryKey(String)";
		CAFPublicLogger.entering(null, JARMREQUEST, method, LOGGER, 1);

		ObjectValueVo objectValueVo = null;
		try {
			StringTokenizer st = new StringTokenizer(objectValueID, ":");
			String objectID = st.nextToken();
			String objectType = st.nextToken();
			String attributeName = st.nextToken();
			
			IDependentObject object = CAFPermissionUtil.getDependentObject(objectID, objectType) ;

			Object attributeValue = object.getProperty(attributeName) ;
				
			objectValueVo = new ObjectValueVo() ;
			objectValueVo.setKey(objectValueID);
			objectValueVo.setObjectID(objectID) ;
			objectValueVo.setObjectTypeID(objectType) ;
			objectValueVo.setAttributeName(attributeName) ;
			objectValueVo.setAttributeValue((attributeValue==null)?null:attributeValue.toString()) ;

		} catch (Exception e) {
			getSessionContext().setRollbackOnly();
			CAFPublicLogger.traceThrowableT(Severity.ERROR, LOGGER, method, e.getMessage(), e);
			throw new ServiceException(e);
		} finally {
			CAFPublicLogger.exiting(null, JARMREQUEST, method, LOGGER, 1);
		}
		return objectValueVo;
	}

	private Collection getObjectValues(IDependentObject object, String objectType) throws ServiceException {
		final String method = "getObjectValues(IDependentObject, String)";
		
		Collection result = new ArrayList();
		try
		{
			DataObject dataObject = CAFPermissionUtil.getDataObject( objectType );

			for (Iterator iter = dataObject.getAttributes().iterator(); iter.hasNext() ;)
			{
				Attribute attribute = (Attribute)iter.next();
				String attributeName = attribute.getObjectName();

				Object attributeValue = object.getProperty(attributeName) ;
				String objectID = object.getKey();
				String objectValueID = objectID + ":" + objectType + ":" + attributeName;
				
				ObjectValueVo objectValueVo = new ObjectValueVo() ;
				objectValueVo.setKey(objectValueID);
				objectValueVo.setObjectID(objectID) ;
				objectValueVo.setObjectTypeID(objectType) ;
				objectValueVo.setAttributeName(attributeName) ;
				objectValueVo.setAttributeValue((attributeValue==null)?null:attributeValue.toString()) ;
				
				result.add(objectValueVo) ;
			}			
		} catch (Exception e) {
			CAFPublicLogger.traceThrowableT(Severity.ERROR, LOGGER, method, e.getMessage(), e);
			throw new ServiceException(e.getMessage());
		}	
		return result;
	}


}