package com.sap.caf.rt.security.acl.impl.objecttype;

import java.util.Collections;
import java.util.Date;
import java.util.List;

import com.sap.caf.rt.bol.IDependentObject;
import com.sap.caf.rt.bol.pk.AbstractPrimaryKey;

/**
 * @author c5051699
 */

public class ObjectTypeVo implements IDependentObject {

	public static final String PROVIDER = "sap.com";
	public static final String APPLICATION = "caf.core";
	public static final String BE_SRV_NAME = "ObjectType";
	public static final String OBJECT_NAME = PROVIDER + "/" + APPLICATION + "/" + BE_SRV_NAME;
	
	private String key;
	private String objectType;
	private String createdBy;
	private String changedBy;
	private Date createdAt;
	private Date changedAt;

	public ObjectTypeVo() {
	}

	public ObjectTypeVo(String key, String objectType) {
		this.key = key;
		this.objectType = objectType;
	}

	public AbstractPrimaryKey getPK() {
		return new ObjectTypePK(key);
	}
	/* (non-Javadoc)
	 * @see com.sap.caf.rt.security.util.IDependentObject#getObjectType()
	 */
	public String getObjectType() {
		return objectType;
	}

	/* (non-Javadoc)
	 * @see com.sap.caf.rt.security.util.IDependentObject#getPropertyList()
	 */
	public List getPropertyList() {
		return Collections.EMPTY_LIST;
	}

	/* (non-Javadoc)
	 * @see com.sap.caf.rt.security.util.IDependentObject#getProperty(java.lang.String)
	 */
	public Object getProperty(String propertyName) {
		return null;
	}

	/* (non-Javadoc)
	 * @see com.sap.caf.rt.security.util.IDependentObject#setProperty(java.lang.String, java.lang.Object)
	 */
	public void setProperty(String propertyName, Object propertyValue) {
	}

	/**
	 * @return
	 */
	public String getKey() {
		return key;
	}

	/**
	 * @return
	 */
	public Date getChangedAt() {
		return changedAt;
	}

	/**
	 * @return
	 */
	public String getChangedBy() {
		return changedBy;
	}

	/**
	 * @return
	 */
	public Date getCreatedAt() {
		return createdAt;
	}

	/**
	 * @return
	 */
	public String getCreatedBy() {
		return createdBy;
	}

	/**
	 * @param string
	 */
	public void setKey(String string) {
		key = string;
	}

	/**
	 * @param timestamp
	 */
	public void setChangedAt(Date timestamp) {
		changedAt = timestamp;
	}

	/**
	 * @param string
	 */
	public void setChangedBy(String string) {
		changedBy = string;
	}

	/**
	 * @param timestamp
	 */
	public void setCreatedAt(Date timestamp) {
		createdAt = timestamp;
	}

	/**
	 * @param string
	 */
	public void setCreatedBy(String string) {
		createdBy = string;
	}

	/**
	 * @param string
	 */
	public void setObjectType(String string) {
		objectType = string;
	}

}
