package com.sap.caf.rt.security.acl.impl.objectattribute;
 
import java.util.Collections;
import java.util.List; 

import com.sap.caf.rt.bol.IDependentObject;
import com.sap.caf.rt.bol.pk.AbstractPrimaryKey;

/**
 * @author c5051699
 */

public class ObjectAttributeVo implements IDependentObject {

	public static final String PROVIDER = "sap.com";
	public static final String APPLICATION = "caf.core";
	public static final String BE_SRV_NAME = "ObjectAttribute";
	public static final String OBJECT_NAME = PROVIDER + "/" + APPLICATION + "/" + BE_SRV_NAME;
	
	private String key;
	private String objectTypeID;
	private String sequenceNumber;
	private String objectAttributeName;
	private String createdBy;
	private String changedBy;
	private java.util.Date createdAt;
	private java.util.Date  changedAt;

	
	public ObjectAttributeVo(){ 
	}

	public AbstractPrimaryKey getPK() {
		return new ObjectAttributePK(key);
	}
	
	/* (non-Javadoc)
	 * @see com.sap.caf.rt.security.util.IDependentObject#getObjectType()
	 */
	public String getObjectType() {
		return OBJECT_NAME;
	}

	/* (non-Javadoc)
	 * @see com.sap.caf.rt.security.util.IDependentObject#getPropertyList()
	 */
	public List getPropertyList() {
		return Collections.EMPTY_LIST;
	}

	/* (non-Javadoc)
	 * @see com.sap.caf.rt.security.util.IDependentObject#getProperty(java.lang.String)
	 */
	public Object getProperty(String propertyName) {
		return null;
	}

	/* (non-Javadoc)
	 * @see com.sap.caf.rt.security.util.IDependentObject#setProperty(java.lang.String, java.lang.Object)
	 */
	public void setProperty(String propertyName, Object propertyValue) {
	}

	/**
	 * @return
	 */
	public String getKey() {
		return key;
	}

	/**
	 * @return
	 */
	public String getObjectAttributeName() {
		return objectAttributeName;
	}

	/**
	 * @return
	 */
	public String getObjectTypeID() {
		return objectTypeID;
	}

	/**
	 * @return
	 */
	public java.util.Date getChangedAt() {
		return changedAt;
	}

	/**
	 * @return
	 */
	public String getChangedBy() {
		return changedBy;
	}

	/**
	 * @return
	 */
	public java.util.Date getCreatedAt() {
		return createdAt;
	}

	/**
	 * @return
	 */
	public String getCreatedBy() {
		return createdBy;
	}

	/**
	 * @return
	 */
	public String getSequenceNumber() {
		return sequenceNumber;
	}

	/**
	 * @param string
	 */
	public void setKey(String string) {
		key = string;
	}

	/**
	 * @param string
	 */
	public void setObjectAttributeName(String string) {
		objectAttributeName = string;
	}

	/**
	 * @param string
	 */
	public void setObjectTypeID(String string) {
		objectTypeID = string;
	}

	/**
	 * @param timestamp
	 */
	public void setChangedAt(java.util.Date timestamp) {
		changedAt = timestamp;
	}

	/**
	 * @param string
	 */
	public void setChangedBy(String string) {
		changedBy = string;
	}

	/**
	 * @param timestamp
	 */
	public void setCreatedAt(java.util.Date timestamp) {
		createdAt = timestamp;
	}

	/**
	 * @param string
	 */
	public void setCreatedBy(String string) {
		createdBy = string;
	}

	/**
	 * @param string
	 */
	public void setSequenceNumber(String string) {
		sequenceNumber = string;
	}

}
