package com.sap.caf.rt.security.acl.impl.objectattribute;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

import javax.ejb.SessionBean;

import com.sap.caf.metamodel.Attribute;
import com.sap.caf.metamodel.DataObject;
import com.sap.caf.rt.exception.ServiceException;
import com.sap.caf.rt.security.acl.impl.SecurityServiceBase;
import com.sap.caf.rt.security.util.CAFPermissionUtil;
import com.sap.caf.rt.util.CAFPublicLogger;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.Severity;

/**
 * @ejbLocal <{com.sap.caf.rt.security.acl.impl.objectattribute.ObjectAttributeLocal}>
 * @ejbLocalHome <{com.sap.caf.rt.security.acl.objectattribute.ObjectAttributeLocalHome}>
 * @stateless 
 * @transactionAttribute Required
 */

/**
 * @author c5051699
 */
public class ObjectAttributeBean extends SecurityServiceBase implements SessionBean {

	private static final String APPLICATION = ObjectAttributeBean.class.getName();
	private static final Location LOGGER = Location.getLocation(APPLICATION);
	private static final String JARMREQPREFIX = "CAF:RT:security:";
	private static final String JARMREQUEST = JARMREQPREFIX+APPLICATION;

	public ObjectAttributeVo findByPrimaryKey(String objectAttributeID) throws ServiceException {
		final String method = "findByPrimaryKey(String)";
		CAFPublicLogger.entering(null, JARMREQUEST, method, LOGGER, 1);
		
		ObjectAttributeVo objectAttributeVo = null;
		try {
			Attribute attribute = CAFPermissionUtil.getAttribute(objectAttributeID);
			String attributeId = attribute.getObjectId();
			String attributeName = attribute.getObjectName();
				
			objectAttributeVo = new ObjectAttributeVo();

			objectAttributeVo.setKey( attributeId );
			objectAttributeVo.setObjectAttributeName( attributeName );
			
		} catch (Exception e) {
			getSessionContext().setRollbackOnly();
			CAFPublicLogger.traceThrowableT(Severity.ERROR, LOGGER, method, e.getMessage(), e);
			throw new ServiceException(e);
		} finally {
			CAFPublicLogger.exiting(null, JARMREQUEST, method, LOGGER, 1);
		}
		return objectAttributeVo;
	}

	public Collection findByObjectTypeID(String objectTypeID) throws ServiceException {
		final String method = "findByObjectTypeID(String)";
		CAFPublicLogger.entering(null, JARMREQUEST, method, LOGGER, 1);
		
		Collection result = new ArrayList();
		try {
			DataObject dataObject = CAFPermissionUtil.getDataObjectByGUID( objectTypeID );
			Collection attributes = dataObject.getAttributes();

			for (Iterator it = attributes.iterator(); it.hasNext();) 
			{
				Attribute attribute = (Attribute)it.next();
				String attributeId = attribute.getObjectId();
				String attributeName = attribute.getObjectName();
				
				ObjectAttributeVo objectAttributeVo = new ObjectAttributeVo();

				objectAttributeVo.setKey( attributeId );
				objectAttributeVo.setObjectAttributeName( attributeName );
				objectAttributeVo.setObjectTypeID( objectTypeID );
										
				result.add(objectAttributeVo);
			}
		} catch (Exception e) {
			getSessionContext().setRollbackOnly();
			CAFPublicLogger.traceThrowableT(Severity.ERROR, LOGGER, method, e.getMessage(), e);
			throw new ServiceException(e);
		} finally {
			CAFPublicLogger.exiting(null, JARMREQUEST, method, LOGGER, 1);
		}

		return result;
	}
}
