package com.sap.caf.rt.security.acl.impl.businessrule;

import java.util.Collections;
import java.util.Date;
import java.util.List;

import com.sap.caf.rt.bol.IDependentObject;
import com.sap.caf.rt.bol.pk.AbstractPrimaryKey;

/**
 * @author c5051699
 */
public class BusinessRuleVo implements IDependentObject {

	public static final String PROVIDER = "sap.com";
	public static final String APPLICATION = "caf.core";
	public static final String BE_SRV_NAME = "BusinessRule";
	public static final String OBJECT_NAME = PROVIDER + "/" + APPLICATION + "/" + BE_SRV_NAME;

	private String key;
	private String ruleIdForAcl;
	private String objectTypeID;
	private String objectType;
	private String businessRuleName;
	private String createdBy;
	private String changedBy;
	private Date createdAt;
	private Date changedAt;

	public BusinessRuleVo() {
	}

	public BusinessRuleVo(String key,	String ruleIdForAcl, String objectTypeID, String objectType, String ruleName) {
		this.businessRuleName = ruleName;
		this.key = key;
		this.objectTypeID = objectTypeID;
		this.objectType = objectType;
		this.ruleIdForAcl = ruleIdForAcl;
	}

	public AbstractPrimaryKey getPK() {
		return new BusinessRulePK(key);
	}

	/* (non-Javadoc)
	 * @see com.sap.caf.rt.security.util.IDependentObject#getObjectType()
	 */
	public String getObjectType() {
		return OBJECT_NAME;
	}

	/* (non-Javadoc)
	 * @see com.sap.caf.rt.security.util.IDependentObject#getPropertyList()
	 */
	public List getPropertyList() {
		return Collections.EMPTY_LIST;
	}

	/* (non-Javadoc)
	 * @see com.sap.caf.rt.security.util.IDependentObject#getProperty(java.lang.String)
	 */
	public Object getProperty(String propertyName) {
		return null;
	}

	/* (non-Javadoc)
	 * @see com.sap.caf.rt.security.util.IDependentObject#setProperty(java.lang.String, java.lang.Object)
	 */
	public void setProperty(String propertyName, Object propertyValue) {
	}

	/**
	 * @return
	 */
	public String getObjectTypeID() {
		return objectTypeID;
	}

	/**
	 * @return
	 */
	public Date getChangedAt() {
		return changedAt;
	}

	/**
	 * @return
	 */
	public String getChangedBy() {
		return changedBy;
	}

	/**
	 * @return
	 */
	public Date getCreatedAt() {
		return createdAt;
	}

	/**
	 * @return
	 */
	public String getCreatedBy() {
		return createdBy;
	}

	/**
	 * @return
	 */
	public String getKey() {
		return key;
	}

	/**
	 * @return
	 */
	public String getRuleIdForAcl() {
		return ruleIdForAcl;
	}

	/**
	 * @return
	 */
	public String getBusinessRuleName() {
		return businessRuleName;
	}

	/**
	 * @param string
	 */
	public void setObjectTypeID(String string) {
		objectTypeID = string;
	}

	/**
	 * @param string
	 */
	public void setObjectType(String string) {
		objectType = string;
	}

	/**
	 * @param timestamp
	 */
	public void setChangedAt(Date date) {
		changedAt = date;
	}

	/**
	 * @param string
	 */
	public void setChangedBy(String string) {
		changedBy = string;
	}

	/**
	 * @param timestamp
	 */
	public void setCreatedAt(Date timestamp) {
		createdAt = timestamp;
	}

	/**
	 * @param string
	 */
	public void setCreatedBy(String string) {
		createdBy = string;
	}

	/**
	 * @param string
	 */
	public void setKey(String string) {
		key = string;
	}

	/**
	 * @param string
	 */
	public void setRuleIdForAcl(String string) {
		ruleIdForAcl = string;
	}

	/**
	 * @param string
	 */
	public void setBusinessRuleName(String string) {
		businessRuleName = string;
	}

}
