package com.sap.caf.rt.security.acl.impl.businessentity;

import com.sap.caf.rt.bol.IDependentObject;
import com.sap.caf.rt.bol.pk.AbstractPrimaryKey;

import java.util.Collections;
import java.util.Date;
import java.util.List;

/**
 * @author c5051699
 */

public class BusinessEntityVo implements IDependentObject {

	public static final String PROVIDER = "sap.com";
	public static final String APPLICATION = "caf.core";
	public static final String BE_SRV_NAME = "BusinessEntity";
	public static final String OBJECT_NAME = PROVIDER + "/" + APPLICATION + "/" + BE_SRV_NAME;
	
	private String key;
	private String objectTypeID;
	private String objectID;
	private String title;
	private String createdBy;
	private String changedBy;
	private Date createdAt;
	private Date changedAt;

	public BusinessEntityVo() {
	}

	public BusinessEntityVo(String key, String objectTypeID, String objectID, String title) {
		this.key = key;
		this.objectTypeID = objectTypeID;
		this.objectID = objectID;
		this.title = title;
	}

	public AbstractPrimaryKey getPK() {
		return new BusinessEntityPK(key);
	}

	public String getObjectType() {
		return OBJECT_NAME;
	}

	/* (non-Javadoc)
	 * @see com.sap.caf.rt.security.util.IDependentObject#getPropertyList()
	 */
	public List getPropertyList() {
		return Collections.EMPTY_LIST;
	}

	/* (non-Javadoc)
	 * @see com.sap.caf.rt.security.util.IDependentObject#getProperty(java.lang.String)
	 */
	public Object getProperty(String propertyName) {
		return null;
	}

	/* (non-Javadoc)
	 * @see com.sap.caf.rt.security.util.IDependentObject#setProperty(java.lang.String, java.lang.Object)
	 */
	public void setProperty(String propertyName, Object propertyValue) {
	}

	/**
	 * @return
	 */
	public String getKey() {
		return key;
	}

	/**
	 * @return
	 */
	public Date getChangedAt() {
		return changedAt;
	}

	/**
	 * @return
	 */
	public String getChangedBy() {
		return changedBy;
	}

	/**
	 * @return
	 */
	public Date getCreatedAt() {
		return createdAt;
	}

	/**
	 * @return
	 */
	public String getCreatedBy() {
		return createdBy;
	}

	/**
	 * @param string
	 */
	public void setKey(String string) {
		key = string;
	}

	/**
	 * @param timestamp
	 */
	public void setChangedAt(Date timestamp) {
		changedAt = timestamp;
	}

	/**
	 * @param string
	 */
	public void setChangedBy(String string) {
		changedBy = string;
	}

	/**
	 * @param timestamp
	 */
	public void setCreatedAt(Date timestamp) {
		createdAt = timestamp;
	}

	/**
	 * @param string
	 */
	public void setCreatedBy(String string) {
		createdBy = string;
	}

	/**
	 * @return
	 */
	public String getObjectID()
	{
		return objectID;
	}

	/**
	 * @return
	 */
	public String getObjectTypeID()
	{
		return objectTypeID;
	}

	/**
	 * @return
	 */
	public String getTitle()
	{
		return title;
	}

	/**
	 * @param string
	 */
	public void setObjectID(String string)
	{
		objectID = string;
	}

	/**
	 * @param string
	 */
	public void setObjectTypeID(String string)
	{
		objectTypeID = string;
	}

	/**
	 * @param string
	 */
	public void setTitle(String string)
	{
		title = string;
	}

}
