package com.sap.caf.rt.security.acl.impl.businessentity;

import java.util.StringTokenizer;

import javax.ejb.SessionBean;

import com.sap.caf.rt.bol.IDependentObject;
import com.sap.caf.rt.exception.ServiceException;
import com.sap.caf.rt.security.acl.impl.SecurityServiceBase;
import com.sap.caf.rt.security.util.CAFPermissionUtil;
import com.sap.caf.rt.util.CAFPublicLogger;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.Severity;

/**
 * @ejbLocal <{com.sap.caf.rt.security.acl.impl.businessentity.BusinessEntityLocal}>
 * @ejbLocalHome <{com.sap.caf.rt.security.acl.impl.businessentity.BusinessEntityLocalHome}>
 * @stateless 
 */

/**
 * @author c5051699
 */
public class BusinessEntityBean extends SecurityServiceBase implements SessionBean {

	private static final String APPLICATION = BusinessEntityBean.class.getName();
	private static final Location LOGGER = Location.getLocation(APPLICATION);
	private static final String JARMREQPREFIX = "CAF:RT:security:";
	private static final String JARMREQUEST = JARMREQPREFIX + APPLICATION;

	public BusinessEntityVo findByPrimaryKey(String businessObjectID) throws ServiceException {
		final String method = "findByPrimaryKey(String)";
		CAFPublicLogger.entering(null, JARMREQUEST, method, LOGGER, 1);

		BusinessEntityVo businessEntityVo = null;
		try {
			StringTokenizer st = new StringTokenizer(businessObjectID, ":");
			String objectID = st.nextToken();
			String objectTypeID = st.nextToken();
			String titleAttribute = st.nextToken();
			
			IDependentObject object = CAFPermissionUtil.getDependentObject(objectID, objectTypeID) ;

			Object attributeValue = object.getProperty(titleAttribute) ;
				
			businessEntityVo = new BusinessEntityVo() ;
			businessEntityVo.setKey(businessObjectID);
			businessEntityVo.setObjectID(objectID) ;
			businessEntityVo.setObjectTypeID(objectTypeID) ;
			businessEntityVo.setTitle((attributeValue==null)?null:attributeValue.toString()) ;

		} catch (Exception e) {
			getSessionContext().setRollbackOnly();
			CAFPublicLogger.traceThrowableT(Severity.ERROR, LOGGER, method, e.getMessage(), e);
			throw new ServiceException(e);
		} finally {
			CAFPublicLogger.exiting(null, JARMREQUEST, method, LOGGER, 1);
		}
		return businessEntityVo;
	}

	public BusinessEntityVo findByObjectID(String objectID, String objectTypeID, String titleAttribute) throws ServiceException {
		final String method = "findByObjectID(String, String, String)";
		CAFPublicLogger.entering(null, JARMREQUEST, method, LOGGER, 1);
		
		BusinessEntityVo businessEntityVo = null;

		try {
			IDependentObject object = CAFPermissionUtil.getDependentObject(objectID, objectTypeID) ;

			Object attributeValue = object.getProperty(titleAttribute) ;
				
			String businessObjectID = objectID + ":" + objectTypeID + ":" + titleAttribute;
			businessEntityVo = new BusinessEntityVo() ;
			businessEntityVo.setKey(businessObjectID);
			businessEntityVo.setObjectID(objectID) ;
			businessEntityVo.setObjectTypeID(objectTypeID) ;
			businessEntityVo.setTitle((attributeValue==null)?null:attributeValue.toString()) ;

		} catch (Exception e) {
			getSessionContext().setRollbackOnly();
			CAFPublicLogger.traceThrowableT(Severity.ERROR, LOGGER, method, e.getMessage(), e);
			throw new ServiceException(e);
		} finally {
			CAFPublicLogger.exiting(null, JARMREQUEST, method, LOGGER, 1);
		}
		return businessEntityVo;
	}
}
