package com.sap.caf.rt.security.acl.impl;

import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.EJBLocalObject;
import javax.ejb.RemoveException;
import javax.ejb.SessionContext;
import com.sap.caf.rt.bol.da.jdo.JDODataAccessService;
import com.sap.caf.rt.exception.ServiceException;
import com.sap.caf.rt.security.acl.impl.businessrule.BusinessRuleLocalHome;
import com.sap.caf.rt.security.acl.impl.condition.ConditionLocalHome;
import com.sap.caf.rt.security.acl.impl.objectattribute.ObjectAttributeLocalHome;
import com.sap.caf.rt.security.acl.impl.objecttype.ObjectTypeLocalHome;
import com.sap.caf.rt.util.CAFPublicLogger;
import com.sap.security.api.IRole;
import com.sap.security.api.IUser;
import com.sap.security.api.IUserFactory;
import com.sap.security.api.UMException;
import com.sap.security.api.UMFactory;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.Severity;

/**
 * @ejbLocal <{com.sap.caf.rt.security.acl.impl.GeneralSecurityTypeLocal}>
 * @ejbLocalHome <{com.sap.caf.rt.security.acl.impl.GeberalSecurityLocalHome}>
 * @stateless 
 * @transactionAttribute Required
 */

/**
 * @author c5051699
 */
public class SecurityServiceBase {

	private static final String APPLICATION_INNER = SecurityServiceBase.class.getName();
	private static final Location LOGGER_INNER = Location.getLocation(APPLICATION_INNER);
	private static final String JARMREQPREFIX_INNER = "CAF:RT:security:";
	private static final String JARMREQUEST_INNER = JARMREQPREFIX_INNER + APPLICATION_INNER;

	private ObjectTypeLocalHome objectTypeLocalHome;
	private ObjectAttributeLocalHome objectAttributeLocalHome;
	private BusinessRuleLocalHome businessRuleLocalHome;
	private ConditionLocalHome conditionLocalHome;
	private SessionContext m_sessionContext;
	private JDODataAccessService m_service;
	private IRole m_adminRole;
	private IUserFactory m_userFactory;

	public void ejbRemove() {
	}

	public void ejbActivate() {
	}

	public void ejbPassivate() {
	}

	public void ejbCreate() throws CreateException {
		final String method = "ejbCreate()";
		CAFPublicLogger.entering(null, JARMREQUEST_INNER, method, LOGGER_INNER, 1);

		try {
			m_adminRole =
				UMFactory.getRoleFactory().getRoleByUniqueName(
					CAFPermission.ADMIN_ROLE);
			m_userFactory = UMFactory.getUserFactory();
		} catch (UMException e) {
			CAFPublicLogger.traceThrowableT(Severity.ERROR, LOGGER_INNER, method, e.getMessage(), e);
			throw new CreateException(e.getMessage());
		} finally {
			CAFPublicLogger.exiting(null, JARMREQUEST_INNER, method, LOGGER_INNER, 1);
		}
	}

	public void setSessionContext(SessionContext context) {
		m_sessionContext = context;
		final String method = "setSessionContext(SessionContext)";
		CAFPublicLogger.entering(null, JARMREQUEST_INNER, method, LOGGER_INNER, 1);

		try {
			m_service =
				(JDODataAccessService) JDODataAccessService.getInstance();
		} catch (Exception e) {
			CAFPublicLogger.traceThrowableT(Severity.ERROR, LOGGER_INNER, method, e.getMessage(), e);
		} finally {
			CAFPublicLogger.exiting(null, JARMREQUEST_INNER, method, LOGGER_INNER, 1);
		}
	}

	protected SessionContext getSessionContext() {
		return m_sessionContext;
	}

	protected JDODataAccessService getJDODataAccessService() {
		return m_service;
	}


	protected void checkUpdatePermission() throws ServiceException {
		final String method = "checkUpdatePermission()";
		CAFPublicLogger.entering(null, JARMREQUEST_INNER, method, LOGGER_INNER, 1);
		String caller = m_sessionContext.getCallerPrincipal().getName();
		try {
			IUser user = m_userFactory.getUserByLogonID(caller);
			if (!m_adminRole.isUserMember(user.getUniqueID(), true)) {
				throw new ServiceException(
					"AUTH_NO_ACCESS",
					new String[] { caller });
			}
		} catch (UMException e) {
			CAFPublicLogger.traceThrowableT(Severity.ERROR, LOGGER_INNER, method, e.getMessage(), e);
			throw new ServiceException(e);
		} finally {
			CAFPublicLogger.exiting(null, JARMREQUEST_INNER, method, LOGGER_INNER, 1);
		}
	}

	protected String getCurrentUserID() throws ServiceException {
		final String method = "getCurrentUserID()";
		String loginUserID = null;
		try {
			String callerName =
				getSessionContext().getCallerPrincipal().getName();
			if (callerName != null) {
				final IUser user =
					UMFactory.getUserFactory().getUserByLogonID(callerName);
				loginUserID = user.getUniqueID();
			}
		} catch (UMException e) {
			CAFPublicLogger.traceThrowableT(Severity.ERROR, LOGGER_INNER, method, e.getMessage(), e);
			throw new ServiceException(e);
		}
		return loginUserID;
	}

	protected void release(EJBLocalObject object) {
		final String method = "release(EJBLocalObject)";
		if (object != null) {
			try {
				object.remove();
			} catch (EJBException e) {
				CAFPublicLogger.traceThrowableT(Severity.ERROR, LOGGER_INNER, method, e.getMessage(), e);
			} catch (RemoveException e) {
				CAFPublicLogger.traceThrowableT(Severity.ERROR, LOGGER_INNER, method, e.getMessage(), e);
			}
		}
	}
}
