package com.sap.caf.rt.security.acl.impl;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.ejb.CreateException;
import com.sap.caf.rt.util.CAFPublicLogger;
import com.sap.caf.rt.exception.CAFPermissionException;
import com.sap.tc.logging.Location;

/**
 * @ejbHome <{com.sap.caf.rt.security.acl.impl.CAFPermissionHome}>
 * @ejbLocal <{com.sap.caf.rt.security.acl.impl.CAFPermissionLocal}>
 * @ejbLocalHome <{com.sap.caf.rt.security.acl.impl.CAFPermissionLocalHome}>
 * @ejbRemote <{com.sap.caf.rt.security.acl.impl.CAFPermissionRemote}>
 * @stateless 
 */
public class CAFPermissionBean implements SessionBean {

	private static final String APPLICATION = CAFPermissionBean.class.getName();
	private static final Location LOGGER = Location.getLocation(APPLICATION);
	private static final String JARMREQPREFIX = "CAF:RT:security:";
	private static final String JARMREQUEST = JARMREQPREFIX+APPLICATION;

	public void ejbRemove() {
	}

	public void ejbActivate() {
	}

	public void ejbPassivate() {
	}

	public void setSessionContext(SessionContext context) {
	}

	public void ejbCreate() throws CreateException {
	}


	/**
	 * <p>
	 * Check permission for the userId. Check instance permission based on the user id and permission name
	 * first. If the user id has the permission to access the instance, simply returns true, otherwise,
	 * check permission based on business rules. 
	 * @param object instance of the target object
	 * @param userId user Id of the IUser that is subjected for permission check
	 * @param permissionName is the permission such as "read" or 'write' etc that the user is attempted to 
	 * the object
	 * @param objectName identifies the object class
	 * @return boolean 'true'indicatess the permission is granted, 'false' indicates the permission is denied  
	 * @exception PermissionException
	 * <p>
	 */
	public Boolean checkAclPermission(Object obj, String userId, String permissionName, String objectType) throws CAFPermissionException {
		final String method = "checkAclPermission(Object, String, String, String)";
		CAFPublicLogger.entering(null, JARMREQUEST, method, LOGGER, 1);

		boolean result = CAFPermission.checkAclPermission(obj, userId, permissionName, objectType);

		CAFPublicLogger.exiting(null, JARMREQUEST, method, LOGGER, 1);
		return new Boolean(result);
	}

}
