/*
 * Created on Aug 13, 2003
 *
 * To change the template for this generated file go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
package com.sap.caf.rt.security.acl.api;

/**
 * @author i006085
 *
 * To change the template for this generated type comment go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */

import com.sap.caf.rt.exception.CAFPermissionException;
/**
 * The implementation class to ACL related activities such as 
 * permission check and ACL creation etc.
 *  */
public interface ICAFCheckPermission {

	/**
	 * Check permission for the userId.
	 * @param object instance of the target object
	 * @param userId user Id of the IUser that is subjected for permission check
	 * @param permissionName is the permission such as "read" or 'write' etc that the user is attempted to 
	 * the object
	 * @param objectName identifies the object class
	 * @return boolean 'true'indicatess the permission is granted, 'false' indicates the permission is denied  
	 * @exception PermissionException
	 * 
	 */
	public boolean checkAclPermission(Object obj, String userId, String permissionName, String objectType) throws CAFPermissionException;
	
	/**
	 * Whether SAP standard check permission is required.
	 * @return boolean 'true'indicates the SAP standard permission check is required, 'false' indicates otherwise. 
	 * @exception PermissionException
	 * 
	 */
	public boolean isStandardAclCheckRequired() throws CAFPermissionException;
}
