/*
 * Created on Jun 24, 2003
 */
package com.sap.caf.rt.ui.cool.utils;

import com.sap.tc.webdynpro.services.sal.config.api.IWDConfiguration;
import com.sap.tc.webdynpro.services.sal.config.api.WDConfiguration;
import com.sap.tc.webdynpro.services.sal.config.api.WDConfigurationNotFoundException;
import com.sap.tc.webdynpro.services.sal.config.api.WDInvalidConfigParameterException;
import com.sap.tc.webdynpro.services.sal.deployment.api.IWDDeployableObject;

/**
 * This class contains the connection properties used with <i>Cool(tm)</i> services
 * to obtain data from SAP backend.</p>
 * This class also includes operating with connection parameters, 
 * such as reading connection properties from property files.
 * 
 * @author Victor Kulaga
 * @version 1.1
 */
public class CoolConnectionProperties {
	//---------- declarations of constants begin --------	
	//--- <Cool> connection parameter's property names:
	/** The property name of server host used in call to <i>Cool(tm)</i> service */
	public static final String PROPNAME_COOL_SERVER_HOST = "cool.server.host";  
	/** The property name of server sysnumber used in call to <i>Cool(tm)</i> service */
	public static final String PROPNAME_COOL_SERVER_SYSNUMBER = "cool.server.sysnumber";
	/** The property name of client used in call to <i>Cool(tm)</i> service */
	public static final String PROPNAME_COOL_CLIENT = "cool.client";
	/** The property name of url used in call to <i>Cool(tm)</i> service */
	public static final String PROPNAME_COOL_URL = "cool.URL";
	/** The property name of user name used in call to <i>Cool(tm)</i> service */
	public static final String PROPNAME_COOL_USER_NAME = "cool.user.name";
	/** The property name of user password used in call to <i>Cool(tm)</i> service */
	public static final String PROPNAME_COOL_USER_PASSWORD = "cool.user.password";	
	/** The property name of the Locale string (<i>e.g. "en" or "de"</i>) currently used
	 * in calling to <i>Cool(tm)</i> service.*/
	public static final String PROPNAME_COOL_LOCALE_STR = "cool.locale.str";
	//---------- declarations of constants end --------
	
	//---------- declarations of variables begin --------
	//--- <Cool> connection parameter variables:
	/** The server host used in call to <i>Cool(tm)</i> service */
	public String coolHost = "";		
	/** The server sysnumber used in call to <i>Cool(tm)</i> service */
	public String coolSysNumber = "";
	/** The client used in call to <i>Cool(tm)</i> service */
	public String coolClient = "";
	/** The URL used in call to <i>Cool(tm)</i> service */
	public String coolURL = "";
	/** The user name used in call to <i>Cool(tm)</i> service */
	public String coolUserName = "";
	/** The user password used in call to <i>Cool(tm)</i> service */
	public String coolUserPassword = "";
	/** The Locale string (<i>e.g. "en" or "de"</i>) currently used
	 * in calling to <i>Cool(tm)</i> service.*/
	public String coolLocaleStr = "";
	//---------- declarations of variables end --------
	
	//---------- declarations of methods begin --------
	// Constructors begin:
	/** Default constructor of this class. Does nothing */
	public CoolConnectionProperties() {}
	// Constructors end
	
	/** Gets {@link coolHost} */
	public String getCoolHost() {
		return coolHost;
	}
	
	/** Gets {@link coolSysNumber} */
	public String getCoolSysNumber() {
		return coolSysNumber;
	}
	
	/** Gets {@link coolClient} */
	public String getCoolClient() {
		return coolClient;
	}
	
	/** Gets {@link coolClient} */
	public String getCoolURL() {
		return coolURL;
	}
	
	/** Gets {@link coolUserName} */
	public String getCoolUserName() {
		return coolUserName;
	}
	
	/** Gets {@link coolUserPassword} */
	public String getCoolUserPassword() {
		return coolUserPassword;
	}
	
	/** Gets {@link coolLocaleStr} */
	public String getCoolLocaleStr() {
		return coolLocaleStr;
	}
	
	/**
	 * This method returns {@link CoolConnectionProperties} object with 
	 * connection parameters data read from configuration file 
	 * of specified deployable object.</p>
	 * @deprecated this method will be removed in next version of library. Use {@link getCoolConnectionProperties(IWDDeployableObject deployableObject)} instead.
	 * @param deployableObjectName deployable object from which property file <i>Cool</i> connection parameters are read.
	 * @return {@link CoolConnectionProperties} object with <i>Cool</i> connection parameters contained, if success.
	 * @throws {@link CoolConnectionPropertiesException} if error occurred on reading properties from property file.
	 * */
	public static CoolConnectionProperties getCoolConnectionProperties(String deployableObjectName) throws CoolConnectionPropertiesException {
		CoolConnectionProperties cp = new CoolConnectionProperties();
		try	{
			IWDConfiguration config = WDConfiguration.getConfiguration(deployableObjectName);
			cp.coolHost = config.getStringEntry(PROPNAME_COOL_SERVER_HOST);		
			cp.coolSysNumber = config.getStringEntry(PROPNAME_COOL_SERVER_SYSNUMBER);
			cp.coolClient = config.getStringEntry(PROPNAME_COOL_CLIENT);
			cp.coolURL = config.getStringEntry(PROPNAME_COOL_URL);
			cp.coolUserName = config.getStringEntry(PROPNAME_COOL_USER_NAME);
			cp.coolUserPassword = config.getStringEntry(PROPNAME_COOL_USER_PASSWORD);
			cp.coolLocaleStr = config.getStringEntry(PROPNAME_COOL_LOCALE_STR);		
		} catch (WDInvalidConfigParameterException e) {
			String errorMess = "Invalid property name for one of the Cool connection parameters specified.";
			throw new CoolConnectionPropertiesException(errorMess);
		} catch (WDConfigurationNotFoundException e) {
			String errorMess = "Configuration not found for specified deployable object name: \""+deployableObjectName+"\" on reading Cool connection properties";
			throw new CoolConnectionPropertiesException(errorMess);
		}
		return cp;
	}
	
	/**
	 * This method returns {@link CoolConnectionProperties} object with 
	 * connection parameters data read from configuration file 
	 * of specified deployable object.</p>
	 * @param deployableObject deployable object from which property file the <i>Cool</i> connection parameters are read.
	 * @return {@link CoolConnectionProperties} object with <i>Cool</i> connection parameters contained, if success.
	 * @throws {@link CoolConnectionPropertiesException} if error occurred on reading properties from property file.
	 * */
	public static CoolConnectionProperties getCoolConnectionProperties(IWDDeployableObject deployableObject) throws CoolConnectionPropertiesException {
		CoolConnectionProperties cp = new CoolConnectionProperties();
		try	{
			IWDConfiguration config = WDConfiguration.getConfiguration(deployableObject);
			cp.coolHost = config.getStringEntry(PROPNAME_COOL_SERVER_HOST);		
			cp.coolSysNumber = config.getStringEntry(PROPNAME_COOL_SERVER_SYSNUMBER);
			cp.coolClient = config.getStringEntry(PROPNAME_COOL_CLIENT);
			cp.coolURL = config.getStringEntry(PROPNAME_COOL_URL);
			cp.coolUserName = config.getStringEntry(PROPNAME_COOL_USER_NAME);
			cp.coolUserPassword = config.getStringEntry(PROPNAME_COOL_USER_PASSWORD);
			cp.coolLocaleStr = config.getStringEntry(PROPNAME_COOL_LOCALE_STR);		
		} catch (WDInvalidConfigParameterException e) {
			String errorMess = "Invalid property name for one of the Cool connection parameters specified.";
			throw new CoolConnectionPropertiesException(errorMess);
		} catch (WDConfigurationNotFoundException e) {
			String errorMess = "Configuration not found for specified deployable object named: \""+deployableObject.getName()+"\" on reading Cool connection properties";
			throw new CoolConnectionPropertiesException(errorMess);
		}
		return cp;
	}
	
	//---------- declarations of methods end --------
}
