/* Generated by Together */

package com.sap.caf.rt.ui.cool.generic;

import java.util.Collection;
import java.util.Iterator;

import com.sap.caf.rt.srv.IDataContainerBean;
import com.sap.caf.rt.util.CAFPublicLogger;
import com.sap.tc.cmi.metadata.ICMIModelClassInfo;
import com.sap.tc.cmi.metadata.ICMIModelObjectCollectionInfo;
import com.sap.tc.cmi.model.ICMIModel;
import com.sap.tc.cmi.model.ICMIModelClass;
import com.sap.tc.cmi.model.ICMIQuery;
import com.sap.tc.col.client.generic.api.IAspect;
import com.sap.tc.col.client.generic.api.IKeyList;
import com.sap.tc.col.client.generic.api.IQuery;
import com.sap.tc.col.client.generic.api.IServiceModule;
import com.sap.tc.col.client.generic.api.IStructure;
import com.sap.tc.col.client.generic.api.IStructureList;
import com.sap.tc.col.client.generic.api.SortingCriteria;
import com.sap.tc.col.client.metadata.api.IQueryDescriptor;
import com.sap.tc.col.edo.IEdoStructure;
import com.sap.tc.col.servicemanager.api.calls.ISrvMgrCall;
import com.sap.tc.logging.Location;

/**
 * represents a <code>Query</code> at runtime, a <code>Query</code> allows searching for <code>Aspects</code> for given
 * search parameters and given input Keys.<p>
 * An example using a Query could be:
 * <pre>
 *   IQuery query = serviceModule.createQuery("QUERY_NAME");
 *   IStructure inputParameter = query.getInputParameter();
 *   // setting input parameter
 *   inputParameter.setAttributeValue("NAME1", "R*");
 *   ..
 *   query.execute();
 *   // now the result
 *   IAspect aspect = query.getResult();
 *   ..
 * </pre> 
 * 
 * Additionally <code>Query</code> implements <code>ICMIGenericModelClass</code> and <code>ICMIModelClassExecutable</code>.<p>
 * This is necessary to use a Query from Web Dynpro. Web Dynpro framework only knows this interfaces and uses the implicit
 * relations <code>inputParameter</code> and <code>result</code> for setting parameters and getting the
 * result of the <code>Query</code>.<p>
 * 
 * A Query is the root of a cache. That means that all Aspects which were reached by navigation from this <code>Query</code> result,
 * are internally hold in a cache until this cache is invalidated implicitly or explicitly with
 * method invalidate().<p>
 * Implicitly could be a new execute() of this <code>Query</code> or changing services (insert, update, delete) for an Aspect in the
 * cache.<p> 
 * 
 * @author Helmut Mueller
 */
public class Query
	extends AbstractModelClass
	implements IQuery, ICacheRootObject {

	/** Logging properites for this class */
	private static final String APPLICATION	= Query.class.getName();
	private static final String jARMRequest = AbstractModelClass.jARMReqPrefix+APPLICATION;
	private static final Location logger = Location.getLocation(APPLICATION);
	
	/**
	 * the meta data of this <code>Query</code>
	 * @shapeType AssociatesLink 
	 * @label
	 * @supplierCardinality 1
	 * @clientCardinality 0..*
	 * @directed
	 */
	private IQueryDescriptor descriptor;

	/**
	 * the search parameters of this <code>Query</code>
	 * @shapeType AssociatesLink 
	 * @label
	 * @supplierRole inputParameter
	 * @supplierCardinality 0..1
	 * @clientCardinality 0..1
	 * @directed
	 */
	private Structure inputParameter;

	/**
	 * the result <code>Aspect</code> of this <code>Query</code>
	 * @label
	 * @supplierRole result
	 * @supplierCardinality 1
	 * @clientCardinality 1
	 * @directed 
	 */
	private IAspect result;

	/**
	 * the input KeyList of this <code>Query</code>
	 * @clientCardinality 1
	 * @supplierCardinality 0..1
	 * @directed
	 * @supplierRole inputKeyList 
	 */
	private IKeyList inputKeyList;

	/**
	 * constructor
	 * @param descriptor the meta data, <code>IQueryDescriptor</code>, of this <code>Query</code>
	 * @param serviceModule the <code>ServiceModule</code> the query belongs to
	 */
	protected Query(IQueryDescriptor descriptor, ServiceModule serviceModule) {
		final String method = jARMRequest + ":Query(IQueryDescriptor, ServiceModule)";
		CAFPublicLogger.entering(null, jARMRequest, method, logger);
		try {
			if (serviceModule == null)
				// ServiceModule must not be null
				throw new IllegalArgumentException("ServiceModule must not be null");
			if (descriptor == null)
				// descriptor must not be null
				throw new IllegalArgumentException("QueryDescriptor must not be null");
			this.descriptor = descriptor;
			this.serviceModule = serviceModule;
	
			// create new Query service call object
			//ARIEL this.srvMgrQuery = serviceModule.getSrvMgrServiceModule().createQuery(getDescriptor().getName());
			
			// create a new input KeyList
			this.inputKeyList = getResultAspectServiceModule().createKeyList(descriptor.getInputKeysDescriptor().getName());
	
			// create inputParameter Structure and wrap associated RPE Structure
			if (descriptor.hasInputParameters())
				//ARIEL Why not as I do it? 
				//this.inputParameter = (Structure) serviceModule.createStructureInternal(descriptor.getInputParameters(), new EdoStructure(descriptor.getInputParameters()));
				inputParameter =
					(Structure) new Structure(serviceModule,
						(IEdoStructure) new EdoStructure(descriptor
							.getInputParameters()));
			this.modelClassInfo =
				(
					(ColModelInfo) serviceModule
						.associatedModelInfo())
						.getOrCreateModelClassInfo(
					descriptor);
		}
		finally {   
			CAFPublicLogger.exiting(null, jARMRequest, method, logger);
		}
	}

	/**
	 * @see com.sap.tc.cmi.model.ICMIModelClass#associatedModel()
	 */
	public ICMIModel associatedModel() {
		return serviceModule;
	}

	/**
	 * The ICMIModelClassInfo for this query. A reference is stored for performance reasons only. 
	 * The info could be easily retrieved from the serviceModule whenever needed.
	 */
	private ICMIModelClassInfo modelClassInfo;

	/**
	 * @see com.sap.tc.cmi.model.ICMIGenericModelClass#associatedModelClassInfo()
	 */
	public ICMIModelClassInfo associatedModelClassInfo() {
		return modelClassInfo;
	}

	private IAspect createResultAspect() {
		if (result == null) {
			result = getResultAspectServiceModule().createAspect(descriptor.getResultAspectDescriptor().getName());
		} 
		return result;
	}

	private IServiceModule getResultAspectServiceModule() {
		if (resultAspectServiceModule == null) {
			String smraName = descriptor.getResultAspectDescriptor().getServiceModuleDescriptor().getName();
			resultAspectServiceModule = ServiceFacadeFactory.getFacadeInstance(null).getServiceModule(smraName);
		}
		return resultAspectServiceModule;
	}
	
	/**
	 * Executes this <code>Query</code> by calling corresponding <code>ServiceManager</code> service.<p>
	 * NOTE: Sorting is not currently supported
	 * Before this is done, eventually existing results and cache are invalidated.<p>
	 * Note that this execute is propagated to the backend only when the message queue is flushed.
	 */
	public void execute() {
		final String method = jARMRequest + ":execute()";
		CAFPublicLogger.entering(null, jARMRequest, method, logger);

		if (sortingCriteria != null) {
			throw new RuntimeException("Sorting is not supported in this GCP version");
		}
		// before execute, invalidate eventually existing old one
		// clears old results
		invalidate();

		try {
			// The result aspect is created and internally stored 
			IAspect resultAspect = createResultAspect();
			if (inputKeyList != null && !inputKeyList.isEmpty()) {
				throw new IllegalArgumentException("Input key lists for queries are not supported and must be empty.");
			}
			Object rawResult = this.serviceModule.getAspectServiceAccess().findBy(resultAspect.getDescriptor().getName(),this.getName(),this.getInputParameterStructure());
//			serviceModule.getServiceFacade().save();
			// set the state to not record rows as insert operations
			// from original Aspect.setAspectData
			((Aspect) resultAspect).setState(Aspect.PROCESS_QUEUE_WAITING);
			try {
				if (rawResult instanceof Collection) {
					for (Iterator it = ((Collection) rawResult).iterator(); it.hasNext();
							createRow((IDataContainerBean) it.next(), resultAspect)) {}
				} else {
					createRow((IDataContainerBean) rawResult, resultAspect);
				}
			} finally {
				((Aspect) resultAspect).setState(Aspect.CLEAN);
			}

			//TODO figure out if this is needed, was not in GCP inetrface
			//resultAspect.setRecordChanges(true);
			// cache the result aspect
			aspectCache.add(resultAspect);
			// update state
			if (inputParameter != null) {
				inputParameter.makeClean();
			}
		}catch (Throwable ex) {
			logger.catching("Error while query execution ", ex);
			MessageFactory.createAndRegisterMessageFromException(ex, this, null, true);
		}
		finally {
			CAFPublicLogger.exiting(null, jARMRequest, method, logger);
		}
	}

	private void createRow(IDataContainerBean bean, IAspect aspect) {
		final String method = jARMRequest + ":createRow(IDataContainerBean, IAspect)";
		CAFPublicLogger.entering(null, jARMRequest, method, logger);
		try {
			AspectRow row = (AspectRow)aspect.createAspectRow();
			row.supplyRowWithData(bean);
			((AspectRow) row).setState(Aspect.CLEAN);
		}
		finally {
			CAFPublicLogger.exiting(null, jARMRequest, method, logger);
		}
	}

	/**
	 * returns the meta data of this <code>Query</code>
	 * @return IQueryDescriptor the meta data of this <code>Query</code>
	 */
	public IQueryDescriptor getDescriptor() {
		return descriptor;
	}

	/**
	 * returns the result of this <code>Query</code>
	 * @return IAspect the result of this <code>Query</code>
	 */
	public IAspect getResultAspect() {
		return result;
	}

	/**
	 * Returns the structure describing the input parameters of this query or 
	 * <code>null</code> if this query doesn't have parameters.
	 */
	public Object getInputParameter() {
		return inputParameter;
	}

	/**
	 */
	public Collection getResult() {
		return getResultAspect();
	}

	/**
	 * returns the search parameter structure of this <code>Query</code> or throws an <code>UnsupportedOperationException</code>, if 
	 * this <code>Query</code> has no input parameter.
	 * @return IStructure the search parameter of this <code>Query</code>
	 * @exception throws an <code>UnsupportedOperationException</code>, if this <code>Query</code> has no input parameter.
	 */
	public IStructure getInputParameterStructure() {
		if (inputParameter == null) {
			MessageFactory.createAndRegisterMessageFromException(
					new UnsupportedOperationException("Query '"
							+ descriptor.getName()
							+ "'doesn't support input parameter!"), this, "");
		}
		return inputParameter;
	}

	/**
	 * returns the input KeyKist, which you can use as input of this <code>Query</code> to define a subset of the result.
	 * @return IKeyList the input KeyKist, which you can use as input of this <code>Query</code> to define a subset of the result.
	 */
	public IKeyList getInputKeyList() {
		return inputKeyList;
	}

	/**
	 * the <code>ServiceModule</code> the query belongs to
	 */
	private ServiceModule serviceModule;

	/**
	 * the <code>ServiceModule</code> the result aspect belongs to
	 */
	private IServiceModule resultAspectServiceModule;

	/**
	 * invalidates this <code>Query</code> and all <code>Aspects</code>, which were created by navigation from
	 * <code>Query</code> result.<p>
	 * 
	 * invalidating the query doesn't mean, that the <code>Query</code> object itself isn't valid,
	 * but the result of the query with its <code>Aspect</code> tree is no more valid. 
	 * You can set the input parameters and input keys a new, and then execute this <code>Query</code> again.<p>
	 */
	public void invalidate() {
		try {
			if (result != null) {
				((Aspect) result).invalidateInternal();
				result = null;
				//ARIEL srvMgrQuery.reset();
			}
			aspectCache.clear();
		} catch (Exception e) {
			MessageFactory.createAndRegisterMessageFromException(e, this, "");
		}
	}

	/**
	 * returns the input parameters model class of type ICMIModelClass which has the cardinality 1<p>
	 * This is the only valid related model class and so otherwise a
	 * <code>java.lang.IllegalArgumentException</code> is thrown.
	 * @param rolename the rolename, valid are: ColQueryAdapter.INPUT_PARAMETER
	 */
	public ICMIModelClass getRelatedModelObject(String rolename) {
		try {
			if (rolename.equalsIgnoreCase(INPUT_PARAMETER)
				|| rolename.equals(ICMIQuery.ROLE_NAME_INPUT_PARAMETER)) {
				return (ICMIModelClass) getInputParameter();
			} else {
				return super.getRelatedModelObject(rolename);
			}
		} catch (Exception e) {
			MessageFactory.createAndRegisterMessageFromException(e, this, "");
			return null;
		}
	}

	/**
	 * returns the result or inputKeys model class of type ICMIModelClass which have the cardinality 0..*<p>
	 * These are the only valid related model classes and so otherwise a
	 * <code>java.lang.IllegalArgumentException</code> is thrown
	 * @param rolename the rolename, valid are: ColQueryAdapter.RESULT and ColQueryAdapter.INPUT_KEYS
	 */
	public Collection getRelatedModelObjects(String rolename) {
		try {
			if (rolename.equalsIgnoreCase(RESULT)
				|| rolename.equals(ICMIQuery.ROLE_NAME_RESULT)) {
				return getResultAspect();
			} else {
				return super.getRelatedModelObjects(rolename);
			}
		} catch (Exception e) {
			MessageFactory.createAndRegisterMessageFromException(e, this, "");
			return null;
		}
	}

	/**
	 * sets the cache for this <code>Query</code>
	 * @param aspectCache the <code>AspectCache</code> to set
	 */
	protected void bindAspectCache(AspectCache aspectCache) {
		this.aspectCache = aspectCache;
	}

	/**
	 * returns always <code>true</code>, cause <code>Query</code> is always root object of a cache.<p>
	 * @return boolean always <code>true</code>
	 */
	public boolean isCacheRootObject() {
		return true;
	}

	/**
	 * the cache for this <code>Query</code>
	 * @clientCardinality 0..1
	 * @supplierCardinality 1*/
	private AspectCache aspectCache;

	/**
	 * returns the <code>AspectCache</code> of this <code>Query</code>
	 * @return AspectCache the <code>AspectCache</code> of this <code>Query</code>
	 */
	public AspectCache getAspectCache() {
		return aspectCache;
	}

	/**
	 * wraps the ServiceManager QueryService
	 */
	//ARIEL private ISrvMgrQuery srvMgrQuery;

	/**
	 * @see com.sap.tc.col.client.generic.core.ISrvMgrCaller#onCallsProcessed(ISrvMgrCall[])
	 */
	public void onCallsProcessed(ISrvMgrCall[] calls) {
		// delegate it to the result Aspect
		// if ( result != null )
		//((Aspect)result).onCallsProcessed(calls);
	}

	/**
	 * returns the name of this <code>Query</code>
	 */
	public String getName() {
		return descriptor.getName();
	}

	/**
	 * @see com.sap.tc.cmi.model.ICMIQuery#associatedInputParameterInfo()
	 */
	public ICMIModelClassInfo associatedInputParameterInfo() {
		return modelClassInfo.getRelatedModelClassInfo(IQuery.INPUT_PARAMETER);
	}

	/**
	 * @see com.sap.tc.cmi.model.ICMIQuery#associatedResultInfo()
	 */
	public ICMIModelObjectCollectionInfo associatedResultInfo() {
		return (
			(ColModelInfo) modelClassInfo
				.getModelInfo())
				.getOrCreateModelObjectCollectionInfo(
			descriptor.getResultAspectDescriptor());
	}

	/**
	 * @see com.sap.tc.cmi.model.ICMIQuery#countOf()
	 */
	public long countOf() {
		return -1;
	}

	/**
	 * Returns true if no result is available yet or if the input parameters 
	 * have been changed since the last call to execute().
	 */
	public boolean isDirty() {
		return result == null
			|| (inputParameter != null && inputParameter.isDirty());
	}

	/**
	 * the SortingCriteria for this <code>Query</code>
	 */
	private SortingCriteria sortingCriteria;

	/**
	 * @see com.sap.tc.col.client.generic.api.IQuery#setSortingCriteria(SortingCriteria)
	 */
	public void setSortingCriteria(SortingCriteria sorting) {
		sortingCriteria = sorting;
	}

	/**
	 * @see com.sap.tc.col.client.generic.api.IQuery#createSelectOption(java.lang.String, java.lang.String, java.lang.String, java.lang.String)
	 */
	public IStructure createSelectOption(
		String arg0,
		String arg1,
		String arg2,
		String arg3) {
		// TODO Auto-generated method stub
		return null;
	}

	/**
	 * @see com.sap.tc.col.client.generic.api.IQuery#createSelectOption(java.lang.String)
	 */
	public IStructure createSelectOption(String arg0) {
		// TODO Auto-generated method stub
		return null;
	}

	/**
	 * @see com.sap.tc.col.client.generic.api.IQuery#getSelectOptions()
	 */
	public IStructureList getSelectOptions() {
		// TODO Auto-generated method stub
		return null;
	}

}
