/* Generated by Together */

package com.sap.caf.rt.ui.cool.generic;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

import com.sap.tc.col.client.generic.api.IMessage;
import com.sap.tc.col.client.generic.api.IMessageList;

/**
 * contains error messages 
 */
public class MessageList implements IMessageList {
  
  private List messages = null;

  private final MessageList parentList;
  
  private Set childLists = null;
  
  public MessageList() {
    this(null);
  }
  
  public MessageList(MessageList parentList) {
    this.parentList = parentList;
    if ( parentList != null )
      parentList.addChildList(this);
  }
  
  private void addChildList(MessageList childList) {
    if ( childLists == null )
      childLists = new HashSet();
    childLists.add(childList);
  }
  
  public void clear() {
    clearR(0);
  }
  
  /**
   * @see com.sap.tc.col.client.generic.api.IMessageList#getMessage(int)
   */
  public IMessage getMessage(int index) {
    if ( messages == null || index < 0 || index >= size() )
      throw new IndexOutOfBoundsException(String.valueOf(index));
    return (IMessage) messages.get(index);
  }

  /**
   * @see com.sap.tc.col.client.generic.api.IMessageList#reomveMessage(IMessage)
   */
  public boolean removeMessage(IMessage message) {
    return removeMessagesR(Collections.singletonList(message), 0);    
  }

  /**
   * Clears this message list and propagates the removal. If direction is <= 0,
   * removal is propagated to child lists, if >= 0 it is propagated to the parentList.
   * (If direction = 0, deletion is progated in both directions).
   * 
   */
  private void clearR(int direction) {
    
    if ( direction <= 0 ) {
      // propagate to children
      if ( childLists != null ) {
        Iterator it = childLists.iterator();
        while (it.hasNext()) {
          MessageList child = (MessageList) it.next();
          // propagate downwards
          child.clearR(-1);
        }   
      }
    }

    if ( direction >= 0 ) {
      // propagate to parent
      if ( parentList != null )
        parentList.removeMessagesR(messages, +1);
    }

    // clear locally 
    if ( this.messages != null )
      this.messages.clear();
  }
  

  /**
   * Removes the given messages from this message list. If direction is <= 0,
   * removal is propagated to child lists, if >= 0 it is propagated to the parentList.
   * (If direction = 0, deletion is progated in both directions).
   * 
   * If the local message list is changed, then true is returned, otherwise false.
   */
  private boolean removeMessagesR(List messages, int direction) {
    
    // shortcut
    if ( messages == null || messages.isEmpty() )
      return false;
      
    if ( direction <= 0 ) {
      // propagate to children
      if ( childLists != null ) {
        Iterator it = childLists.iterator();
        while (it.hasNext()) {
          MessageList child = (MessageList) it.next();
          // propagate downwards
          child.removeMessagesR(messages, -1);
        }   
      }
    }

    if ( direction >= 0 ) {
      // propagate to parent
      if ( parentList != null )
        parentList.removeMessagesR(messages, +1);
    }

    boolean result = false;
        
    // remove locally 
    if ( this.messages != null )
      result = this.messages.removeAll(messages);

    return result;
  }
  
  /**
   * @see com.sap.tc.col.client.generic.api.IMessageList#isEmpty()
   */
  public boolean isEmpty() {
    return messages == null || messages.isEmpty();
  }

  /**
   * @see com.sap.tc.col.client.generic.api.IMessageList#size()
   */
  public int size() {
    return messages == null ? 0 : messages.size();
  }

  /**
   * Not part of public API. Only intended for internal use to build up a MessageList
   */
  public void addMessage(IMessage message) {

    if ( messages == null ) 
      messages = new ArrayList();

    messages.add(message);
    
    // propagate message to parent list (if known)
    if ( parentList != null )
      parentList.addMessage(message);
  }
  
  public void copyMessagesFrom(MessageList source) {
	if (source.messages != null) {
		// copy messages to parent list
		if (parentList != null && parentList != source.parentList) {
			for (Iterator i = source.messages.iterator(); i.hasNext(); ) {
				parentList.addMessage((IMessage) i.next());
			}
		}
		// copy messages to main list
		if (messages == null) {
			messages = new ArrayList(source.messages);
		} else {
			messages.addAll(source.messages);
		}
	}
  }
  
  public void transferMessagesFrom(MessageList source) {
	// copy messages from the source
	copyMessagesFrom(source);
	// clear messages from the source and all its childs
	source.clearR(-1);
  }

  public String toString() {
    String nl = System.getProperty("line.separator");
    StringBuffer buf = new StringBuffer("<MessageList>").append(nl);
    for (int i=0; i<size(); i++) {
      buf.append("  ").append(getMessage(i)).append(nl);
    }
    buf.append("</MessageList>");
    return buf.toString();
  }
  
  public static final IMessageList EMPTY_LIST = new IMessageList() {
    
    public void clear() {
    }
    
    public IMessage getMessage(int index) {
      throw new IndexOutOfBoundsException();
    }

    public boolean removeMessage(IMessage message) {
      return false;
    }

    public boolean isEmpty() {
      return true;
    }
    
    public int size() {
      return 0;
    }
    
  };

  
}
