/* Generated by Together */

package com.sap.caf.rt.ui.cool.generic;

import java.util.Arrays;

import com.sap.tc.col.client.generic.api.IKey;
import com.sap.tc.col.client.metadata.api.IKeyAspectDescriptor;
import com.sap.tc.col.client.metadata.api.IStructureDescriptor;
import com.sap.tc.logging.Location;

/**
 * represents an interface for the unique Key of an <code>AspectRow</code>.
 * 
 * <code>Key</code> objects are strict value objects. That is, two objects are equal, if they have
 * the same value (same number and order of fields with equal values for corresponding key fields), and
 * not only if they are represented by the same Java reference.<p>
 * 
 * This makes a <code>Key</code> object a good way to identify an <code>AspectRow</code>, even across caching,
 * transactions or connection boundaries.
 * 
 * Even if <code>AspectRow</code>s or <code>Aspect</code>s get invalid, the <code>Key</code> object remains valid and
 * usable. If data equivalent to the original <code>Aspect</code> is retrieved again from backend and returned as a new
 * <code>Aspect</code> instance, then the equivalent <code>AspectRow</code> can be found by its <code>Key</code>.<p>
 *  
 * After a successful insert operation, the value of a Key cannot change anymore. But if we have an insert, where the Key
 * was not known before insert, we have a transition from local Key ( no or incomplete field values ) to complete business Key
 * from Backend. 
 * Cause this transition from local to complete Key leads to a hashCode change, a local Key should not be used in a HashMap or somethig like this, or
 * you have to consider this after a flush of inserted AspectRows.<p> 
 * 
 * @author Helmut Mueller
 */
public class Key implements IKey, Cloneable {

	/** Logging properites for this class */
	private static final String APPLICATION	= Key.class.getName();
	private static final String jARMRequest = AbstractModelClass.jARMReqPrefix+APPLICATION;
	private static final Location logger = Location.getLocation(APPLICATION);
  
  /**
   * constructor creates an empty key where fields have value <code>null</code>. 
   * @param IKeyAspectDescriptor the meta data of the key
   */
  protected Key( IKeyAspectDescriptor keyDescriptor ) {
    this(keyDescriptor, null);
  }
  
  /**
   * constructor creates a key with given key fields. 
   * @param IKeyAspectDescriptor the meta data of the key
   * @param keyFields field values
   */
  protected Key( IKeyAspectDescriptor keyDescriptor, String[] keyFields ) {
    if ( keyDescriptor == null )
      throw new IllegalArgumentException("keyDescriptor must not be null");
    int lenKey = keyDescriptor.getStructure().size();
    if ( keyFields != null && keyFields.length != lenKey ) 
      throw new IllegalArgumentException("number of key fields doesn't match structure of key");

    this.keyDescriptor = keyDescriptor;
    if ( keyFields != null ) {
      this.keyFields = new String[ lenKey ]; 
      System.arraycopy(keyFields, 0, this.keyFields, 0, lenKey);
    }
  }
  
  /**
   * meta data of this <code>Key</code>
   */
  private transient IKeyAspectDescriptor keyDescriptor;
  
  /**
   * returns the meta data of this <code>Key</code>
   * @return KeyDescriptor the meta data of this <code>Key</code>
   */
  protected IKeyAspectDescriptor getKeyDescriptor() {
    return keyDescriptor;
  }
  
  /**
   * Returns true if this key is a local key, not yet knwon to the backend.
   * If an IKey is <strong>not</strong> a local key, it is guaranteed to be a 
   * strict value object.
   */
  public boolean isLocalKey() {
  	boolean result = keyFields == null;
  	if (!result) {
  		for (int i = 0; i < keyFields.length; i++) {
  			if (keyFields[i] == null) {
  				result = true;
  				break;
  			}
  		}
  	}
    return result;
  }
  
  /**
   * the key fields of this <code>Key</code>
   */
  private transient String[] keyFields;

  /**
   * sets the key fields of this <code>Key</code>
   */
  protected void takeFieldsFromRow(AspectRow row) {
//    if ( !isLocalKey() )
//      throw new IllegalStateException("You can only set the fields one time!");

    IStructureDescriptor structureDescriptor = keyDescriptor.getStructure();
    int noOfFields = structureDescriptor.size();
    keyFields = new String[noOfFields];
    for( int i=0; i<noOfFields; i++ ) {
      String fieldName = structureDescriptor.getFieldDescriptor(i).getName();
      String fieldValue = row.getAttributeAsString(fieldName); 
      keyFields[i] = "".equals(fieldValue) ? null : fieldValue;
    }
  }
 
  /**
   * returns the key fields of this <code>Key</code> or <code>null</code>, if Key is not complete
   * @return String[] the key fields of this <code>Key</code> or <code>null</code>, if Key is not complete
   */
  protected String[] getKeyFields() {
  	return isLocalKey() ? null : keyFields;
  }

  /**
   * Copies new values of key fields to the old collection. 
   * @param values new values of key fields will be copied into the old array of values. Length of the new array must match the length of old one. Otherwise RuntimeException will be thrown. 
   */
  protected void setKeyFields(String[] values) {
  	if (isLocalKey()) {
		keyFields = new String[getKeyDescriptor().getStructure().size()];
  	}
  	if (values.length != keyFields.length) {
  		throw new RuntimeException("Structure of fields are incompatible with the structure of key.");
  	}
  	for (int i = 0; i < values.length; i++) {
		keyFields[i] = values[i];
	}
  }

  /**
   * overwrites the method <code>equals</code> from <code>Object</code>
   */
  public boolean equals( Object other ) {
  	if (other == this) {
  		return true;
  	}
    if (other instanceof Key) {
	    // local keys are equal if they are same
	    if ( isLocalKey() )
	      return this == other;
	
	    // backend keys are equal if their keyFields are equal (in number, order and value)
	    return Arrays.equals(keyFields, ((Key)other).getKeyFields());
    } else {
    	return false;
    }
  }
  
  /**
   * overwrites the method <code>hashCode</code> from <code>Object</code>
   */
  
  public int hashCode() {
  	// There is no easy way to ensure general contract for overriding java.lang.Object.hashCode().
	// Such performance degradation is needed to solve the problem with the key that can change its value during the program flow.  
	return 0;

/*    // hashCode of local keys is identity hashCode
    if ( isLocalKey() ) 
      return super.hashCode();

    // hashCode for business keys is determined from key fields    
    // (the following algorithm has been copied from the documentation 
    //  of List.hashCode())
    
    int hash=1;
    for(int i=0; i<keyFields.length; i++) {
      hash = 31*hash + (keyFields[i]==null ? 0 : keyFields[i].hashCode());
    }
    return hash;
*/
   }
  
  /**
   * returns a String representation of this <code>Key</code>. If Key contains the
   * fields "name1" and "name2" for example the String representation looks like:
   * <pre> [name1, name2] </pre>. For local keys a string representation based on the 
   * identityHashCode is returned.
   * @return String a String representation of this <code>Key</code>
   */
  public String toString() {

    StringBuffer buf = new StringBuffer("[");
    
    if ( isLocalKey() ) {
      buf
       .append("localKey@")
       .append(Integer.toHexString(System.identityHashCode(this)));
    }
    else {
      for( int i=0; i<keyFields.length; i++ ) {
        buf.append(keyFields[i]);
        if ( i < keyFields.length - 1 )
          buf.append(";");
      }
    }
    buf.append("]");
    
    return buf.toString();
  }
  
	/* (non-Javadoc)
	 * @see java.lang.Object#clone()
	 */
	public Object clone() throws CloneNotSupportedException {
		Key key = (Key) super.clone(); 
		key.keyDescriptor = getKeyDescriptor();
		return key;
	}

	/* (non-Javadoc)
	 * @see com.sap.tc.col.client.generic.api.IKey#getFields()
	 */
	public String[] getFields() {
		return keyFields;
	}

}
