/**
 * realizes a root object for an Aspect cache.<p>
 * There exist two objects <code>Query</code> and <code>Aspect</code>, which
 * are root objects of an Aspect cache
 * @author Helmut Mueller
 */
package com.sap.caf.rt.ui.cool.generic;

public interface ICacheRootObject {
  
  /**
   * Invalidates the root object of the cache and the cache itself.<p>
   * Additionally the directed graph starting from root object is invalidated.
   */
  void invalidate();
  
  /**
   * returns <code>true</code> if this instance of the implementing class
   * is root object of the cache.<p>
   */
  boolean isCacheRootObject();
  
  /**
   * returns the associated <code>AspectCache</code>
   */
  AspectCache getAspectCache(); 
}
