package com.sap.caf.rt.ui.cool.generic;

import java.io.PrintStream;
import java.io.PrintWriter;


/**
 * @author d020684
 *
 * To change this generated comment edit the template variable "typecomment":
 * Window>Preferences>Java>Templates.
 * To enable and disable the creation of type comments go to
 * Window>Preferences>Java>Code Generation.
 */
public class GCPRuntimeException extends RuntimeException {

  private Throwable m_cause;

  /**
   * Constructor for GCPRuntimeException.
   * @param message the message associated with the exception
   */
  public GCPRuntimeException(String message) {
    this(message, null);
  }

  /**
   * Constructor for GCPRuntimeException.
   */
  public GCPRuntimeException(Throwable cause) {
    this("", cause);
  }

  /**
   * Constructor for GCPRuntimeException.
   */
  public GCPRuntimeException(String message, Throwable cause) {
    super(message);
    m_cause = cause;
  }

  /**
   * Returns the cause or null
   */
  public Throwable getCause() {
    return m_cause;
  }
  
  /**
   * @see java.lang.Throwable#printStackTrace()
   */
  public void printStackTrace() {
    super.printStackTrace();
    if (m_cause != null) {
      System.err.println("Caused by:");
      m_cause.printStackTrace();
    }
  }
  
  /**
   * @see java.lang.Throwable#printStackTrace(java.io.PrintStream)
   */
  public void printStackTrace(PrintStream ps) {
    super.printStackTrace(ps);
    if (m_cause != null) {
      ps.println("Caused by:");
      m_cause.printStackTrace(ps);
    }
  }
  
  /**
   * @see java.lang.Throwable#printStackTrace(java.io.PrintWriter)
   */
  public void printStackTrace(PrintWriter pw) {
    super.printStackTrace(pw);
    if (m_cause != null) {
      pw.println("Caused by:");
      m_cause.printStackTrace(pw);
    }
  }

  /**
   * @see java.lang.Throwable#getMessage()
   */
  public String getMessage() {
    return super.getMessage() + 
      (m_cause != null ? " Caused by: " + m_cause.getMessage() : "");
  }

}

