package com.sap.caf.rt.ui.cool.generic;

import com.sap.caf.rt.services.serviceaccess.SimpleDataContainer;
import com.sap.caf.rt.srv.IDataContainerBean;
import com.sap.tc.col.client.metadata.api.IFieldDescriptor;
import com.sap.tc.col.client.metadata.api.IStructureDescriptor;

import com.sap.tc.col.edo.IEdoReadStream;
import com.sap.tc.col.edo.IEdoStructure;
import com.sap.tc.col.edo.IEdoTable;
import com.sap.tc.col.edo.IEdoVariant;
import com.sap.tc.col.edo.IEdoWriteStream;

import com.sap.tc.col.edo.core.EdoVariant;
import com.sap.tc.col.edo.core.TypeHelper;
import com.sap.tc.logging.Location;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Iterator;

public final class EdoTable extends EdoAbstractValue
	implements IEdoTableEx
	
{
	private static final String APPLICATION	= EdoTable.class.getName();
	private static final Location logger = Location.getLocation(APPLICATION);
	
	
//	class TableRowIterator
//		implements Iterator
//	{
//
//		public TableRowIterator(EdoTable table, Iterator iterator)
//		{
//			m_table = table;
//			m_iterator = iterator;
//		}
//
//		public boolean hasNext()
//		{
//			return m_iterator.hasNext();
//		}
//
//		public Object next()
//		{
//			Object record[] = (Object[])m_iterator.next();
//			return m_table.getRow(record);
//		}
//
//		public void remove()
//		{
//			m_iterator.remove();
//		}
//
//		private final EdoTable m_table;
//		private final Iterator m_iterator;
//	}

	public EdoTable(IStructureDescriptor descriptor, int capacity)
	{
		m_descriptor = descriptor;
		m_fieldCount = descriptor.size();
		m_table = new ArrayList(capacity);
	}

	private EdoTable(EdoTable table)
	{
		m_descriptor = table.m_descriptor;
		m_fieldCount = table.m_fieldCount;
		m_fieldsThatNeedDeepCopy = table.m_fieldsThatNeedDeepCopy;
		m_table = new ArrayList(table.m_table.size());
		table.append(table, 0, table.m_table.size());
	}

	public EdoTable(IStructureDescriptor descriptor)
	{
		m_descriptor = descriptor;
		m_fieldCount = descriptor.size();
		m_table = new ArrayList();
	}

	public String getMeta()
	{
		return "T";
	}

	public String getType()
	{
		return m_descriptor.getName();
	}

	public IStructureDescriptor getDescriptor()
	{
		return m_descriptor;
	}

	public int getFieldCount()
	{
		return m_descriptor.size();
	}

	public int getRecordCount()
	{
		return m_table.size();
	}

	public void clear()
	{
		m_table.clear();
	}

	public Iterator getRecordIterator()
	{
		throw new UnsupportedOperationException("This operation is not supported");
		//return new TableRowIterator(this, m_table.iterator());
	}

	public IEdoStructure getRecord(int recordIndex)
	{
//		Object record[] = (Object[])m_table.get(recordIndex);
		//IDataContainerBean record = (IDataContainerBean) m_table.get(recordIndex);
//		return getRow(record);
		throw new UnsupportedOperationException("This operation is not supported");
	}
	
	public IDataContainerBean getRecordDataBean(int recordIndex)
	{
		IDataContainerBean record = (IDataContainerBean) m_table.get(recordIndex);
		return record;
	}

	public boolean isInitial(int recordIndex, String fieldName)
	{
		return isInitial(recordIndex, getFieldIndex(fieldName));
	}

	public final boolean isInitial(int recordIndex, int fieldIndex)
	{
		checkRecordIndex(recordIndex);
		checkFieldIndex(fieldIndex);
		return getValueInternal(recordIndex, fieldIndex) == null;
	}

	public Object getValue(int recordIndex, String fieldName)
	{
		return getValue(recordIndex, getFieldIndex(fieldName));
	}

	public final Object getValue(int recordIndex, int fieldIndex)
	{
		String type = getFieldType(fieldIndex);
		if(type.equals("VARIANT"))
			return getVariantValue(recordIndex, fieldIndex);
		if(type.equals("TIMESTAMP")) {
			java.util.Date d = 
				(java.util.Date)getValueInternal(recordIndex, fieldIndex);
			if((d!= null)&& !(d instanceof Timestamp)) {
				return new Timestamp(d.getTime());
			}
			return d;
		} else
			return getValueInternal(recordIndex, fieldIndex);//TypeHelper.parse(getStringValue(recordIndex, fieldIndex), type);
	}

	public void setValue(int recordIndex, String fieldName, Object value)
	{
		setValue(recordIndex, getFieldIndex(fieldName), value);
	}

	public final void setValue(int recordIndex, int fieldIndex, Object value)
	{
		String type = getFieldType(fieldIndex);
		if(type.equals("VARIANT")) {
			throw new NoSuchMethodError("Method setValue() is not supported for variants.");
		} else {
			if(value instanceof Long) {
				checkRecordIndex(recordIndex);
				checkFieldIndex(fieldIndex);
			
				setValueInternal(recordIndex, fieldIndex, value);
			} else {
				checkRecordIndex(recordIndex);
				checkFieldIndex(fieldIndex);
				checkFieldType(fieldIndex, type);
				
				String str = TypeHelper.getType(type).format(value);
				Object obj = TypeHelper.getType(type).parse(str);
				
				if("STRING".equals(type) && "".equals(obj)) {
					obj = null;
				}
				
				setValueInternal(recordIndex, fieldIndex, obj);
			}
			return;
		}
	}
	
	/**
	 * 
	 */
	public final void setValue(int index, IDataContainerBean data) {
		IFieldDescriptor[] fields = m_descriptor.getFieldDescriptors();
		for(int i=0;i<fields.length;++i) {
			try {
				String fieldType = fields[i].getType();
				String fieldName = fields[i].getName();
				
				if(!"STRING".equals(fieldType)) {
					Object value = data.getProperty(fieldName);
					
					if(value instanceof Long) {
						data.setProperty(fieldName, value);
					} else {
						TypeHelper.Type type = TypeHelper.getType(fieldType);
						
						String str = type.format(value);
						Object parsedObj = type.parse(str);
	
						data.setProperty(fieldName, parsedObj);
					}
				} else {
					Object value = data.getProperty(fieldName);
					if("".equals(value)) {
						data.setProperty(fieldName, null);
					}
				}
			} catch(Exception e) {
			}
		}
	
		if(index<m_table.size()) {
			m_table.set(index, data);
		} else {
			m_table.add(data);
		}
	}
		
	public Object getValue(int recordIndex, String fieldName, boolean createIfNull)
	{
		return getValue(recordIndex, getFieldIndex(fieldName), createIfNull);
	}

	public final Object getValue(int recordIndex, int fieldIndex, boolean createIfNull)
	{
		String type = getFieldType(fieldIndex);
		if(type.equals("VARIANT"))
			return getVariantValue(recordIndex, fieldIndex, createIfNull);
		if(type.equals("TIMESTAMP")) {
			java.util.Date d = 
				(java.util.Date)getValueInternal(recordIndex, fieldIndex);
			if((d != null) && !(d instanceof Timestamp)) {
				return new Timestamp(d.getTime());
			}
			return d;
		}

		return getValueInternal(recordIndex, fieldIndex);//TypeHelper.parse(getStringValue(recordIndex, fieldIndex), type);
	}

	public final String getStringValue(int recordIndex, int fieldIndex)
	{
		checkRecordIndex(recordIndex);
		checkFieldIndex(fieldIndex);
		checkFieldType(fieldIndex, "STRING");
		try {
			Object value = getValueInternal(recordIndex, fieldIndex);
			return value != null ? value.toString() : "";
		} catch(Exception e) {
			logger.catching(e);
			return "";
		}
	}

	public String getStringValue(int recordIndex, String fieldname)
	{
		Object value = getValueInternal(recordIndex, getFieldIndex(fieldname));
		return value != null ? value.toString() : "";
	}

	public final void setStringValue(int recordIndex, int fieldIndex, String value)
	{
		checkRecordIndex(recordIndex);
		checkFieldIndex(fieldIndex);
		checkFieldType(fieldIndex, "STRING");
		setValueInternal(recordIndex, fieldIndex, value);
	}

	public void setStringValue(int recordIndex, String fieldname, String value)
	{
		checkRecordIndex(recordIndex);
		setValueInternal(recordIndex, getFieldIndex(fieldname), value);
	}

	public int getIntValue(int recordIndex, String fieldName)
	{
		return getIntValue(recordIndex, getFieldIndex(fieldName));
	}

	public void setIntValue(int recordIndex, String fieldName, int value)
	{
		throw new UnsupportedOperationException("This operation is not supported");
		//setIntValue(recordIndex, getFieldIndex(fieldName), value);
	}

	public final int getIntValue(int recordIndex, int fieldIndex)
	{
		checkRecordIndex(recordIndex);
		checkFieldIndex(fieldIndex);
		checkFieldType(fieldIndex, "INTEGER");
		return TypeHelper.getType("INTEGER").parseInt(getStringValue(recordIndex, fieldIndex));
	}

	public final void setIntValue(int recordIndex, int fieldIndex, int value)
	{
		throw new UnsupportedOperationException("This operation is not supported");
//		checkRecordIndex(recordIndex);
//		checkFieldIndex(fieldIndex);
//		checkFieldType(fieldIndex, "INTEGER");
//		setValueInternal(recordIndex, fieldIndex, TypeHelper.getType("INTEGER").format(value));
	}

	public boolean getBooleanValue(int recordIndex, String fieldName)
	{
		return getBooleanValue(recordIndex, getFieldIndex(fieldName));
	}

	public void setBooleanValue(int recordIndex, String fieldName, boolean value)
	{
		throw new UnsupportedOperationException("This operation is not supported");
		//setBooleanValue(recordIndex, getFieldIndex(fieldName), value);
	}

	public final boolean getBooleanValue(int recordIndex, int fieldIndex)
	{
		checkRecordIndex(recordIndex);
		checkFieldIndex(fieldIndex);
		checkFieldType(fieldIndex, "BOOLEAN");
		return TypeHelper.getType("BOOLEAN").parseBoolean(getStringValue(recordIndex, fieldIndex));
	}

	public final void setBooleanValue(int recordIndex, int fieldIndex, boolean value)
	{
		throw new UnsupportedOperationException("This operation is not supported");
//		checkRecordIndex(recordIndex);
//		checkFieldIndex(fieldIndex);
//		checkFieldType(fieldIndex, "BOOLEAN");
//		setValueInternal(recordIndex, fieldIndex, TypeHelper.getType("BOOLEAN").format(value));
	}

	public double getDoubleValue(int recordIndex, String fieldName)
	{
		return getDoubleValue(recordIndex, getFieldIndex(fieldName));
	}

	public void setDoubleValue(int recordIndex, String fieldName, double value)
	{
		throw new UnsupportedOperationException("This operation is not supported");
//		setDoubleValue(recordIndex, getFieldIndex(fieldName), value);
	}

	public final double getDoubleValue(int recordIndex, int fieldIndex)
	{
		checkRecordIndex(recordIndex);
		checkFieldIndex(fieldIndex);
		checkFieldType(fieldIndex, "DOUBLE");
		return TypeHelper.getType("DOUBLE").parseDouble(getStringValue(recordIndex, fieldIndex));
	}

	public final void setDoubleValue(int recordIndex, int fieldIndex, double value)
	{
		throw new UnsupportedOperationException("This operation is not supported");
//		checkRecordIndex(recordIndex);
//		checkFieldIndex(fieldIndex);
//		checkFieldType(fieldIndex, "DOUBLE");
//		setValueInternal(recordIndex, fieldIndex, TypeHelper.getType("DOUBLE").format(value));
	}

	public Date getDateValue(int recordIndex, String fieldName)
	{
		return getDateValue(recordIndex, getFieldIndex(fieldName));
	}

	public void setDateValue(int recordIndex, String fieldName, Date value)
	{
		throw new UnsupportedOperationException("This operation is not supported");
		//setDateValue(recordIndex, getFieldIndex(fieldName), value);
	}

	public final Date getDateValue(int recordIndex, int fieldIndex)
	{
		checkRecordIndex(recordIndex);
		checkFieldIndex(fieldIndex);
		checkFieldType(fieldIndex, "DATE");
		return (Date)TypeHelper.parse(getStringValue(recordIndex, fieldIndex), "DATE");
	}

	public final void setDateValue(int recordIndex, int fieldIndex, Date value)
	{
		throw new UnsupportedOperationException("This operation is not supported");
//		checkRecordIndex(recordIndex);
//		checkFieldIndex(fieldIndex);
//		checkFieldType(fieldIndex, "DATE");
//		setValueInternal(recordIndex, fieldIndex, TypeHelper.format(value, "DATE"));
	}

	public Time getTimeValue(int recordIndex, String fieldName)
	{
		return getTimeValue(recordIndex, getFieldIndex(fieldName));
	}

	public void setTimeValue(int recordIndex, String fieldName, Time value)
	{
		throw new UnsupportedOperationException("This operation is not supported");
//		setTimeValue(recordIndex, getFieldIndex(fieldName), value);
	}

	public final Time getTimeValue(int recordIndex, int fieldIndex)
	{
		checkRecordIndex(recordIndex);
		checkFieldIndex(fieldIndex);
		checkFieldType(fieldIndex, "TIME");
		return (Time)TypeHelper.parse(getStringValue(recordIndex, fieldIndex), "TIME");
	}

	public final void setTimeValue(int recordIndex, int fieldIndex, Time value)
	{
		throw new UnsupportedOperationException("This operation is not supported");
//		checkRecordIndex(recordIndex);
//		checkFieldIndex(fieldIndex);
//		checkFieldType(fieldIndex, "TIME");
//		setValueInternal(recordIndex, fieldIndex, TypeHelper.format(value, "TIME"));
	}

	public BigDecimal getDecimalValue(int recordIndex, String fieldName)
	{
		return getDecimalValue(recordIndex, getFieldIndex(fieldName));
	}

	public void setDecimalValue(int recordIndex, String fieldName, BigDecimal value)
	{
		throw new UnsupportedOperationException("This operation is not supported");
		//setDecimalValue(recordIndex, getFieldIndex(fieldName), value);
	}

	public final BigDecimal getDecimalValue(int recordIndex, int fieldIndex)
	{
		checkRecordIndex(recordIndex);
		checkFieldIndex(fieldIndex);
		checkFieldType(fieldIndex, "DECIMAL");
		return (BigDecimal)TypeHelper.parse(getStringValue(recordIndex, fieldIndex), "DECIMAL");
	}

	public final void setDecimalValue(int recordIndex, int fieldIndex, BigDecimal value)
	{
		throw new UnsupportedOperationException("This operation is not supported");
//		checkRecordIndex(recordIndex);
//		checkFieldIndex(fieldIndex);
//		checkFieldType(fieldIndex, "DECIMAL");
//		setValueInternal(recordIndex, fieldIndex, TypeHelper.format(value, "DECIMAL"));
	}

	public Timestamp getTimestampValue(int recordIndex, String fieldName)
	{
		return getTimestampValue(recordIndex, getFieldIndex(fieldName));
	}

	public void setTimestampValue(int recordIndex, String fieldName, Timestamp value)
	{
		throw new UnsupportedOperationException("This operation is not supported");
//		setTimestampValue(recordIndex, getFieldIndex(fieldName), value);
	}

	public final Timestamp getTimestampValue(int recordIndex, int fieldIndex)
	{
		checkRecordIndex(recordIndex);
		checkFieldIndex(fieldIndex);
		checkFieldType(fieldIndex, "TIMESTAMP");
		return (Timestamp)TypeHelper.parse(getStringValue(recordIndex, fieldIndex), "TIMESTAMP");
	}

	public final void setTimestampValue(int recordIndex, int fieldIndex, Timestamp value)
	{
		throw new UnsupportedOperationException("This operation is not supported");
//		checkRecordIndex(recordIndex);
//		checkFieldIndex(fieldIndex);
//		checkFieldType(fieldIndex, "TIMESTAMP");
//		setValueInternal(recordIndex, fieldIndex, TypeHelper.format(value, "TIMESTAMP"));
	}

	public byte[] getBinaryValue(int recordIndex, String fieldName)
	{
		return getBinaryValue(recordIndex, getFieldIndex(fieldName));
	}

	public void setBinaryValue(int recordIndex, String fieldName, byte value[])
	{
		throw new UnsupportedOperationException("This operation is not supported");
		//setBinaryValue(recordIndex, getFieldIndex(fieldName), value);
	}

	public final byte[] getBinaryValue(int recordIndex, int fieldIndex)
	{
		checkRecordIndex(recordIndex);
		checkFieldIndex(fieldIndex);
		checkFieldType(fieldIndex, "BINARY");
		return (byte[])TypeHelper.parse(getStringValue(recordIndex, fieldIndex), "BINARY");
	}

	public final void setBinaryValue(int recordIndex, int fieldIndex, byte value[])
	{
		throw new UnsupportedOperationException("This operation is not supported");
//		checkRecordIndex(recordIndex);
//		checkFieldIndex(fieldIndex);
//		checkFieldType(fieldIndex, "BINARY");
//		setValueInternal(recordIndex, fieldIndex, TypeHelper.format(value, "BINARY"));
	}

	public final IEdoVariant getVariantValue(int recordIndex, int fieldIndex)
	{
		checkRecordIndex(recordIndex);
		checkFieldIndex(fieldIndex);
		checkFieldType(fieldIndex, "VARIANT");
		Object value = getValueInternal(recordIndex, fieldIndex);
		if(value == null)
			return null;
		if(value instanceof IEdoVariant)
		{
			return (IEdoVariant)value;
		} else
		{
			IFieldDescriptor fieldDescriptor = m_descriptor.getFieldDescriptor(fieldIndex);
			IEdoVariant variant = EdoVariant.convertXMLToVariant(fieldDescriptor, (String)value);
			setValueInternal(recordIndex, fieldIndex, variant);
			return variant;
		}
	}

	public IEdoVariant getVariantValue(int recordIndex, String fieldname)
	{
		return getVariantValue(recordIndex, getFieldIndex(fieldname));
	}

	public final IEdoVariant getVariantValue(int recordIndex, int fieldIndex, boolean createIfNull)
	{
		Object value = getVariantValue(recordIndex, fieldIndex);
		if(value == null && createIfNull)
			return newVariantValueInternal(recordIndex, fieldIndex);
		else
			return (IEdoVariant)value;
	}

	public IEdoVariant getVariantValue(int recordIndex, String fieldname, boolean createIfNull)
	{
		return getVariantValue(recordIndex, getFieldIndex(fieldname), createIfNull);
	}

	public int append(int count)
	{
		int retValue = m_table.size();
		for(; count > 0; count--)
			m_table.add(((Object) (newRecord())));

		return retValue;
	}

	public int append(IEdoStructure source)
	{
		throw new UnsupportedOperationException("This operation is not supported");
//		EdoStructure sRecord = (EdoStructure)source;
//		checkDescriptor(source.getDescriptor());
//		int retValue = m_table.size();
//		m_table.add(((Object) (newRecord(sRecord.m_record))));
//		return retValue;
	}

//	public int appendCorresponding(IEdoStructure source)
//	{
//		EdoStructure sRecord = (EdoStructure)source;
//		int indices[] = getCorrespondingIndices(((EdoStructure)source).m_descriptor, m_descriptor);
//		int retValue = m_table.size();
//		m_table.add(((Object) (newRecord(((Object) (sRecord.m_record)), indices))));
//		return retValue;
//	}

	public int append(IEdoTable source, int sourceIndex, int count)
	{
		ArrayList sTable = ((EdoTable)source).m_table;
		checkDescriptor(source.getDescriptor());
		int retValue = m_table.size();
		m_table.ensureCapacity(retValue + count);
		for(int endIndex = sourceIndex + count; sourceIndex < endIndex; sourceIndex++)
			m_table.add(((Object) (newRecord(sTable.get(sourceIndex)))));

		return retValue;
	}

//	public int appendCorresponding(IEdoTable source, int sourceIndex, int count)
//	{
//		ArrayList sTable = ((EdoTable)source).m_table;
//		int indices[] = getCorrespondingIndices(((EdoTable)source).m_descriptor, m_descriptor);
//		int retValue = m_table.size();
//		m_table.ensureCapacity(retValue + count);
//		for(int endIndex = sourceIndex + count; sourceIndex < endIndex; sourceIndex++)
//			m_table.add(((Object) (newRecord(sTable.get(sourceIndex), indices))));
//
//		return retValue;
//	}

	public void setRecord(int recordIndex, IEdoStructure source)
	{
		checkRecordIndex(recordIndex);
		checkDescriptor(source.getDescriptor());
		copyRecord(((Object) (((EdoStructure)source).m_record)), m_table.get(recordIndex));
	}

	public void getRecord(int recordIndex, IEdoStructure destination)
	{
		checkRecordIndex(recordIndex);
		checkDescriptor(destination.getDescriptor());
		copyRecord(m_table.get(recordIndex), ((Object) (((EdoStructure)destination).m_record)));
	}

//	public void getCorrespondingRecord(int recordIndex, IEdoStructure destination)
//	{
//		checkRecordIndex(recordIndex);
//		EdoStructure tDestination = (EdoStructure)destination;
//		int indices[] = getCorrespondingIndices(m_descriptor, tDestination.m_descriptor);
//		copyRecord((Object[])m_table.get(recordIndex), tDestination.m_record, indices);
//	}

//	public void setCorrespondingRecord(int recordIndex, IEdoStructure source)
//	{
//		checkRecordIndex(recordIndex);
//		EdoStructure tSource = (EdoStructure)source;
//		int indices[] = getCorrespondingIndices(tSource.m_descriptor, m_descriptor);
//		copyRecord(tSource.m_record, (Object[])m_table.get(recordIndex), indices);
//	}

	public void getTable(int recordIndices[], IEdoTable destination)
	{
		int len = recordIndices.length;
		EdoTable d = (EdoTable)destination;
		checkDescriptor(d.m_descriptor);
		ArrayList dTable = d.m_table;
		dTable.ensureCapacity(dTable.size() + len);
		for(int i = 0; i < len; i++)
		{
			int srcRecordIndex = recordIndices[i];
			checkRecordIndex(srcRecordIndex);
			dTable.add(((Object) (newRecord(m_table.get(srcRecordIndex)))));
		}

	}

	public void setTable(int recordIndices[], IEdoTable source, int startIndex)
	{
		int len = recordIndices.length;
		EdoTable s = (EdoTable)source;
		checkDescriptor(s.m_descriptor);
		s.checkRecordIndex((startIndex + len) - 1);
		ArrayList sTable = s.m_table;
		int i = 0;
		for(int srcRecordIndex = startIndex; i < len; srcRecordIndex++)
		{
			int destRecordIndex = recordIndices[i];
			checkRecordIndex(destRecordIndex);
			copyRecord(sTable.get(srcRecordIndex), m_table.get(destRecordIndex));
			i++;
		}

	}

	public void insertAt(int index, int count)
	{
		if(index == m_table.size())
		{
			append(count);
		} else
		{
			checkRecordIndex(index);
			ArrayList tempList = new ArrayList(count);
			for(; count > 0; count--)
				tempList.add(((Object) (newRecord())));

			m_table.addAll(index, tempList);
		}
	}

	public int insertAt(int index, IEdoStructure source)
	{
		EdoStructure sRecord = (EdoStructure)source;
		checkDescriptor(source.getDescriptor());
		int retValue = m_table.size();
		m_table.add(index, ((Object) (newRecord(sRecord.m_record))));
		return retValue;
	}

//	public int insertCorrespondingAt(int index, IEdoStructure source)
//	{
//		EdoStructure sRecord = (EdoStructure)source;
//		int indices[] = getCorrespondingIndices(((EdoStructure)source).m_descriptor, m_descriptor);
//		int retValue = m_table.size();
//		m_table.add(index, ((Object) (newRecord(((Object) (sRecord.m_record)), indices))));
//		return retValue;
//	}

	public void insertAt(int index, IEdoTable source, int sourceIndex, int count)
	{
		if(index == m_table.size())
		{
			append(source, sourceIndex, count);
		} else
		{
			checkRecordIndex(index);
			checkDescriptor(source.getDescriptor());
			ArrayList sTable = ((EdoTable)source).m_table;
			ArrayList tempList = new ArrayList(count);
			for(int endIndex = sourceIndex + count; sourceIndex < endIndex; sourceIndex++)
				tempList.add(((Object) (newRecord(sTable.get(sourceIndex)))));

			m_table.addAll(index, tempList);
		}
	}

//	public void insertCorrespondingAt(int index, IEdoTable source, int sourceIndex, int count)
//	{
//		if(index == m_table.size())
//		{
//			appendCorresponding(source, sourceIndex, count);
//		} else
//		{
//			ArrayList sTable = ((EdoTable)source).m_table;
//			int indices[] = getCorrespondingIndices(((EdoTable)source).m_descriptor, m_descriptor);
//			ArrayList tempList = new ArrayList(count);
//			for(int endIndex = sourceIndex + count; sourceIndex < endIndex; sourceIndex++)
//				tempList.add(((Object) (newRecord(sTable.get(sourceIndex), indices))));
//
//			m_table.addAll(index, tempList);
//		}
//	}

	public void deleteFrom(int index)
	{
		checkRecordIndex(index);
		m_table.remove(index);
	}

	public void deleteFrom(int startIndex, int count)
	{
		checkRecordIndex((startIndex + count) - 1);
		m_table.subList(startIndex, startIndex + count).clear();
	}

	public void readFrom(IEdoReadStream readStream)
	{
		readStream.read(this);
	}

	public void writeTo(IEdoWriteStream writeStream)
	{
		writeStream.write(this);
	}

	final int getRecordCountInternal()
	{
		return m_table.size();
	}

	final Object getValueInternal(int recordIndex, int fieldIndex)
	{
		IDataContainerBean data = (IDataContainerBean) m_table.get(recordIndex);
		
		if(data!=null) {
			return data.getProperty(m_descriptor.getFieldDescriptor(fieldIndex).getName());
		}
		return null;
		//return ((Object[])m_table.get(recordIndex))[fieldIndex];
	}

	final void setValueInternal(int recordIndex, int fieldIndex, Object value)
	{
		//((Object[])m_table.get(recordIndex))[fieldIndex] = value;
		IDataContainerBean data = (IDataContainerBean) m_table.get(recordIndex);
		data.setProperty(m_descriptor.getFieldDescriptor(fieldIndex).getName(), value);
	}

	final EdoVariant newVariantValueInternal(int recordIndex, int fieldIndex)
	{
		EdoVariant value = new EdoVariant(m_descriptor.getFieldDescriptor(fieldIndex));
		setValueInternal(recordIndex, fieldIndex, value);
		return value;
	}

	final void clearInternal()
	{
		m_table.clear();
	}

	final void appendInternal()
	{
		m_table.add(((Object) (newRecord())));
	}

	final EdoStructure getRow(Object record[])
	{
		throw new UnsupportedOperationException("This operation is not supported");
//		EdoStructure row = (EdoStructure)record[m_fieldCount + FIELD_OFFSET_RECORD];
//		if(row == null)
//		{
//			row = new EdoStructure(m_descriptor, record);
//			record[m_fieldCount + FIELD_OFFSET_RECORD] = row;
//		}
//		return row;
	}

	EdoAbstractValue deepCopy()
	{
		return new EdoTable(this);
	}

	private int getFieldIndex(String fieldname)
	{
		int fieldIndex = m_descriptor.getFieldIndex(fieldname);
		if(0 > fieldIndex)
			throw new IllegalArgumentException("Field name '" + fieldname + "' not found in structure '" + m_descriptor.getName() + "'.");
		else
			return fieldIndex;
	}

	private void checkRecordIndex(int recordIndex)
	{
		if(recordIndex < 0 || recordIndex >= m_table.size())
			throw new IndexOutOfBoundsException("Record index " + recordIndex + " out of range. Should be >= 0 and < " + m_table.size());
		else
			return;
	}

	private void checkFieldIndex(int fieldIndex)
	{
		if(fieldIndex < 0 || fieldIndex >= m_fieldCount)
			throw new IndexOutOfBoundsException("Field index " + fieldIndex + " out of range. Should be >= 0 and < " + m_fieldCount);
		else
			return;
	}

	private void checkDescriptor(IStructureDescriptor descriptor)
	{
		if(!m_descriptor.equals(descriptor))
			throw new IllegalArgumentException("Different Structure type: expected '" + m_descriptor.getName() + "' found '" + descriptor.getName() + "'.");
		else
			return;
	}

	private Object newRecord()
	{
		SimpleDataContainer data = new SimpleDataContainer();
		IFieldDescriptor[] fields = m_descriptor.getFieldDescriptors();
		for(int i=0;i<fields.length;++i) {
			try {
				if(!"STRING".equals(fields[i].getType())) {
					TypeHelper.Type type = TypeHelper.getType(fields[i].getType());
		
					Object value = data.getProperty(fields[i].getName());
	
					String str = type.format(value);
					Object parsedObj = type.parse(str);
	
					data.setProperty(fields[i].getName(), parsedObj);
				}
			} catch(Exception e) {
			}
		}
		return data;
	}

	private Object[] newRecord(Object src[])
	{
		Object newRecord[] = new Object[m_fieldCount + NO_OF_EXTRA_FIELDS];
		copyRecord(((Object) (src)), ((Object) (newRecord)));
		return newRecord;
	}

	private Object[] newRecord(Object src)
	{
		Object newRecord[] = new Object[m_fieldCount + NO_OF_EXTRA_FIELDS];
		copyRecord(src, ((Object) (newRecord)));
		return newRecord;
	}

//	private Object[] newRecord(Object src, int indices[])
//	{
//		Object srcRecord[] = (Object[])src;
//		Object newRecord[] = newRecord();
//		copyRecord(srcRecord, newRecord, indices);
//		return newRecord;
//	}

	private void copyRecord(Object src, Object dest)
	{
		System.arraycopy(src, 0, dest, 0, m_fieldCount);
		deepCopyFieldsThatNeedDeepCopy((Object[])dest);
	}

//	private void copyRecord(Object src[], Object dest[], int indices[])
//	{
//		int i = 0;
//		for(int len = indices.length - 1; i < len; i += 3)
//			if(indices[i + 2] == 0)
//			{
//				dest[indices[i + 1]] = src[indices[i]];
//			} else
//			{
//				EdoAbstractValue value = (EdoAbstractValue)src[indices[i]];
//				if(value != null)
//					dest[indices[i + 1]] = value.deepCopy();
//			}
//
//	}

	private void deepCopyFieldsThatNeedDeepCopy(Object record[])
	{
		if(m_fieldsThatNeedDeepCopy == empty_fieldsThatNeedDeepCopy)
			return;
		if(m_fieldsThatNeedDeepCopy == null)
		{
			m_fieldsThatNeedDeepCopy = getFieldsThatNeedDeepCopy(m_descriptor);
			if(m_fieldsThatNeedDeepCopy.length == 0)
			{
				m_fieldsThatNeedDeepCopy = empty_fieldsThatNeedDeepCopy;
				return;
			}
		}
		int i = 0;
		for(int len = m_fieldsThatNeedDeepCopy.length; i < len; i++)
		{
			int index = m_fieldsThatNeedDeepCopy[i];
			EdoAbstractValue value = (EdoAbstractValue)record[index];
			if(value != null)
				record[index] = value.deepCopy();
		}

	}

	private void checkFieldType(int fieldIndex, String type)
	{
		boolean typeInvalid = false;
		IFieldDescriptor fieldDescriptor = m_descriptor.getFieldDescriptor(fieldIndex);
		if(type.equals("VARIANT") && !type.equals(fieldDescriptor.getType()))
			typeInvalid = true;
		else
		if(type.equals("STRING") && fieldDescriptor.getType().equals("VARIANT"))
			typeInvalid = true;
		if(typeInvalid)
			throw new IllegalArgumentException("Different Field type : expected '" + type + "' found '" + fieldDescriptor.getType() + "'.");
		else
			return;
	}

	private String getFieldType(int fieldIndex)
	{
		IFieldDescriptor fieldDescriptor = m_descriptor.getFieldDescriptor(fieldIndex);
		return fieldDescriptor.getType();
	}


	static int NO_OF_EXTRA_FIELDS = 1;
	static int FIELD_OFFSET_RECORD = 0;
	protected final IStructureDescriptor m_descriptor;
	protected final ArrayList m_table;
	protected final int m_fieldCount;
	protected static final int empty_fieldsThatNeedDeepCopy[] = new int[0];
	protected int m_fieldsThatNeedDeepCopy[];
	public static final int RESET_INDEX = -1;
	
}
