package com.sap.caf.rt.ui.cool.generic;

import com.sap.tc.col.client.metadata.api.IFieldDescriptor;
import com.sap.tc.col.client.metadata.api.IStructureDescriptor;
import com.sap.tc.col.edo.*;

import com.sap.tc.col.edo.core.EdoVariant;
import com.sap.tc.col.edo.core.TypeHelper;
import java.math.BigDecimal;
import java.sql.*;
import java.util.Arrays;
import java.util.Iterator;

public final class EdoStructure extends EdoAbstractValue
	implements IEdoStructure
{

	public EdoStructure(IStructureDescriptor descriptor)
	{
		m_descriptor = descriptor;
		m_record = new Object[descriptor.size()];
	}

	public EdoStructure(EdoStructure structure)
	{
		m_descriptor = structure.m_descriptor;
		m_record = (Object[])structure.m_record.clone();
		m_fieldsThatNeedDeepCopy = structure.m_fieldsThatNeedDeepCopy;
		deepCopyFieldsThatNeedDeepCopy();
	}

	EdoStructure(IStructureDescriptor descriptor, Object record[])
	{
		m_descriptor = descriptor;
		m_record = record;
	}

	public String getMeta()
	{
		return "S";
	}

	public String getType()
	{
		return m_descriptor.getName();
	}

	public IStructureDescriptor getDescriptor()
	{
		return m_descriptor;
	}

	public int getFieldCount()
	{
		return m_record.length;
	}

	public void clear()
	{
		Arrays.fill(m_record, null);
	}

	public Iterator getFieldIterator()
	{
		throw new UnsupportedOperationException("Method is not implemented.");
	}

	public boolean isInitial(String fieldName)
	{
		return isInitial(getFieldIndex(fieldName));
	}

	public Object getValue(String fieldName)
	{
		return getValue(getFieldIndex(fieldName));
	}

	public void setValue(String fieldName, Object value)
	{
		setValue(getFieldIndex(fieldName), value);
	}

	public final boolean isInitial(int fieldIndex)
	{
		checkFieldIndex(fieldIndex);
		return null == getValueInternal(fieldIndex);
	}

	public final Object getValue(int fieldIndex)
	{
		String type = getFieldType(fieldIndex);
		if(type.equals("VARIANT"))
			return getVariantValue(fieldIndex);
		else {
			Object value = getValueInternal(fieldIndex);
			if(value instanceof Long) {
				return value;
			}
			if("STRING".equals(type) && value == null) {
				return value;
			}
			return TypeHelper.parse((String)value, type);
		}
	}

	public final void setValue(int fieldIndex, Object value)
	{
		String type = getFieldType(fieldIndex);
		if(type.equals("VARIANT"))
		{
			throw new NoSuchMethodError("Method setValue() is not supported for variants.");
		} else
		{
			if(value instanceof Long) {
				checkFieldIndex(fieldIndex);
				setValueInternal(fieldIndex, value);
			} else {
				String val = TypeHelper.format(value, type);
				if("STRING".equals(type) && "".equals(val)) {
					val = null;
				}
				
				setStringValue(fieldIndex, val);
			}
			
			return;
		}
	}

	public Object getValue(String fieldName, boolean createIfNull)
	{
		return getValue(getFieldIndex(fieldName), createIfNull);
	}

	public final Object getValue(int fieldIndex, boolean createIfNull)
	{
		String type = getFieldType(fieldIndex);
		if(type.equals("VARIANT"))
			return getVariantValue(fieldIndex, createIfNull);
		else {
			Object value = getValueInternal(fieldIndex);
			if(value instanceof Long) {
				return value;
			}
			if("STRING".equals(type) && value == null) {
				return value;
			}
			return TypeHelper.parse((String)value, type);
		}
	}

	public int getIntValue(String fieldName)
	{
		return getIntValue(getFieldIndex(fieldName));
	}

	public void setIntValue(String fieldName, int value)
	{
		setIntValue(getFieldIndex(fieldName), value);
	}

	public final int getIntValue(int fieldIndex)
	{
		checkFieldIndex(fieldIndex);
		checkFieldType(fieldIndex, "INTEGER");
		return TypeHelper.getType("INTEGER").parseInt((String)getValueInternal(fieldIndex));
	}

	public final void setIntValue(int fieldIndex, int value)
	{
		checkFieldIndex(fieldIndex);
		checkFieldType(fieldIndex, "INTEGER");
		setValueInternal(fieldIndex, TypeHelper.getType("INTEGER").format(value));
	}

	public boolean getBooleanValue(String fieldName)
	{
		return getBooleanValue(getFieldIndex(fieldName));
	}

	public void setBooleanValue(String fieldName, boolean value)
	{
		setBooleanValue(getFieldIndex(fieldName), value);
	}

	public final boolean getBooleanValue(int fieldIndex)
	{
		checkFieldIndex(fieldIndex);
		checkFieldType(fieldIndex, "BOOLEAN");
		return TypeHelper.getType("BOOLEAN").parseBoolean((String)getValueInternal(fieldIndex));
	}

	public final void setBooleanValue(int fieldIndex, boolean value)
	{
		checkFieldIndex(fieldIndex);
		checkFieldType(fieldIndex, "BOOLEAN");
		setValueInternal(fieldIndex, TypeHelper.getType("BOOLEAN").format(value));
	}

	public double getDoubleValue(String fieldName)
	{
		return getDoubleValue(getFieldIndex(fieldName));
	}

	public void setDoubleValue(String fieldName, double value)
	{
		setDoubleValue(getFieldIndex(fieldName), value);
	}

	public final double getDoubleValue(int fieldIndex)
	{
		checkFieldIndex(fieldIndex);
		checkFieldType(fieldIndex, "DOUBLE");
		return TypeHelper.getType("DOUBLE").parseDouble((String)getValueInternal(fieldIndex));
	}

	public final void setDoubleValue(int fieldIndex, double value)
	{
		checkFieldIndex(fieldIndex);
		checkFieldType(fieldIndex, "DOUBLE");
		setValueInternal(fieldIndex, TypeHelper.getType("DOUBLE").format(value));
	}

	public Date getDateValue(String fieldName)
	{
		return getDateValue(getFieldIndex(fieldName));
	}

	public void setDateValue(String fieldName, Date value)
	{
		setDateValue(getFieldIndex(fieldName), value);
	}

	public final Date getDateValue(int fieldIndex)
	{
		checkFieldIndex(fieldIndex);
		checkFieldType(fieldIndex, "DATE");
		return (Date)TypeHelper.parse((String)getValueInternal(fieldIndex), "DATE");
	}

	public final void setDateValue(int fieldIndex, Date value)
	{
		checkFieldIndex(fieldIndex);
		checkFieldType(fieldIndex, "DATE");
		setValueInternal(fieldIndex, TypeHelper.format(value, "DATE"));
	}

	public Time getTimeValue(String fieldName)
	{
		return getTimeValue(getFieldIndex(fieldName));
	}

	public void setTimeValue(String fieldName, Time value)
	{
		setTimeValue(getFieldIndex(fieldName), value);
	}

	public final Time getTimeValue(int fieldIndex)
	{
		checkFieldIndex(fieldIndex);
		checkFieldType(fieldIndex, "TIME");
		return (Time)TypeHelper.parse((String)getValueInternal(fieldIndex), "TIME");
	}

	public final void setTimeValue(int fieldIndex, Time value)
	{
		checkFieldIndex(fieldIndex);
		checkFieldType(fieldIndex, "TIME");
		setValueInternal(fieldIndex, TypeHelper.format(value, "TIME"));
	}

	public BigDecimal getDecimalValue(String fieldName)
	{
		return getDecimalValue(getFieldIndex(fieldName));
	}

	public void setDecimalValue(String fieldName, BigDecimal value)
	{
		setDecimalValue(getFieldIndex(fieldName), value);
	}

	public final BigDecimal getDecimalValue(int fieldIndex)
	{
		checkFieldIndex(fieldIndex);
		checkFieldType(fieldIndex, "DECIMAL");
		return (BigDecimal)TypeHelper.parse((String)getValueInternal(fieldIndex), "DECIMAL");
	}

	public final void setDecimalValue(int fieldIndex, BigDecimal value)
	{
		checkFieldIndex(fieldIndex);
		checkFieldType(fieldIndex, "DECIMAL");
		setValueInternal(fieldIndex, TypeHelper.format(value, "DECIMAL"));
	}

	public Timestamp getTimestampValue(String fieldName)
	{
		return getTimestampValue(getFieldIndex(fieldName));
	}

	public void setTimestampValue(String fieldName, Timestamp value)
	{
		setTimestampValue(getFieldIndex(fieldName), value);
	}

	public final Timestamp getTimestampValue(int fieldIndex)
	{
		checkFieldIndex(fieldIndex);
		checkFieldType(fieldIndex, "TIMESTAMP");
		return (Timestamp)TypeHelper.parse((String)getValueInternal(fieldIndex), "TIMESTAMP");
	}

	public final void setTimestampValue(int fieldIndex, Timestamp value)
	{
		checkFieldIndex(fieldIndex);
		checkFieldType(fieldIndex, "TIMESTAMP");
		setValueInternal(fieldIndex, TypeHelper.format(value, "TIMESTAMP"));
	}

	public byte[] getBinaryValue(String fieldName)
	{
		return getBinaryValue(getFieldIndex(fieldName));
	}

	public void setBinaryValue(String fieldName, byte value[])
	{
		setBinaryValue(getFieldIndex(fieldName), value);
	}

	public final byte[] getBinaryValue(int fieldIndex)
	{
		checkFieldIndex(fieldIndex);
		checkFieldType(fieldIndex, "BINARY");
		return (byte[])TypeHelper.parse((String)getValueInternal(fieldIndex), "BINARY");
	}

	public final void setBinaryValue(int fieldIndex, byte value[])
	{
		checkFieldIndex(fieldIndex);
		checkFieldType(fieldIndex, "BINARY");
		setValueInternal(fieldIndex, TypeHelper.format(value, "BINARY"));
	}

	public final String getStringValue(int fieldIndex)
	{
		checkFieldIndex(fieldIndex);
		checkFieldType(fieldIndex, "STRING");
		String value = (String)getValueInternal(fieldIndex);
		return value != null ? value : "";
	}

	public String getStringValue(String fieldName)
	{
		String value = (String)getValueInternal(getFieldIndex(fieldName));
		return value != null ? value : "";
	}

	public final void setStringValue(int fieldIndex, String value)
	{
		checkFieldIndex(fieldIndex);
		checkFieldType(fieldIndex, "STRING");
		setValueInternal(fieldIndex, value);
	}

	public void setStringValue(String fieldName, String value)
	{
		setValueInternal(getFieldIndex(fieldName), value);
	}

	public final IEdoVariant getVariantValue(int fieldIndex)
	{
		checkFieldIndex(fieldIndex);
		checkFieldType(fieldIndex, "VARIANT");
		Object value = getValueInternal(fieldIndex);
		if(value == null)
			return null;
		if(value instanceof IEdoVariant)
		{
			return (IEdoVariant)value;
		} else
		{
			IFieldDescriptor fieldDescriptor = m_descriptor.getFieldDescriptor(fieldIndex);
			IEdoVariant variant = EdoVariant.convertXMLToVariant(fieldDescriptor, (String)value);
			setValueInternal(fieldIndex, variant);
			return variant;
		}
	}

	public IEdoVariant getVariantValue(String fieldName)
	{
		return (IEdoVariant)getValueInternal(getFieldIndex(fieldName));
	}

	public final IEdoVariant getVariantValue(int fieldIndex, boolean createIfNull)
	{
		Object value = getVariantValue(fieldIndex);
		if(value == null && createIfNull)
			return newVariantValueInternal(fieldIndex);
		else
			return (IEdoVariant)value;
	}

	public IEdoVariant getVariantValue(String fieldName, boolean createIfNull)
	{
		return getVariantValue(getFieldIndex(fieldName), createIfNull);
	}

	public void setCorrespondingFrom(IEdoStructure source)
	{
		int indices[] = getCorrespondingIndices(((EdoStructure)source).m_descriptor, m_descriptor);
		int i = 0;
		for(int len = indices.length - 1; i < len; i += 3)
		{
			Object srcRecord[] = ((EdoStructure)source).m_record;
			if(indices[i + 2] == 0)
			{
				m_record[indices[i + 1]] = srcRecord[indices[i]];
			} else
			{
				EdoAbstractValue value = (EdoAbstractValue)srcRecord[indices[i]];
				if(value != null)
					m_record[indices[i + 1]] = value.deepCopy();
			}
		}

	}

	public void setFrom(IEdoStructure source)
	{
		checkDescriptor(((EdoStructure)source).m_descriptor);
		Object srcRecord[] = ((EdoStructure)source).m_record;
		System.arraycopy(((Object) (srcRecord)), 0, ((Object) (m_record)), 0, m_record.length);
		deepCopyFieldsThatNeedDeepCopy();
	}

	public void readFrom(IEdoReadStream readStream)
	{
		readStream.read(this);
	}

	public void writeTo(IEdoWriteStream writeStream)
	{
		writeStream.write(this);
	}

	final void clearInternal()
	{
		Arrays.fill(m_record, null);
	}

	final EdoVariant newVariantValueInternal(int fieldIndex)
	{
		EdoVariant value = new EdoVariant(m_descriptor.getFieldDescriptor(fieldIndex));
		m_record[fieldIndex] = value;
		return value;
	}

	final void setValueInternal(int fieldIndex, Object value)
	{
		m_record[fieldIndex] = value;
	}

	final Object getValueInternal(int fieldIndex)
	{
		return m_record[fieldIndex];
	}

	EdoAbstractValue deepCopy()
	{
		return new EdoStructure(this);
	}

	private void deepCopyFieldsThatNeedDeepCopy()
	{
		if(m_fieldsThatNeedDeepCopy == empty_fieldsThatNeedDeepCopy)
			return;
		if(m_fieldsThatNeedDeepCopy == null)
		{
			m_fieldsThatNeedDeepCopy = getFieldsThatNeedDeepCopy(m_descriptor);
			if(m_fieldsThatNeedDeepCopy.length == 0)
			{
				m_fieldsThatNeedDeepCopy = empty_fieldsThatNeedDeepCopy;
				return;
			}
		}
		int i = 0;
		for(int len = m_fieldsThatNeedDeepCopy.length; i < len; i++)
		{
			int index = m_fieldsThatNeedDeepCopy[i];
			EdoAbstractValue value = (EdoAbstractValue)m_record[index];
			if(value != null)
				m_record[index] = value.deepCopy();
		}

	}

	int getFieldIndex(String fieldName)
	{
		int fieldIndex = m_descriptor.getFieldIndex(fieldName);
		if(0 > fieldIndex)
			throw new IllegalArgumentException("Field name '" + fieldName + "' not found in structure '" + m_descriptor.getName() + "'.");
		else
			return fieldIndex;
	}

	private void checkFieldIndex(int fieldIndex)
	{
		if(fieldIndex < 0 || fieldIndex >= m_record.length)
			throw new IndexOutOfBoundsException("Field index " + fieldIndex + " out of range. Should be >= 0 and < " + m_record.length);
		else
			return;
	}

	private void checkDescriptor(IStructureDescriptor descriptor)
	{
		if(!m_descriptor.equals(descriptor))
			throw new IllegalArgumentException("Different Structure type: expected '" + m_descriptor.getName() + "' found '" + descriptor.getName() + "'.");
		else
			return;
	}

	private void checkFieldType(int fieldIndex, String type)
	{
		boolean typeInvalid = false;
		IFieldDescriptor fieldDescriptor = m_descriptor.getFieldDescriptor(fieldIndex);
		if(type.equals("VARIANT") && !type.equals(fieldDescriptor.getType()))
			typeInvalid = true;
		else
		if(type.equals("STRING") && fieldDescriptor.getType().equals("VARIANT"))
			typeInvalid = true;
		if(typeInvalid)
			throw new IllegalArgumentException("Different Field type : expected '" + type + "' found '" + fieldDescriptor.getType() + "'.");
		else
			return;
	}

	private String getFieldType(int fieldIndex)
	{
		IFieldDescriptor fieldDescriptor = m_descriptor.getFieldDescriptor(fieldIndex);
		return fieldDescriptor.getType();
	}

	static final String META_FLAG = "S";
	protected final IStructureDescriptor m_descriptor;
	protected final Object m_record[];
	protected static final int empty_fieldsThatNeedDeepCopy[] = new int[0];
	protected int m_fieldsThatNeedDeepCopy[];

}
