package com.sap.caf.rt.ui.cool.generic;

import com.sap.tc.col.client.metadata.api.IFieldDescriptor;
import com.sap.tc.col.client.metadata.api.IStructureDescriptor;
import com.sap.tc.col.edo.*;
import java.util.HashMap;

public abstract class EdoAbstractValue
	implements IEdoValue
{

	public EdoAbstractValue()
	{
		m_valueIndex = RESET_INDEX;
		m_properties = null;
	}

	public int getIndex()
	{
		return m_valueIndex;
	}

	public void setIndex(int index)
	{
		m_valueIndex = index;
	}

	public void createSlot(String name)
	{
		if(m_properties != null)
			m_properties = new HashMap();
		if(m_properties.containsKey(name))
		{
			throw new EdoIllegalArgumentException(getClass().getName(), "createProperty", "name", name, "property exists");
		} else
		{
			m_properties.put(name, null);
			return;
		}
	}

	public Object getSlot(String name)
	{
		if(m_properties == null || !m_properties.containsKey(name))
			throw new EdoIllegalArgumentException(getClass().getName(), "getProperty", "name", name, "property does not exist");
		else
			return m_properties.get(name);
	}

	public Object setSlot(String name, Object value)
	{
		if(m_properties == null || !m_properties.containsKey(name))
			throw new EdoIllegalArgumentException(getClass().getName(), "setProperty", "name", name, "property does not exist");
		else
			return m_properties.put(name, value);
	}

	public void removeSlot(String name)
	{
		if(m_properties == null || !m_properties.containsKey(name))
		{
			throw new EdoIllegalArgumentException(getClass().getName(), "removeProperty", "name", name, "property does not exist");
		} else
		{
			m_properties.remove(name);
			return;
		}
	}

	public boolean existsSlot(String name)
	{
		return m_properties != null && m_properties.containsKey(name);
	}

	EdoAbstractValue deepCopy()
	{
		throw new NoSuchMethodError("Method deepCopy() is not supported.");
	}

	public abstract void readFrom(IEdoReadStream iedoreadstream);

	public abstract void writeTo(IEdoWriteStream iedowritestream);

	public abstract void clear();

	public abstract String getMeta();

	public abstract String getType();

	public static final int RESET_INDEX = -1;
	private int m_valueIndex;
	private HashMap m_properties;

	public static int[] getCorrespondingIndices(IStructureDescriptor one, IStructureDescriptor two)
	{
		int oneSize = one.size();
		int twoSize = two.size();
		int indices[] = new int[3 * (oneSize <= twoSize ? twoSize : oneSize)];
		int len = 0;
		for(int oneIndex = 0; oneIndex < oneSize; oneIndex++)
		{
			IFieldDescriptor oneFD = one.getFieldDescriptor(oneIndex);
			int twoIndex = two.getFieldIndex(oneFD.getName());
			if(twoIndex >= 0 && oneFD.getType().equals(two.getFieldDescriptor(twoIndex).getType()))
			{
				indices[len] = oneIndex;
				indices[len + 1] = twoIndex;
				indices[len + 2] = needsDeepCopy(oneFD) ? 1 : 0;
				len += 3;
			}
		}

		int retValue[] = new int[len];
		System.arraycopy(indices, 0, retValue, 0, len);
		return retValue;
	}

	public static int[] getFieldsThatNeedDeepCopy(IStructureDescriptor desc)
	{
		int indices[] = new int[desc.size()];
		int count = 0;
		int i = 0;
		for(int len = desc.size(); i < len; i++)
			if(needsDeepCopy(desc.getFieldDescriptor(i)))
				indices[count++] = i;

		int retValue[] = new int[count];
		System.arraycopy(indices, 0, retValue, 0, count);
		return retValue;
	}

	private static boolean needsDeepCopy(IFieldDescriptor fd)
	{
		return "VARIANT" == fd.getType();
	}
}
