package com.sap.caf.rt.ui.cool.generic;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;

import com.sap.tc.cmi.metadata.CMISetting;
import com.sap.tc.cmi.metadata.CMISettingDefinition;
import com.sap.tc.cmi.metadata.ICMIModelClassInfo;
import com.sap.tc.cmi.metadata.ICMIModelObjectCollectionInfo;
import com.sap.tc.col.client.metadata.api.IAspectDescriptor;

/**
 * Meta data for a GCP model object collectoin (an aspect).
 * @author Frakn Weigel
 */
class ColModelObjectCollectionInfo implements ICMIModelObjectCollectionInfo {

  private final ColModelInfo modelInfo;
  
  private final IAspectDescriptor descriptor;
  
  /**
   * Constructor for ColModelObjectCollectionInfo.
   */
  public ColModelObjectCollectionInfo(ColModelInfo modelInfo, IAspectDescriptor descriptor) {
    this.modelInfo = modelInfo;
    this.descriptor = descriptor;
  }

  /**
   * @see com.sap.tc.cmi.metadata.ICMIModelObjectCollectionInfo#getElementModelClassInfo()
   */
  public ICMIModelClassInfo getElementModelClassInfo() {
    return modelInfo.getOrCreateModelClassInfo(descriptor);
  }

  /**
   * @see com.sap.tc.cmi.metadata.ICMIAbstractInfo#getName()
   */
  public String getName() {
    return descriptor.getName();
  }

  /**
   * @see com.sap.tc.cmi.metadata.ICMIAbstractInfo#getSetting(CMISettingDefinition)
   */
  public CMISetting getSetting(CMISettingDefinition settingDef) {
    return null;
  }

  /**
   * @see com.sap.tc.cmi.metadata.ICMIAbstractInfo#setSetting(CMISettingDefinition, String)
   */
  public void setSetting(CMISettingDefinition settingDef, String value) {
    throw new UnsupportedOperationException();
  }

  /**
   * @see com.sap.tc.cmi.metadata.ICMIAbstractInfo#getSettings()
   */
  public Map getSettings() {
    return Collections.EMPTY_MAP;
  }

  /**
   * @see com.sap.tc.cmi.metadata.ICMIAbstractInfo#supports(String)
   */
  public boolean supports(String option) {
    return false;
  }

  /**
   * @see com.sap.tc.cmi.metadata.ICMIAbstractInfo#supportedOptions()
   */
  public Collection supportedOptions() {
    return Collections.EMPTY_SET;
  }

  /**
   * @see com.sap.tc.cmi.metadata.ICMIAbstractInfo#addSupportedOption(String)
   */
  public void addSupportedOption(String option) {
    throw new UnsupportedOperationException();
  }

}
