package com.sap.caf.rt.ui.cool.generic;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.HashMap;

import com.sap.caf.rt.bol.util.QueryFilter;
import com.sap.caf.rt.exception.ServiceException;
import com.sap.caf.rt.services.serviceaccess.ICAFServiceAccess;
import com.sap.caf.rt.services.serviceaccess.ICategoryFieldService;
import com.sap.caf.rt.srv.IDataContainerBean;
import com.sap.caf.rt.util.CAFPublicLogger;
import com.sap.tc.logging.Location;
import com.sap.typeservices.IModifiableSimpleValueSet;
import com.sap.typeservices.ISimpleValueSet;
import com.sap.typeservices.ModifiableSimpleValueSet;

/**
 * @author Alexey_Bloudov
 */

public class CategoryFieldService implements ICategoryFieldService {
	private final static String JARM_REQUEST = "";
	private static final String APPLICATION =
		CategoryFieldService.class.getName();
	private static final Location logger = Location.getLocation(APPLICATION);
	private static final String jARMRequest = JARM_REQUEST + APPLICATION;
	private CAFServiceManager sManager;

	public static final String SERVICE_NAME =
			"sap.com/caf.tc/CategoryService";
	private static final String VALUESET_SERVICE_NAME =
			"sap.com/caf.tc/CategoryValueService";
	private static final String VALUESET_NAME =
			"CategoryValue";		
		
	private static final String METHOD_FIND = "findById";
	private static final String PROP_CATEGORYVALUES = "values";
	private static final String PROP_CATEGORYVALUE_NAME = "name";

	private String m_categoryID;
	private Locale m_locale;
	private Map valuesCache = new HashMap();

	public CategoryFieldService(String categoryID, Locale locale) {
		//parameter locale is not used
		m_locale = locale;
		m_categoryID = categoryID;
	}

	protected CategoryFieldService(
	//		String categoryID,
	Locale locale, CAFServiceManager sManager) {

		this.sManager = sManager;
		//		m_categoryID = categoryID;
		m_locale = locale;
		if (m_locale == null) {
			m_locale = Locale.getDefault();
		}
	}

	/**
	 * @deprecated
	 */
	public ISimpleValueSet getValues(Locale locale) {
		//parameter locale is not used
		try {
			return getModifiableSimpleValueSet();
		} finally {
		}
	}

	public ISimpleValueSet getValues() {
		return getValues(m_locale);
	}

	public boolean validate(String value) {
		return getValues().containsKey(value);
	}

	public boolean validate(Object value) {
		return validate(value.toString());
	}

	public Locale getLocale() {
		//parameter locale is not used			
		return m_locale;
	}

	public synchronized IModifiableSimpleValueSet getModifiableSimpleValueSet() {
//		Make the initialization lazy
		IModifiableSimpleValueSet result = null;  
		if(m_categoryID!= null) { //searching in cache by categoryID
			result = (IModifiableSimpleValueSet) valuesCache.get(m_categoryID);
		}
		if (result == null) { 
			try {
				result = loadValues(m_locale);
				if(m_categoryID!= null) {
					valuesCache.put(m_categoryID, result);
				}
			} catch (ServiceException e) {
				logger.catching(e);
				return new ModifiableSimpleValueSet(m_locale);
			}
		}
		return result;
	}

	private ModifiableSimpleValueSet loadValues(Locale loc)
		throws ServiceException {
		final String method = jARMRequest + ":loadValues(Locale)";
		CAFPublicLogger.entering(
			null,
			jARMRequest,
			method,
			logger,
			CAFPublicLogger.LEVEL_MEDIUM);
		try {
			ModifiableSimpleValueSet set = new ModifiableSimpleValueSet(loc);
			set.setLocale(loc);
			Collection parameters = new ArrayList();
			parameters.add(QueryFilter.getQueryFilter(m_categoryID));
//			parameters.add(m_categoryID);
			//				parameters.add(localeNames);
			ICAFServiceAccess srvAccess = sManager.getServiceAccess();
			Collection categoryValues =
				srvAccess.findByDataObject(
					SERVICE_NAME,
					METHOD_FIND,
					parameters);
			Iterator valsIter = categoryValues.iterator();
			if (categoryValues != null && valsIter.hasNext()) {
				IDataContainerBean categoryData =
					(IDataContainerBean) valsIter.next();
				Collection values =
					(Collection) categoryData.getProperty(PROP_CATEGORYVALUES);
				if (values != null) {
					Collection readObjects = srvAccess.readDataObject(
					VALUESET_SERVICE_NAME,
					VALUESET_NAME,
					values);
					
					if(readObjects != null)
					for (Iterator iter = readObjects.iterator(); iter.hasNext();) {
						IDataContainerBean valueData = 
							(IDataContainerBean) iter.next();
						String valueString =
							(String) valueData.getProperty(
								PROP_CATEGORYVALUE_NAME);
						set.put(valueString, valueString);
					}
				}
			}
			//sort(boolean sortKey, boolean up, boolean ignoreCase)
			//and return result set
			set.sort(false, true, false);
			return set;
		} catch (Exception e) {
			throw new ServiceException(e);
		} finally {
			CAFPublicLogger.exiting(
				null,
				jARMRequest,
				method,
				logger,
				CAFPublicLogger.LEVEL_MEDIUM);
		}
	}

	public Set getEnumeration() {
		return getModifiableSimpleValueSet().entrySet();
	}

	public Map getEnumerationTexts() {
		return (ModifiableSimpleValueSet) getModifiableSimpleValueSet();
	}
	public void setLocale(Locale loc) {
		if (loc != null && !loc.equals(m_locale)) {
			m_locale = loc;
			try {
				if(m_categoryID!=null) {
					valuesCache.put(m_categoryID, loadValues(m_locale));
				}
			} catch (ServiceException e) {
				e.printStackTrace();
			}

		}
	}
	public void setCategoryId(String categoryId) {
		m_categoryID = categoryId;
	}
}
