/*
 * Created on Aug 6, 2003
 *
 * To change the template for this generated file go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
package com.sap.caf.rt.ui.cool.generic;

import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.rmi.PortableRemoteObject;

import com.sap.caf.rt.services.serviceaccess.CAFServiceAccessHome;
import com.sap.caf.rt.services.serviceaccess.CAFServiceAccessLocalHome;
import com.sap.caf.rt.services.serviceaccess.ICAFServiceAccess;
import com.sap.caf.rt.util.CAFPublicLogger;
import com.sap.tc.col.client.generic.api.IServiceFacade;
import com.sap.tc.col.client.metadata.api.IAspectDescriptor;
import com.sap.tc.col.client.metadata.api.IFieldDescriptor;
import com.sap.tc.col.client.metadata.api.IServiceModuleDescriptor;
import com.sap.tc.col.client.metadata.api.IStructureDescriptor;
import com.sap.tc.col.edo.IEdoTable;
import com.sap.tc.col.servicemanager.api.ICoolObjectKey;
import com.sap.tc.col.servicemanager.api.ISrvMgrCallbackOnFlush;
import com.sap.tc.col.servicemanager.api.ISrvMgrMessage;
import com.sap.tc.col.servicemanager.api.ISrvMgrServiceManager;
import com.sap.tc.col.servicemanager.api.ISrvMgrServiceModule;
import com.sap.tc.col.servicemanager.api.calls.ISrvMgrCall;
import com.sap.tc.col.servicemanager.core.calls.AbstractCall;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.Severity;
import com.sap.tc.webdynpro.clientserver.cal.ClientComponent;
import com.sap.tc.webdynpro.progmodel.api.IWDMessageManager;
import com.sap.tc.webdynpro.services.cal.core.IUpdateServerPeerData;
import com.sap.tc.webdynpro.services.session.IApplication;
import com.sap.tc.webdynpro.services.session.IComponent;
import com.sap.tc.webdynpro.services.session.IMaintainScope;
import com.sap.tc.webdynpro.services.session.IPhaseListener;
import com.sap.tc.webdynpro.services.session.IScope;
import com.sap.tc.webdynpro.services.session.IScopeListener;
import com.sap.tc.webdynpro.services.session.Utils;
import com.sap.tc.webdynpro.services.task.ITask;
import com.sap.tc.webdynpro.services.task.TaskBinder;

/**
 * @author i804014
 *
 * An implementation that hooks CAF to the GCP 
 */
public class CAFServiceManager implements ISrvMgrServiceManager {
	public static final String CAF_ACCESS_JNDI_REMOTE_KEY = "sap.com/caf.runtime/CAFServiceAccess";
	public static final String CAF_ACCESS_JNDI_LOCAL_KEY = "localejbs/sap.com/caf.runtime/CAFServiceAccess";
	ISrvMgrCallbackOnFlush mCallbackOnFlush;
	boolean mToSave;
	String mTransactionID;
	ArrayList mCallList;
	boolean synchronous = false;
	HashMap smList;
	CAFRepositoryManager smRepository;
	ICAFServiceAccess access;
	Map descriptors;
	Map proxies;
	Locale mLocale;
	
	protected List systemMessages = new ArrayList(5);
	
	/** Logging properites for this class */
	private static final String APPLICATION	= CAFServiceManager.class.getName();
	private static final String jARMRequest = AbstractModelClass.jARMReqPrefix+APPLICATION;
	private static final Location logger = Location.getLocation(APPLICATION);

	private static final ISrvMgrMessage[] EMPTY_MESSAGES_ARRAY = new ISrvMgrMessage[0]; 

	private String TASK_SCOPE_LISTENER_PARAMETER = "TASK_SCOPE_LISTENER";
	
	public CAFServiceManager() {
		this(Locale.getDefault());
	}

	
	public CAFServiceManager(Locale locale) {
		mCallList = new ArrayList();
		smList = new HashMap();	
		setLocale(locale);
		proxies = new HashMap();
		descriptors = new HashMap();
	}

	public CAFServiceManager(Hashtable connection_properties, Locale locale) {
		mCallList = new ArrayList();
		smList = new HashMap();	
		setLocale(locale);
		proxies = new HashMap();
		descriptors = new HashMap();
		init(connection_properties);
	}
	
	
	protected void init(Hashtable properties){
		String coolURL  = null;
		if(properties != null)
			coolURL = (String)properties.get(Context.PROVIDER_URL);
		if((coolURL == null)||"".equals(coolURL))
			lookupLocal(null);
		else{
			lookupRemote(properties);
		}			
		
		if(access!=null) {
			IScope scope = Utils.getScope(IScope.TASK_SCOPE);
			if (scope != null) {
				if((coolURL == null) || "".equals(coolURL)) {
					scope.put(CAF_ACCESS_JNDI_LOCAL_KEY, access);
				} else {
					scope.put(CAF_ACCESS_JNDI_REMOTE_KEY, access);
				}
				
				ITask task = TaskBinder.getCurrentTask();
				if (task != null) {
					IScope taskScope = task.getScope();
					if(taskScope.get(TASK_SCOPE_LISTENER_PARAMETER) == null) {
					TaskScopeListener tsl = new TaskScopeListener();
					task.registerToBeDestroyedListener(tsl);
						taskScope.put(TASK_SCOPE_LISTENER_PARAMETER, tsl);
					}
					// The listener that is registered here should be removed no later then task is destroyed.
					// Otherwise CoModificationException is to be thrown. See comments on scopeToBeDestroyed for more info.  
					IApplication taskApplication = task.getApplication();
					if(taskApplication!=null
						&& taskApplication.getScope().get(TASK_SCOPE_LISTENER_PARAMETER) == null) {
						TaskScopeListener tsl = new TaskScopeListener();  
						taskApplication.registerPhaseListener(tsl);
						taskApplication.getScope().put(TASK_SCOPE_LISTENER_PARAMETER, tsl);
					}
				}
			}
		}
	}
	
	/**
	 * Lokup remote interface of AccessService
	 * @param properties
	 */
	protected void lookupRemote(Hashtable properties){
		try{		
			InitialContext context = new InitialContext(properties);
			Object o = context.lookup(CAF_ACCESS_JNDI_REMOTE_KEY);
			CAFServiceAccessHome access_home = (CAFServiceAccessHome) PortableRemoteObject.narrow(o, CAFServiceAccessHome.class);
			java.util.Hashtable prop = new Hashtable();
			if(getLocale()!=null)
		    	prop.put("LOCALE", getLocale());
			access = access_home.create(prop);

		}catch(Exception e){
			CAFPublicLogger.traceThrowable(Severity.ERROR, e.toString(), e);
			throw new IllegalArgumentException(e.getMessage());
		}
	}
	
	/**
	 * Lookup local interface of local service
	 * @param properties
	 */
	protected void lookupLocal(Hashtable properties){
		try{		
			InitialContext context = new InitialContext(properties);
			Object o = context.lookup(CAF_ACCESS_JNDI_LOCAL_KEY);
			CAFServiceAccessLocalHome access_home = (CAFServiceAccessLocalHome) PortableRemoteObject.narrow(o, CAFServiceAccessLocalHome.class);
			java.util.Hashtable prop = new Hashtable();
			if(getLocale()!=null)
		    	prop.put("LOCALE", getLocale());
			access = access_home.create(prop);
		}catch(Exception e){
			CAFPublicLogger.traceThrowable(Severity.ERROR, e.toString(), e);
			throw new IllegalArgumentException(e.getMessage());
		}
		
	}
	
	public ICAFServiceAccess getServiceAccess(){
		if(access!=null) {
			ITask task = TaskBinder.getCurrentTask();
			if (task != null) {
				IScope taskScope = task.getScope();
				if(taskScope.get(TASK_SCOPE_LISTENER_PARAMETER) == null) {
				TaskScopeListener tsl = new TaskScopeListener();
				task.registerToBeDestroyedListener(tsl);
					taskScope.put(TASK_SCOPE_LISTENER_PARAMETER, tsl);
				}
				// The listener that is registered here should be removed no later then task is destroyed.
				// Otherwise CoModificationException is to be thrown. See comments on scopeToBeDestroyed for more info.  
				IApplication taskApplication = task.getApplication();
				if(taskApplication!=null
					&& taskApplication.getScope().get(TASK_SCOPE_LISTENER_PARAMETER) == null) {
					TaskScopeListener tsl = new TaskScopeListener();  
					taskApplication.registerPhaseListener(tsl);
					taskApplication.getScope().put(TASK_SCOPE_LISTENER_PARAMETER, tsl);
				}
			}
		}
						
		return access;
	}
	
	/**
	 * Return instance of AspectServiceAccess by service name.
	 * @param serviceName name of service
	 */
	public AspectServiceAccess getAspectServiceAccess(String serviceName){
		AspectServiceAccess accessSrv = (AspectServiceAccess)proxies.get(serviceName);
		if(accessSrv == null){
			accessSrv = new AspectServiceAccess(this, getServiceModuleDescriptor(serviceName));
			proxies.put(serviceName, accessSrv);
		}
		return accessSrv;
	}
	/**
	 * register an interested listener in the pre and post flush
	 * Only one listener is allowed, if a listener is registered already
	 * it is returned when the new one is registered
	 * @param callbackObject the listener. 
	 */
	public ISrvMgrCallbackOnFlush registerCallbackOnFlush(ISrvMgrCallbackOnFlush callbackObject)
	{
			ISrvMgrCallbackOnFlush oldCallback = mCallbackOnFlush;
			mCallbackOnFlush = callbackObject;
			return oldCallback;
	}
	
	 
	/* (non-Javadoc)
	 * @see com.sap.tc.col.servicemanager.api.ISrvMgrServiceManager#closeConnection()
	 */
	public void closeConnection() {
		invalidateModuleCache();
	}

	/** (non-Javadoc)
	 * @see com.sap.tc.col.servicemanager.api.ISrvMgrServiceManager#copyCorresponding(com.sap.tc.col.edo.IEdoTable, com.sap.tc.col.edo.IEdoTable)
	 * @deprecated
	 */
	public void copyCorresponding(IEdoTable arg0, IEdoTable arg1) {
		// TODO Auto-generated method stub
		//Looks like some buffering tables or something like that
	}

	/* (non-Javadoc)
	 * @see com.sap.tc.col.servicemanager.api.ISrvMgrServiceManager#flush()
	 */
	public void flush() {
		final String method = jARMRequest + ":flush()";
		CAFPublicLogger.entering(null, jARMRequest, method, logger,1 );
		try {
			if (mCallbackOnFlush != null)
			{
				if (!mCallbackOnFlush.beforeFlush("", ""))
				{
					throw new RuntimeException("Flush operation aborted by beforeFlush() callback");
				}
			}
			//TODO see if the messaging functionality is needed from sources
			ISrvMgrCall[] callArray = null;
			if (mCallbackOnFlush != null)
			{
				// create an array of all calls for the afterFlush() callback which will be invoked later
				// This has to be done now, because after the super.flush() the call list will be cleared
				int len = mCallList.size();
				callArray = new AbstractCall[len];
				for (int i = 0; i < len; i++)
				{
					callArray[i] = (ISrvMgrCall)mCallList.get(i);
				}
			}
			
			if (mCallbackOnFlush != null)
				mCallbackOnFlush.afterFlush(callArray);
		}
		finally {	 
			CAFPublicLogger.exiting(null, jARMRequest, method, logger, 1);
		}
	}

	/* (non-Javadoc)
	 * @see com.sap.tc.col.servicemanager.api.ISrvMgrServiceManager#getBackendVersion()
	 */
	public String getBackendVersion() {
		return "CAF1.0";
	}

	/* (non-Javadoc)
	 * @see com.sap.tc.col.servicemanager.api.ISrvMgrServiceManager#getFrontendVersion()
	 */
	public String getFrontendVersion() {
		return "CAF1.0";
	}

	/* (non-Javadoc)
	 * @see com.sap.tc.col.servicemanager.api.ISrvMgrServiceManager#getMessages()
	 */
	public ISrvMgrMessage[] getMessages() {
		return (ISrvMgrMessage[]) systemMessages.toArray(EMPTY_MESSAGES_ARRAY);
	}
	
	/* (non-Javadoc)
	 * @see com.sap.tc.col.servicemanager.api.ISrvMgrServiceManager#getRelativeAspectRowKey(com.sap.tc.col.client.metadata.api.IAspectDescriptor, com.sap.tc.col.edo.IEdoTable, int)
	 */
	public String getRelativeAspectRowKey(
		IAspectDescriptor aspect,
		IEdoTable table,
		int index) 
	{
		final String method = jARMRequest + ":getRelativeAspectRowKey(IAspectDescriptor, IEdoTable, int)";
		CAFPublicLogger.entering(null, jARMRequest, method, logger, 2);
		try {
			// Check arguments 
			if (index < 0 || index >= table.getRecordCount())
			{
				throw new ArrayIndexOutOfBoundsException("Index "+index+" out of bounds for given table (record count: "+table.getRecordCount()+")");
			}
			if (aspect.getStructure() != table.getDescriptor())
			{
				throw new IllegalArgumentException("Aspect structure ('"+aspect.getStructure().getName()+"') does not match table strucure ('"+table.getDescriptor().getName()+"')");
			}
	
			StringBuffer buf = new StringBuffer(100);
			buf.append("/").append(aspect.getKeyDescriptor().getName()).append("/1KEY");
	
			IStructureDescriptor keyStructure = aspect.getKeyDescriptor().getStructure();
			// The order of the fields in the key aspect structure is relevant
			for (int i=0; i<keyStructure.size(); i++)
			{
				IFieldDescriptor fieldDesc = keyStructure.getFieldDescriptor(i);
				
				buf.append("/");
				
				String value = table.getStringValue(index, fieldDesc.getName());
				if (value == null)
				{
					continue;
				}
	
				// Conform with the resolution from the design agenda meeting 2003-05-07:
				// "URL generation:
				if (fieldDesc.getType().equals(IFieldDescriptor.STRING))
				{
					// String, Char: Trailing Blanks are removed in string fields. 
					// An empty field is represented as a single (encoded) space character.
					value = table.getStringValue(index, fieldDesc.getName()).trim();
					if ("".equals(value))
					{
						value = " ";
					}
				}
				else if (fieldDesc.getType().equals(IFieldDescriptor.INTEGER))
				{
					// Int: no leading zeros, no trailing blanks, only digits, no separators, 
					// no plus sign, minus in front.
					value = String.valueOf(table.getIntValue(index, fieldDesc.getName()));
				}
				else if (fieldDesc.getType().equals(IFieldDescriptor.DATE))
				{
					// Date:  YYYY-MM-DD
					// @TODO: Currently, the string value returned by Edo conforms to this convention; check if we can use this here permanently
					value = table.getStringValue(index, fieldDesc.getName());
				}
				else if (fieldDesc.getType().equals(IFieldDescriptor.TIME))
				{
				  // Time: hh:mm:ss
					// @TODO: Currently, the string value returned by Edo conforms to this convention; check if we can use this here permanently
					value = table.getStringValue(index, fieldDesc.getName());
				}
				else if (fieldDesc.getType().equals(IFieldDescriptor.TIMESTAMP))
				{
					// Timestamp: probably something like "yyyy-mm-dd hh:mm:ss.mmmuuunnn" 
					// (blank and ':' is encoded) 
					// We choose the ISO format. 
					// (Somebody should try to find out how this really looks like)
					// Note: this is ISO 8601, and it defines (among other things)
					// various possible timestamp formats 
					// The Edo should already do this, so eventually, it should be safe 
					// to take the string value directly from there.
					value = table.getStringValue(index, fieldDesc.getName());
				}
				else 
				{
					// IFieldDescriptor.BOOLEAN and IFieldDescriptor.DECIMAL are not yet
					// supported
					// @TODO: Should we throw an exception here?
					value = table.getStringValue(index, fieldDesc.getName());
				}
				 		
				if (value != null)
				{
					buf.append(URLEncoder.encode(value));
				}
			}
			return buf.toString();
		}
		finally {
			CAFPublicLogger.exiting(null, jARMRequest, method, logger, 2);
		}
	}

	/* (non-Javadoc)
	 * @see com.sap.tc.col.servicemanager.api.ISrvMgrServiceManager#getServiceModule(java.lang.String, java.lang.String)
	 */
	public ISrvMgrServiceModule getServiceModule(String moduleName,
										 String moduleConfigurationName ) {
		return null;

	}

	/* (non-Javadoc)
	 * @see com.sap.tc.col.servicemanager.api.ISrvMgrServiceManager#getServiceModule(java.lang.String)
	 */
	public ISrvMgrServiceModule getServiceModule(String moduleName) {
		return getServiceModule(moduleName, "");
	}

	/* (non-Javadoc)
	 * @see com.sap.tc.col.servicemanager.api.ISrvMgrServiceManager#getServiceModuleConfigurationNames(java.lang.String)
	 */
	public String[] getServiceModuleConfigurationNames(String serviceModuleName) {
		return getRepositoryManager().getConfigurationNames(serviceModuleName);
	}
	/**
	 * @see com.sap.tc.col.servicemanager.api.ISrvMgrServiceManager#getServiceModuleDescriptor(java.lang.String)
	 */
	public IServiceModuleDescriptor getServiceModuleDescriptor(String serviceModuleName)
	{
		return getRepositoryManager().getServiceModuleDescriptor(serviceModuleName);
	}

	/**
	 * @see com.sap.tc.col.servicemanager.api.ISrvMgrServiceManager#getServiceModuleDescriptor(java.lang.String, java.lang.String)
	 */
	public IServiceModuleDescriptor getServiceModuleDescriptor(
		String serviceModuleName,
		String serviceModuleConfigurationName)
	{
		return getRepositoryManager().getServiceModuleDescriptor(serviceModuleName, serviceModuleConfigurationName);
	}

	

	protected CAFRepositoryManager getRepositoryManager() {	 
		if ( smRepository == null )
			smRepository = new CAFRepositoryManager(this);
		return smRepository;
	}
	
	/**
	 *  @see com.sap.tc.col.servicemanager.api.ISrvMgrServiceManager#getServiceModuleNames()
	 */
	public String[] getServiceModuleNames() {
		return getRepositoryManager().getServiceModuleNames();
	}

	/**
	 * @see com.sap.tc.col.servicemanager.api.ISrvMgrServiceManager#getTransactionID()
	 */
	public String getTransactionID() {
		//TODO how is it set?
		return mTransactionID;
	}

	/**
	 * @see com.sap.tc.col.servicemanager.api.ISrvMgrServiceManager#invalidateModuleCache()
	 */
	public void invalidateModuleCache() {
		getRepositoryManager().invalidate();
	}

	/**
	 * @see com.sap.tc.col.servicemanager.api.ISrvMgrServiceManager#isServiceModule(java.lang.String)
	 */
	public boolean isServiceModule(String serviceModuleName) {
		return getRepositoryManager().isServiceModule(serviceModuleName);
	}

	/**
	 * optimistic save state
	 * is set to true if an insert,delete, action or update is made
	 * @return true if save should be called
	 */
	public boolean isToSave() {
		return mToSave;
	}
	/** (non-Javadoc)
	 * @see com.sap.tc.col.servicemanager.api.ISrvMgrServiceManager#cleanup()
	 */
	public void cleanup() {
		final String method = jARMRequest + ":cleanup()";
		CAFPublicLogger.entering(null, jARMRequest, method, logger, 2);
		try {
			try {
				if(access!=null)
					access.rollback();
				Aspect.setDirtyStateForChangedAspects();
			} catch (Exception e) {
				SrvMgrMessage m = new SrvMgrMessage(1, "MSG1", e.getLocalizedMessage(), "", false, true);
				systemMessages.add(m);
			}
			flush();
		
			// get the transaction ID 
			this.setToSave(false);  // reset save state
		}
		finally{
			CAFPublicLogger.exiting(null, jARMRequest, method, logger, 2);
		}
	}
	/**
	 * Sets the save state.
	 * @param mToSave The mToSave to set
	 */
	protected void setToSave(boolean mToSave) {
		this.mToSave = mToSave;
	}

	/* Commit
	 */
	public boolean save() {
		try {
			if(access != null)
				access.commit();
			Aspect.clearAspectWaitingStates();
			return true;
		} catch (Throwable e) {
			SrvMgrMessage m = new SrvMgrMessage(2, "MSG1", e.getLocalizedMessage(), "", false, true);
			systemMessages.add(m);
			Aspect.setDirtyStateForChangedAspects();
		}
		return false;
	}

	/**
	 *  @see com.sap.tc.col.servicemanager.api.ISrvMgrServiceManager#setDebug(boolean, java.lang.String, java.lang.String)
	 */
	public void setDebug(boolean arg0, String arg1, String arg2) {
		throw new IllegalAccessError("setDebug not supported in CAF");
	}

	/**
	 * @see com.sap.tc.col.servicemanager.api.ISrvMgrServiceManager#setSynchronous(boolean)
	 */
	public void setSynchronous(boolean synchronous) {
	 	this.synchronous = synchronous;
	}

	/* (non-Javadoc)
	 * @see com.sap.tc.col.servicemanager.api.ISrvMgrServiceManager#flush(java.lang.String, java.lang.String)
	 */
	public void flush(String arg0, String arg1) {
	}

	/* (non-Javadoc)
	 * @see com.sap.tc.col.servicemanager.api.ISrvMgrServiceManager#getActiveFeatures()
	 */
	public String[] getActiveFeatures() {
		return null;
	}

	/* (non-Javadoc)
	 * @see com.sap.tc.col.servicemanager.api.ISrvMgrServiceManager#getActiveVersion()
	 */
	public String getActiveVersion() {
		return null;
	}

	/* (non-Javadoc)
	 * @see com.sap.tc.col.servicemanager.api.ISrvMgrServiceManager#getSupportedFeatures()
	 */
	public String[] getSupportedFeatures() {
		return null;
	}

	/* (non-Javadoc)
	 * @see com.sap.tc.col.servicemanager.api.ISrvMgrServiceManager#isFeatureActive(java.lang.String)
	 */
	public boolean isFeatureActive(String arg0) {
		return false;
	}

	/* (non-Javadoc)
	 * @see com.sap.tc.col.servicemanager.api.ISrvMgrServiceManager#isFeatureSupported(java.lang.String)
	 */
	public boolean isFeatureSupported(String arg0) {
		return false;
	}

	/* (non-Javadoc)
	 * @see com.sap.tc.col.servicemanager.api.ISrvMgrServiceManager#removeMessage(int)
	 */
	public ISrvMgrMessage removeMessage(int arg0) {
		return (ISrvMgrMessage) systemMessages.remove(arg0);
	}

	/* (non-Javadoc)
	 * @see com.sap.tc.col.servicemanager.api.ISrvMgrServiceManager#sizeMessages()
	 */
	public int sizeMessages() {
		return systemMessages.size();
	}

	/* (non-Javadoc)
	 * @see com.sap.tc.col.servicemanager.api.ISrvMgrServiceManager#useServiceModule(java.lang.String, java.lang.String)
	 */
	public void useServiceModule(String arg0, String arg1) {
	}

	/* (non-Javadoc)
	 * @see com.sap.tc.col.servicemanager.api.ISrvMgrMessageProvider#clearMessages()
	 */
	public void clearMessages() {
		systemMessages.clear();
	}

	/* (non-Javadoc)
	 * @see com.sap.tc.col.servicemanager.api.ISrvMgrMessageProvider#getAspectMessages(java.lang.String, boolean)
	 */
	public ISrvMgrMessage[] getAspectMessages(String arg0, boolean arg1) {
		return null;
	}

	/* (non-Javadoc)
	 * @see com.sap.tc.col.servicemanager.api.ISrvMgrMessageProvider#getAspectRowMessages(java.lang.String)
	 */
	public ISrvMgrMessage[] getAspectRowMessages(String arg0) {
		return null;
	}

	/* (non-Javadoc)
	 * @see com.sap.tc.col.servicemanager.api.ISrvMgrMessageProvider#getSystemMessages()
	 */
	public ISrvMgrMessage[] getSystemMessages() {
		return (ISrvMgrMessage[]) systemMessages.toArray(EMPTY_MESSAGES_ARRAY);
	}

	/* (non-Javadoc)
	 * @see com.sap.tc.col.servicemanager.api.ISrvMgrMessageProvider#removeMessage(com.sap.tc.col.servicemanager.api.ISrvMgrMessage)
	 */
	public void removeMessage(ISrvMgrMessage arg0) {
		systemMessages.remove(arg0);
	}

	/* (non-Javadoc)
	 * @see com.sap.tc.col.servicemanager.api.ISrvMgrMessageProvider#removeMessages(com.sap.tc.col.servicemanager.api.ISrvMgrMessage[])
	 */
	public void removeMessages(ISrvMgrMessage[] arg0) {
		for (int i = 0; i < arg0.length; i++) {
			systemMessages.remove(arg0[i]);
		}
	}

	/* (non-Javadoc)
	 * @see com.sap.tc.col.servicemanager.api.ISrvMgrServiceManager#check()
	 */
	public boolean check() {
		return false;
	}

	/* (non-Javadoc)
	 * @see com.sap.tc.col.servicemanager.api.ISrvMgrMessageProvider#getAndClearSystemMessages()
	 */
	public ISrvMgrMessage[] getAndClearSystemMessages() {
		ISrvMgrMessage[] ma = getSystemMessages();
		clearMessages();
		return ma;
	}
	
	private void setLocale(Locale locale) {
		mLocale = locale;
	}
	
	protected Locale getLocale() {
		return mLocale;
	}

	static class SrvMgrMessage implements ISrvMgrMessage {
		
		boolean isOutBound;
		int category;
		String aspectName;
		String aspectField;
		String aspectKey;
		String[] aspectKeyFields;
		String aspectKeySID;
		String aspectKeyServiceModule;
		String aspectKeyAspect;
		String code;
		String extention;
		boolean isFailed;
		int inrecordIndex;
		String text;
		int type;
		boolean isInfo;
		boolean isWarning;
		boolean isError;
		String vars;
		String[] varsAsArray;

		public SrvMgrMessage(int type, String code, String text, Object extention,
				boolean isOutOfBound, boolean isFailed) {
			this.type = type;
			this.code = code;
			this.text = text;
			this.extention = String.valueOf(extention);
			this.isOutBound = isOutOfBound;
			this.isFailed = isFailed;
		}

		/* (non-Javadoc)
		 * @see com.sap.tc.col.servicemanager.api.ISrvMgrMessage#isOutbound()
		 */
		public boolean isOutbound() {
			return isOutBound;
		}

		/* (non-Javadoc)
		 * @see com.sap.tc.col.servicemanager.api.ISrvMgrMessage#getCategory()
		 */
		public int getCategory() {
			return category;
		}

		/* (non-Javadoc)
		 * @see com.sap.tc.col.servicemanager.api.ISrvMgrMessage#getAspectName()
		 */
		public String getAspectName() {
			return aspectName;
		}

		/* (non-Javadoc)
		 * @see com.sap.tc.col.servicemanager.api.ISrvMgrMessage#getAspectField()
		 */
		public String getAspectField() {
			return aspectField;
		}

		/* (non-Javadoc)
		 * @see com.sap.tc.col.servicemanager.api.ISrvMgrMessage#getCoolObjectKey()
		 */
		public ICoolObjectKey getCoolObjectKey() {
			// TODO Auto-generated method stub
			return null;
		}

		/* (non-Javadoc)
		 * @see com.sap.tc.col.servicemanager.api.ISrvMgrMessage#getAspectKey()
		 */
		public String getAspectKey() {
			return aspectKey;
		}

		/* (non-Javadoc)
		 * @see com.sap.tc.col.servicemanager.api.ISrvMgrMessage#getAspectKeyFields()
		 */
		public String[] getAspectKeyFields() {
			return aspectKeyFields;
		}

		/* (non-Javadoc)
		 * @see com.sap.tc.col.servicemanager.api.ISrvMgrMessage#getAspectKeySID()
		 */
		public String getAspectKeySID() {
			return aspectKeySID;
		}

		/* (non-Javadoc)
		 * @see com.sap.tc.col.servicemanager.api.ISrvMgrMessage#getAspectKeyServiceModule()
		 */
		public String getAspectKeyServiceModule() {
			return aspectKeyServiceModule;
		}

		/* (non-Javadoc)
		 * @see com.sap.tc.col.servicemanager.api.ISrvMgrMessage#getAspectKeyAspect()
		 */
		public String getAspectKeyAspect() {
			return aspectKeyAspect;
		}

		/* (non-Javadoc)
		 * @see com.sap.tc.col.servicemanager.api.ISrvMgrMessage#getCode()
		 */
		public String getCode() {
			return code;
		}

		/* (non-Javadoc)
		 * @see com.sap.tc.col.servicemanager.api.ISrvMgrMessage#getExtension()
		 */
		public Object getExtension() {
			return extention;
		}

		/* (non-Javadoc)
		 * @see com.sap.tc.col.servicemanager.api.ISrvMgrMessage#isFailed()
		 */
		public boolean isFailed() {
			return isFailed;
		}

		/* (non-Javadoc)
		 * @see com.sap.tc.col.servicemanager.api.ISrvMgrMessage#getInrecordIndex()
		 */
		public int getInrecordIndex() {
			return inrecordIndex;
		}

		/* (non-Javadoc)
		 * @see com.sap.tc.col.servicemanager.api.ISrvMgrMessage#getText()
		 */
		public String getText() {
			return text;
		}

		/* (non-Javadoc)
		 * @see com.sap.tc.col.servicemanager.api.ISrvMgrMessage#getType()
		 */
		public int getType() {
			return type;
		}

		/* (non-Javadoc)
		 * @see com.sap.tc.col.servicemanager.api.ISrvMgrMessage#isInfo()
		 */
		public boolean isInfo() {
			return isInfo;
		}

		/* (non-Javadoc)
		 * @see com.sap.tc.col.servicemanager.api.ISrvMgrMessage#isWarning()
		 */
		public boolean isWarning() {
			return isWarning;
		}

		/* (non-Javadoc)
		 * @see com.sap.tc.col.servicemanager.api.ISrvMgrMessage#isError()
		 */
		public boolean isError() {
			return isError;
		}

		/* (non-Javadoc)
		 * @see com.sap.tc.col.servicemanager.api.ISrvMgrMessage#getVars()
		 */
		public String getVars() {
			return vars;
		}

		/* (non-Javadoc)
		 * @see com.sap.tc.col.servicemanager.api.ISrvMgrMessage#getVarsAsArray()
		 */
		public String[] getVarsAsArray() {
			return varsAsArray;
		}
	}
	
	/* ----- Transaction Support Methods go here ----- */
	public void rollback() throws Exception {
		access.rollback();
		Aspect.setDirtyStateForChangedAspects();
	}
	
	public void commit() throws Exception {
		try {
			access.commit();
			Aspect.clearAspectWaitingStates(); // Data was successfully saved to DB. So, clean wating for commit state from all alive aspects. 
		} catch (Exception ex) {
			Aspect.setDirtyStateForChangedAspects(); // Entire transaction was rolled back. So, it is needed to set state of aspects involved in the transaction back to DIRTY.  
			throw ex;
		}
	}
	
	protected class TaskScopeListener implements IScopeListener, IPhaseListener {
		
		public TaskScopeListener() {
		}
		
		public void scopeToBeDestroyed(IMaintainScope arg0) {
			try {
				ITask task = TaskBinder.getCurrentTask();
				if (task != null) {
					// Unregister phase listener to prevent CoModification exception
					task.getApplication().unregisterPhaseListener(this);
					task.getApplication().getScope().put(TASK_SCOPE_LISTENER_PARAMETER, null);
				}
				// Request processing is to be done. Let commit the transaction.
				// If the transaction is marked for rollback only it will not be commited but rolled back.
				commit();
			} catch (Exception e) {
				// TODO Find out a way of proper error reporting. Somehow ServiceFacade should be available here.
				logger.catching(e);
				Aspect.setDirtyStateForChangedAspects();
			}
		}

		public void afterHandleActionEvent(boolean arg0) {
			try {
				commit(); // Commit can throw an exception that must be registered and reported to the user.
			} catch (Exception e) {
				logger.catching(e);
				IServiceFacade sf = ServiceFacadeFactory.getFacadeInstance(null);
				if (sf != null) {
					MessageFactory.createAndRegisterMessageFromException(e, sf);
					IComponent c = TaskBinder.getCurrentTask().getCurrentTransportRoot();
					if (c instanceof ClientComponent) {
						/* TODO: Warning, the following code explicitly casts IComponent interface 
						 * to its implementation ClientComponent to get access to the IWDMessageManager object. 
						 * The IWDMessageManager instance then utilized for error reporting.
						 */    
						ClientComponent cc = ((ClientComponent) c);
						IWDMessageManager mm = cc.getComponent().getMessageManager();
						MessageFactory.reportOrRaiseCoolMessages(sf.getAllMessages(), mm, true, true, false);
					}
				}
			}
		}

		public void beforeTransportData(IUpdateServerPeerData arg0) {
			// we are not interested in the phase.
		}
	}
	/* ----- End of Transaction Support Methods ----- */
	
	
}
