/*
 * Created on 15.04.2004
 */
package com.sap.caf.rt.ui.cool.generic;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

import com.sap.caf.rt.services.serviceaccess.ICAFServiceAccess;
import com.sap.caf.rt.ui.cool.metadata.TypedFieldDescriptor;
import com.sap.caf.rt.util.CAFPublicLogger;
import com.sap.tc.cmi.metadata.ICMIModelInfo;
import com.sap.tc.col.client.metadata.api.IAspectActionDescriptor;
import com.sap.tc.col.client.metadata.api.IAspectDescriptor;
import com.sap.tc.col.client.metadata.api.IFieldDescriptor;
import com.sap.tc.col.client.metadata.api.IQueryDescriptor;
import com.sap.tc.col.client.metadata.api.IServiceModuleDescriptor;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.Severity;

/**
 *
 */
public class CAFRepositoryManager {

	private static final String APPLICATION	= CAFRepositoryManager.class.getName();
	public static final String CAF_CATEGORY = "CAF_CATEGORY";
	private static final Location logger = Location.getLocation(APPLICATION);

	private CAFServiceManager manager;
	private Map descriptors = new HashMap();
	private Map models = new HashMap();
	private Collection serviceNames = null;
	/**
	 * 
	 */
	public CAFRepositoryManager(CAFServiceManager manager) {
		this.manager = manager;
	}
	
	
	public String[] getServiceModuleNames() {
		String[] result = new String[0];
		if(serviceNames == null){			
			ICAFServiceAccess access = manager.getServiceAccess();
			if(access != null)
			try{
				serviceNames = access.getServiceNames();
			}catch(Exception e){
				//handle exception to create message
				CAFPublicLogger.traceThrowable(Severity.ERROR, e.getMessage(), e);	
			}
		}
		if(serviceNames != null)
			result = (String[])serviceNames.toArray(new String[0]);
		return result;		
	}
	
	
	public IServiceModuleDescriptor getServiceModuleDescriptor(String serviceName){
		IServiceModuleDescriptor descriptor = (IServiceModuleDescriptor)descriptors.get(serviceName);
		if(descriptor == null){
			descriptor = loadServiceModuleDescriptor(serviceName);
			if(descriptor == null) throw new IllegalArgumentException(serviceName);
			descriptors.put(serviceName, descriptor);			
			ColModelInfo model = new ColModelInfo(this, descriptor);
			models.put(serviceName, model);
		}
		return descriptor;
	}


	public ICMIModelInfo getCMIModel(String serviceName){
		ICMIModelInfo model = (ICMIModelInfo)models.get(serviceName);
		if(model == null){
			IServiceModuleDescriptor descriptor = (IServiceModuleDescriptor)descriptors.get(serviceName);
			if(descriptor == null){
				descriptor = loadServiceModuleDescriptor(serviceName);
				descriptors.put(serviceName, descriptor);
			}
			model = new ColModelInfo(this, descriptor);
			models.put(serviceName, model);
		}
		return model;	
	}
	
	public IServiceModuleDescriptor getServiceModuleDescriptor(String serviceName, String configName){
		return getServiceModuleDescriptor(serviceName);
	}
	
	public String[] getConfigurationNames(String configName){
		return new String[0];
	}
	
	/**
	 * Return <code>true</code> if given service exists.
	 * @param serviceName
	 * @return
	 */
	public boolean isServiceModule(String serviceName){
		if(serviceNames == null){			
			ICAFServiceAccess access = manager.getServiceAccess();
			if(access != null)
			try{
				serviceNames = access.getServiceNames();
			}catch(Exception e){
				//handle exception to create message
				CAFPublicLogger.traceThrowable(Severity.ERROR, e.getMessage(), e);
			}
		}
		if(serviceNames != null)
			return serviceNames.contains(serviceName);
		return false;
	}
	
	public void invalidate(){
		descriptors.clear();
	}
	
	private IServiceModuleDescriptor loadServiceModuleDescriptor(String serviceName){
		ICAFServiceAccess access = manager.getServiceAccess();
		IServiceModuleDescriptor result = null;
		if(access != null){
			try{
				result = access.getServiceModuleDescriptor(serviceName);
				addServicesToFieldDescriptors(result);
			}catch(Exception e){
				//handle exception to create message
				CAFPublicLogger.traceThrowable(Severity.ERROR, e.getMessage(), e);
				throw new IllegalArgumentException(e.getLocalizedMessage());	
			}
		}
		return result;
	}
	
	private void addServicesToFieldDescriptors(IServiceModuleDescriptor sMDescr) {
		if (sMDescr == null)
			return;
		processAspects(sMDescr);
		processQueries(sMDescr);
	}

	private void processAspects(IServiceModuleDescriptor sMDescr) {
		IAspectDescriptor[] aDescrs = sMDescr.getAspectDescriptors();
		for (int i = 0; i < aDescrs.length; i++) {
			IAspectDescriptor aDescr = aDescrs[i];
			if (aDescr == null || aDescr.getStructure() == null)
				continue;
			processAspectActions(aDescr);	
			IFieldDescriptor fieldDescrs[] =
				aDescr.getStructure().getFieldDescriptors();
			for (int j = 0; j < fieldDescrs.length; j++) {
				IFieldDescriptor fd = fieldDescrs[j];
				processFieldDescriptor(fd);
			}
		}
	}

	private void processQueries(IServiceModuleDescriptor sMDescr) {
		IQueryDescriptor[] qDescrs = sMDescr.getQueryDescriptors();
		for	(int i = 0;i< qDescrs.length;i++) {
			IQueryDescriptor qDescr = qDescrs[i];
			if(qDescr == null || qDescr.getInputParameters() == null) continue;
			IFieldDescriptor fieldDescrs[] =
				qDescr.getInputParameters().getFieldDescriptors();
			for (int j = 0; j < fieldDescrs.length; j++) {
				IFieldDescriptor fd = fieldDescrs[j];
				processFieldDescriptor(fd);
			}
		}
	}

    private void processAspectActions(IAspectDescriptor aDescr) {
    	IAspectActionDescriptor[] actionDescrs = aDescr.getAspectActionDescriptors();
		for	(int i = 0;i< actionDescrs.length;i++) {
			IAspectActionDescriptor actionDescr = actionDescrs[i];
			if(actionDescr == null || actionDescr.getInputParameters() == null) continue;
			IFieldDescriptor fieldDescrs[] =
			actionDescr.getInputParameters().getFieldDescriptors();
			for (int j = 0; j < fieldDescrs.length; j++) {
				IFieldDescriptor fd = fieldDescrs[j];
				processFieldDescriptor(fd);
			}
		}
    }
    
	private void processFieldDescriptor(IFieldDescriptor fd) {
//		if (fd instanceof TypedFieldDescriptor
//			&& ((TypedFieldDescriptor) fd).getServiceRequired()
//				== TypedFieldDescriptor
//					.SERVICE_REQUIRED_TYPED_FIELD_SRV) {
//			TypedFieldDescriptor tfd = (TypedFieldDescriptor) fd;
//			TypedFieldService tfs =
//				new TypedFieldService(
//					tfd.getCustomType(),
//					tfd.getDefaultLocale(),
//					manager);
//			tfd.setSimpleValueService(tfs);
//		}
//		else 
		if (fd instanceof TypedFieldDescriptor
			&& ((TypedFieldDescriptor) fd).getServiceRequired()
				== TypedFieldDescriptor
					.SERVICE_REQUIRED_CATEGORY_FIELD_SRV) {
			TypedFieldDescriptor tfd = (TypedFieldDescriptor) fd;
			CategoryFieldService cfs =
				new CategoryFieldService(
					tfd.getDefaultLocale(),
					manager);
		        String categoryID = tfd.getCategoryID();
			cfs.setCategoryId(categoryID);
			tfd.setSimpleValueService(cfs);		
	   }
    }


	
}
