/* Generated by Together */

package com.sap.caf.rt.ui.cool.generic;

import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

import javax.ejb.FinderException;
import javax.ejb.ObjectNotFoundException;

import com.sap.caf.rt.exception.CAFFindException;
import com.sap.caf.rt.exception.ServiceException;
import com.sap.caf.rt.srv.IDataContainerBean;
import com.sap.caf.rt.util.CAFPublicLogger;
import com.sap.tc.cmi.metadata.ICMIModelObjectCollectionInfo;
import com.sap.tc.cmi.model.ICMIModel;
import com.sap.tc.cmi.util.CMIAbstractObservableList;
import com.sap.tc.col.client.generic.api.IAction;
import com.sap.tc.col.client.generic.api.IAspect;
import com.sap.tc.col.client.generic.api.IAspectRow;
import com.sap.tc.col.client.generic.api.IKey;
import com.sap.tc.col.client.generic.api.IKeyList;
import com.sap.tc.col.client.generic.api.IMessageList;
import com.sap.tc.col.client.generic.api.IServiceModule;
import com.sap.tc.col.client.generic.api.IValueSet;
import com.sap.tc.col.client.generic.api.LockStrategy;
import com.sap.tc.col.client.generic.api.SortingCriteria;
import com.sap.tc.col.client.metadata.api.IAspectActionDescriptor;
import com.sap.tc.col.client.metadata.api.IAspectDescriptor;
import com.sap.tc.col.client.metadata.api.IFieldDescriptor;
import com.sap.tc.col.client.metadata.api.IKeyAspectDescriptor;
import com.sap.tc.col.client.metadata.api.IRelationDescriptor;
import com.sap.tc.col.client.metadata.api.IStructureDescriptor;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;

/**
 * realizes a class for an <code>Aspect</code>.<p>
 * 
 * Data of a <code>ServiceModule</code> is accessible at runtime in form of various <code>Aspect</code>s.
 * Each <code>Aspect</code> contains a list of <code>AspectRow</code>s, which all have the same structure.
 * Besides the access methods to <code>AspectRow</code>s, it has additional methods to create <code>Actions</code>s and to navigate
 * to related <code>Aspect</code>s.</p>
 * 
 * Changes on <code>Aspect</code>s (insert, update, delete) are locally buffered and managed, until a sendChanges() method is called.
 * Then these changes are sent in one step to service queue. An example could look like:</p>
 * <pre>
 *  ...
 *  IAspectRow newRow = aspect.createAspectRow();
 *  newRow.setAttributeValue("NAME", "XXXX");  
 *  ....
 *  IAspectRow existingRow = aspect.getAspectRow(0); 
 *  existingRow.setAttributeValue("PRICE", "1.25");
 *  ....
 *  // now save all changes
 *  aspect.sendChanges();
 *  ...
 * </pre>
 * 
 * There are three ways to get an <code>IAspect</code>:
 * <ul>
 * <li> create and execute an {@link IQuery} and navigate from the result to the wished aspect 
 * <li> create a new, empty aspect with {@link IServiceModule#createAspect(String)}
 * <li> create a new aspect with {@link IServiceModule#createAspect(String, KeyList)}, where the returned Aspect
 * is the result of a select call for all Keys of the input KeyList
 * </ul> 
 * In the second and third case the <code>Aspect</code> is root object of a cache, where the cache contains
 * all Aspects, which were reached with navigation from this root object.</p>
 * 
 * An <code>Aspect</code> implements the List interface, but some of the optional methods of List throw an 
 * <code>UnsupportedOperationException</code>, to avoid unnecessary and error producing functionality, f.i. it is
 * not allowed to add an <code>AspectRow</code> other than with the method <code>createAspectRow</code>.</p>
 * 
 * @author Helmut Mueller 
 */
public class Aspect
	extends CMIAbstractObservableList
	implements IAspect, ICacheRootObject {

	/** Logging properites for this class */
	private static final String APPLICATION	= Aspect.class.getName();
	private static final String jARMRequest = AbstractModelClass.jARMReqPrefix+APPLICATION;
	private static final Location logger = Location.getLocation(APPLICATION);
	
	// constants for state of Aspect and AspectRow
	/**
	 * constant value for state of an <code>Aspect</code> or <code>AspectRow</code> 
	 * means: the instance is ready for processing, no change is done, yet.
	 * instance is valid.
	 */
	protected final static int CLEAN = 0;

	/**
	 * constant value for state of an <code>Aspect</code> or <code>AspectRow</code> 
	 * means: the instance is hollow but refresh is initiated yet.When it is
	 * accessed next time, the message queue must be flushed to validate content of instance
	 */
	protected final static int HOLLOW = 1;
	/**
	 * constant value for state of an <code>Aspect</code> or <code>AspectRow</code> 
	 * means: the instance is changed but the changes are not send to message queue 
	 */
	protected final static int DIRTY = 2;
	/**
	 * constant value for state of an <code>Aspect</code> or <code>AspectRow</code> 
	 * means: the instance is changed but the changes are not send to message queue 
	 */
	protected final static int DIRTY_PENDING = 3;
	/**
	 * constant value for state of an  <code>AspectRow</code> 
	 * means: the instance is invalid, when it is accessed an Exception
	 * will be thrown. 
	 */
	protected final static int INVALID = 4;
	/**
	 * constant value for state of an  <code>AspectRow</code> 
	 * means: the instance is COPYING data from RPE
	 * it is only an intermediate state to avoid DIRTY handling when filling
	 * hollow Aspects
	 */
	protected final static int PROCESS_QUEUE_WAITING = 5;

	// constants for invalidation hints

	/**
	 * the bit position in BitSet for insert hint
	 */
	protected final static int INVALIDATE_ON_INSERT = 0;
	/**
	 * the bit position in BitSet for update hint
	 */
	protected final static int INVALIDATE_ON_UPDATE = 1;
	/**
	 * the bit position in BitSet for delete hint
	 */
	protected final static int INVALIDATE_ON_DELETE = 2;
	/**
	 * the bit position in BitSet for Action hint
	 */
	protected final static int INVALIDATE_ON_ACTION = 3;

	/**
	 * number of operations, hints exist
	 */
	protected final static int NUMBER_OF_HINTS = 4;

	/**
	 * constant BitSet with all Bits set to false, corresponds to
	 * the state, where no invalidation is done (default)
	 */
	protected final static BitSet NO_INVALIDATION = new BitSet(NUMBER_OF_HINTS);

	private final MessageList messages;

	static final boolean EXPLICIT_FLUSH = false;

	/**
	 * the call objects for Actions
	 */
	private ArrayList actionCalls;

	/**
	 * the data of the aspect, which is used to communicate with
	 * the service manager
	 */
	private IEdoTableEx aspectData;
	/**
		 * private LiveKeyList that can be used to iterate keys of this aspect
		 */
	private IKeyList liveKeyList = new LiveKeyList();

	/**
		 * flag which indicates that the Aspect is root object of a cache, means
		 * root of an Aspect tree
		 */
	private boolean cacheRootObject = false;

	private Boolean fieldWiseChange;
	
	protected IKeyList m_originalKeyList;

	/**
	 * when this <code>Aspect</code> is created as result/target of a relation, this object is the source
	 * aspect of the relation.
	 * This <code>sourceAspectOfCreatingRelation</code> is needed, when method createRelatedAspectRow() is used and the
	 * return of this call is merged locally.
	 */
	private Aspect sourceAspectOfCreatingRelation;
	
	private AspectRow sourceAspectRowOfCreatingRelation;

	/**
		 * invalidation hints for this <code>Aspect</code>.
		 */
	private BitSet invalidationHints; //  = new BitSet(NUMBER_OF_HINTS);

	private AspectCache aspectCache;

	/**
		* association to AspectChanges
		* @supplierCardinality 1
		* @clientCardinality 1
		* @link aggregationByValue
		*/
	private final AspectChanges aspectChanges;

	/**
		* the <code>ServiceModule</code> this <code>Aspect</code> belongs to.
		* @bidirectional <{com.sap.tc.col.client.generic.core.ServiceModule#aspects}>
		* @supplierCardinality 1
		* @clientCardinality 0..* 
		* @undirected
		*/
	private final ServiceModule serviceModule;

	/**
		 * the list of <code>AspectRow</code>s 
		 */
	private final ArrayList aspectRows = new ArrayList();
	/**
		  * the associated meta data of this <code>Aspect</code>
		  * @shapeType AssociatesLink
		  * @label
		  * @supplierCardinality 1
		  * @clientCardinality 0..*
		  * @directed
		  */
	private final IAspectDescriptor descriptor;

	/**
		* the state of an <code>Aspect</code>
		* after creation an aspect is in state "CLEAN", it is valid for
		* processing.
		*/
	private int state = Aspect.CLEAN;

	/**
		* The ICMIModelClassInfo for rows of this aspect. A reference is stored for performance reasons only. 
		* The info could be easily retrieved from the serviceModule whenever needed.
		*/
	private final ICMIModelObjectCollectionInfo modelObjectCollectionInfo;
	/**
	 * for performance reasons we need a <code>HashMap</code> to map the keys of an
	 *  <code>AspectRow</code> to the  <code>AspectRow</code> itself.
	 */
	private HashMap aspectRowsMap = new HashMap();

	/**
	 * Related aspects created by getRelatedAspect() must be stored for further access by sendChanges(). 
	 */
	protected List m_relatedAspects;
	
	/**
	 * To be able to implement ICMIObservableList interface fully we need a kind of mapping
	 * between internal storage of rows with they natural order and rows in order maintained by
	 * means of ICMIObservableList interface that is used to access aspect as WebDynpro model node.      
	 */
	protected List m_observableList;
	
	private static List m_aspects = Collections.synchronizedList(new WeakArrayList(15));

	/**
	 * The state when sendChanges were not generate any errors, but transaction is not yet finished
	 * is marked by setting of this flag. If transaction is commited and no errors were generated
	 * the flag is cleared. Otherwise, the aspect state is set to pure DIRTY.
	 */
	private boolean m_waitingCommit = false;

	/**
	 * The createEmptyInstance method creates an <code>Aspect</code> and builds the bidirectional association
	 * between <code>Aspect</code> and <code>ServiceModule</code>
	 * constructor checks consistency, both parameters must not be <code>null</code>
	 * The aspect is always created in state CLEAN.
	 * The factory method createInstance was introduced to obtain an ability to register all created aspects
	 * for further processing by transaction manager.
	 * @param serviceModule the <code>ServiceModule</code> this aspect belongs to
	 * @param descriptor the meta data of this <code>Aspect</code>
	 * @param aspectData the data of this <code>Aspect</code>
	 * @throws IllegalArgumentException in the case when any of the parameters is null.  
	 */
	public static synchronized IAspect createEmptyInstance(ServiceModule serviceModule, IAspectDescriptor descriptor) {
		cleanupList();
		IAspect a = new Aspect(serviceModule, descriptor);
		m_aspects.add(a);
		return a;
	}

	/**
	 * Creates a Keys <code>Aspect</code> and builds the bidirectional association
	 * between <code>Aspect</code> and <code>ServiceModule</code>.
	 * If keyList is <code>null</code> a HOLLOW Key Aspect is created.
	 * @throws IllegalArgumentException in the case when any of the parameters is null.  
	 */
	public static synchronized IAspect createPopulatedInstance(ServiceModule serviceModule, IKeyAspectDescriptor descriptor, IKeyList keyList) {
		cleanupList();
		IAspect a = new Aspect (serviceModule, descriptor, keyList);
		m_aspects.add(a);
		return a;
	}

	/**
	 * private constructor, creates an <code>Aspect</code> and builds the bidirectional association
	 * between <code>Aspect</code> and <code>ServiceModule</code>
	 * constructor checks consistency, both parameters must not be <code>null</code>
	 * Aspect is created in state CLEAN.
	 * @param serviceModule the <code>ServiceModule</code> this aspect belongs to
	 * @param descriptor the meta data of this <code>Aspect</code>
	 * @param aspectData the data of this <code>Aspect</code>
	 */
	private Aspect(
		ServiceModule serviceModule,
		IAspectDescriptor descriptor) {
		final String method = jARMRequest + ":Aspect(ServiceModule, IAspectDescriptor)";
		CAFPublicLogger.entering(null, jARMRequest, method, logger,2);
		try {
			m_observableList = new ArrayList(25);
			if (descriptor == null)
				// descriptor must not be null
				throw new IllegalArgumentException("AspectDescriptor must not be null");
			if (serviceModule == null)
				// ServiceModule must not be null
				throw new IllegalArgumentException("ServiceModule must not be null");
	
			this.descriptor = descriptor;
			this.serviceModule = serviceModule;
	
			this.aspectChanges = new AspectChanges(this);
			this.messages = new MessageList(serviceModule.getAllMessagesInternal());
	
			this.modelObjectCollectionInfo =
				(
					(ColModelInfo) serviceModule
						.associatedModelInfo())
						.getOrCreateModelObjectCollectionInfo(
					descriptor);
	
			//TODO figure out how to create aspect with data in it
			//this.state = srvMgrCall == null ? CLEAN : HOLLOW;
			if (state == CLEAN) {
				// we have to create an EDO Table for local changes
				// @todo method in SMP to get EDO table without creating Call object
				//aspectData = serviceModule.getSrvMgrServiceModule().createInsert(this.getName()).createInRecordsTable();
	
				aspectData = new EdoTable(descriptor.getStructure());
			}
			m_relatedAspects = new ArrayList(5);
		}
		finally {
			CAFPublicLogger.exiting(null, jARMRequest, method, logger,2);
		}
	}

	/**
	 * constructor, creates a Keys <code>Aspect</code> and builds the bidirectional association
	 * between <code>Aspect</code> and <code>ServiceModule</code>.
	 * If keyList is <code>null</code> a HOLLOW Key Aspect is created.
	 * constructor checks consistency, both parameters must not be <code>null</code>
	 */
	private Aspect(
		ServiceModule serviceModule,
		IKeyAspectDescriptor descriptor,
		IKeyList keyList) {
		// first create an empty aspect in state clean
		this(serviceModule, descriptor);
		final String method = jARMRequest + ":Aspect(ServiceModule, IKeyAspectDescriptor, IKeyList)";
		CAFPublicLogger.entering(null, jARMRequest, method, logger, 2);
		try {
			if (keyList == null) {
				setState(HOLLOW);
				aspectData = null;
			} else {
				// then create rows from the Keylist without registering changes
				setState(PROCESS_QUEUE_WAITING);
				int size = keyList.size();
				for (int i = 0; i < size; i++) {
					// to avoid dirty management
					IKey key = keyList.getKey(i);
					if (key.isLocalKey())
						continue;
					AspectRow keyRow = (AspectRow) this.createAspectRow(key);
				}
				setState(CLEAN);
			}
		}
		finally {
			CAFPublicLogger.exiting(null, jARMRequest, method, logger, 2);
		}
	}

	
	/**
	 * @see com.sap.tc.cmi.model.api.ICMIModelClass#associatedModel()
	 */
	public ICMIModel associatedModel() {
		return serviceModule;
	}

	/**
	 * @see com.sap.tc.cmi.model.ICMIModelObjectCollection#associatedModelObjectCollectionInfo()
	 */
	public ICMIModelObjectCollectionInfo associatedModelObjectCollectionInfo() {
		return modelObjectCollectionInfo;
	}

	/**
	 * Returns the name of this aspect. This is a convenience shortcut
	 * for getDescriptor.getName().
	 */
	public String getName() {
		return descriptor.getName();
	}

	/**
	 * returns the state of this <code>Aspect</code>
	 */
	protected int getState() {
		return state;
	}

	/**
	 * sets the state of this <code>Aspect</code>
	 */
	protected void setState(int state) {
		final String method = jARMRequest + ":setState(int)";
		CAFPublicLogger.entering(null, jARMRequest, method, logger,2);
		try {
			this.state = state;
			if (state == CLEAN) {
				IKeyList keyList = getKeyList();
				if (keyList instanceof KeyList) {
					m_originalKeyList = (IKeyList)((KeyList)keyList).clone();
				} else if (keyList instanceof Cloneable) {
					try {
						m_originalKeyList = (IKeyList)keyList.getClass().getMethod("clone", null).invoke(keyList, null);
					} catch (Exception e) {
						logger.catching("IKeyList given cannot be cloned.", e);
					}
				} else {
					logger.warning(Category.getCategory("InternalError"), "IKeyList given cannot be cloned.");
				}
			}
		}
		finally {
			CAFPublicLogger.exiting(null, jARMRequest, method, logger, 2);
		}
	}

	/**
	 * returns the aspect row of this <code>Aspect</code>, which corresponds to the given key,
	 * if there is one or <code>null</code> if no one exists.
	 * @param key the key of the aspect row
	 * @return IAspectRow the found aspect row or null if not exists
	 */
	public IAspectRow getAspectRow(IKey key) {
		return getAspectRow(key, LockStrategy.SHARED_READ_ONLY);
	}

	/**
	 * returns the aspect row of this <code>Aspect</code>, which corresponds to the given key,
	 * if there is one or <code>null</code> if no one exists.
	 * @param key the key of the aspect row
	 * @param lockMode indicates how the target aspect row should be locked
	 * @return IAspectRow the found aspect row or null if not exists
	 */
	public IAspectRow getAspectRow(IKey key, LockStrategy lockMode) {
		final String method = jARMRequest + ":getAspectRow(IKey, LockStrategy)";
		CAFPublicLogger.entering(null, jARMRequest, method, logger, 2);
		try {
			handleAccessAspect(true);
			//TODO is this original code right? Wouldn't the row not get refreshed if lock is null?
			AspectRow aspectRow = (AspectRow) aspectRowsMap.get(key);
			if (lockMode == LockStrategy.SHARED_READ_ONLY) {
				return aspectRow;
			}
			lockAndRefresh(aspectRow, lockMode);
			return aspectRow;
		} catch (Exception e) {
			MessageFactory.createAndRegisterMessageFromException(e, this, true);
			return null;
		} finally {
			CAFPublicLogger.exiting(null, jARMRequest, method, logger, 2);
		}
	}

	/**
	 * returns the <code>AspectRow</code> with given row index or an <code>ArrayIndexOutOfBoundsException</code>,
	 * if row is no valid index.
	 * @param row the row number
	 * @return IAspectRow the found <code>AspectRow</code> or <code>ArrayIndexOutOfBoundsException</code> if not exists
	 */
	public IAspectRow getAspectRow(int row) {
		return getAspectRow(row, LockStrategy.SHARED_READ_ONLY);
	}

	/**
	 * Returns the <code>AspectRow</code> with given row index or an <code>ArrayIndexOutOfBoundsException</code>,
	 * if row is no valid index.
	 * @param row the row number
	 * @param lockMode indicates how the target aspect row should be locked
	 * @return IAspectRow the found <code>AspectRow</code> or <code>null</code> if not exists
	 */
	public IAspectRow getAspectRow(int row, LockStrategy lockMode) {
		final String method = jARMRequest + ":getAspectRow(int, LockStrategy)";
		CAFPublicLogger.entering(null, jARMRequest, method, logger, 2);
		try {
			if (row < 0 || row > size()) {
				//throw new ArrayIndexOutOfBoundsException();
				// com.sap.tc.webdynpro.progmodel.context.Node$ElementList#sortElements(Comparator) waits for null if incorrect index is passed
				return null;
			}
			// the aspect can no longer be HOLLOW here (as a side effect of calling size()) 
			AspectRow aspectRow = (AspectRow) aspectRows.get(row);
			if (lockMode == LockStrategy.SHARED_READ_ONLY) {
				return aspectRow;
			}
			lockAndRefresh(aspectRow, lockMode);
			return aspectRow;
		} catch (Exception e) {
			MessageFactory.createAndRegisterMessageFromException(e, this, true);
			return null;
		} finally {
			CAFPublicLogger.exiting(null, jARMRequest, method, logger, 2);
		}
	}

	/**
	 * creates an empty <code>AspectRow</code> locally and adds it to the aspect row list.
	 * cause no key for the row is given, an empty key (local key) is created.
	 * @return IAspectRow the new created <code>AspectRow</code>
	 */
	public IAspectRow createAspectRow() {
		final String method = jARMRequest + ":createAspectRow()";
		CAFPublicLogger.entering(null, jARMRequest, method, logger, 1);
		try {
			handleAccessAspect(false);
			// create a new AspectRow with a local key and add it to the collection of rows
			Key key = new Key(getDescriptor().getKeyDescriptor());
			AspectRow aspectRow = createAspectRowInternal(aspectRows.size(), key);
			int index = addAspectRow(aspectRow);
	
			// notify listeners about insert
			// @todo restructure code to determine index more efficiently
			super.fireElementAdded(aspectRow, index);
	
			return aspectRow;
		} catch (Exception e) {
			MessageFactory.createAndRegisterMessageFromException(e, this, true);
			return null;
		} finally {
			CAFPublicLogger.exiting(null, jARMRequest, method, logger, 1);
		}
	}
	
	/**
	 * Create related aspect row
	 * @param row
	 * @return instance of IAspectRow.
	 */
	public IAspectRow createRelatedAspectRow(IAspectRow row){
		final String method = jARMRequest + ":createRelatedAspectRow(IAspectRow)";
		CAFPublicLogger.entering(null, jARMRequest, method, logger, 1);
		try {
			if (sourceAspectOfCreatingRelation == null) {
				throw new RuntimeException("Source aspect is not initialized. The Aspect must be retrived by getRelatedAspect() method.");
			}
			AspectRow insertedRow = null;
			int current_state = getState(); 
			try{
				setState(Aspect.DIRTY_PENDING);			
				insertedRow = (AspectRow)createAspectRow();
			}finally{
				setState(current_state);
			}
			
			current_state = getState();
			try {
				setState(Aspect.PROCESS_QUEUE_WAITING);
				insertedRow.setAttributeValue(((AspectRow)row).getAspectRowData());
			} finally {
				setState(current_state);
			}
			
			return insertedRow;
		} catch (Exception e) {
			MessageFactory.createAndRegisterMessageFromException(e, this, true);
			return null;
		} finally {
			CAFPublicLogger.exiting(null, jARMRequest, method, logger, 1);
		}
		
	}

	/**
	 * @see com.sap.tc.col.client.generic.api.IAspect#createRelatedAspectRow(String, IKey)
	 * @deprecated
	 */
	public IAspectRow createRelatedAspectRow(IKey key) {
		final String method = jARMRequest + ":createRelatedAspectRow(IKey)";
		CAFPublicLogger.entering(null, jARMRequest, method, logger, 1);
		try {
			if (sourceAspectOfCreatingRelation == null) {
				throw new RuntimeException("Source aspect is not initialized. The Aspect must be retrived by getRelatedAspect() method.");
			}
	//		if (!descriptor.getAttributeInsertRelationRequired())
	//			throw new UnsupportedOperationException(
	//				"insert with relation not allowed for Aspect '"
	//					+ getName()
	//					+ "'");
	//		String requiredRelation = descriptor.getAttributeInsertRelation();
	//		if (requiredRelation == null || requiredRelation.equals(""))
	//			throw new UnsupportedOperationException(
	//				"insert with relation not allowed for Aspect '"
	//					+ getName()
	//					+ "'");
			IAspectRow insertedRow = createAspectRow();
			aspectChanges.registerInsertRelation(insertedRow.getKey(), key);
			return insertedRow;
		} catch (Exception e) {
			MessageFactory.createAndRegisterMessageFromException(e, this, true);
			return null;
		} finally {
			CAFPublicLogger.exiting(null, jARMRequest, method, logger, 1);
		}
	}

	/**
	 * creates an empty <code>AspectRow</code> with a known Key locally and adds it to the aspect row list.
	 * for internal use only, doesn't notify about insert
	 * @return IAspectRow the new created <code>AspectRow</code>
	 */
	public IAspectRow createAspectRow(IKey key) {
		final String method = jARMRequest + ":createAspectRow(IKey)";
		CAFPublicLogger.entering(null, jARMRequest, method, logger, 2);
		try {
			// create a new AspectRow with a known Key
			AspectRow aspectRow =
				createAspectRowInternal(aspectRows.size(), (Key) key);
			addAspectRow(aspectRow);
			aspectRow.setKeyFields((Key) key);
	
			return aspectRow;
		} catch (Exception e) {
			MessageFactory.createAndRegisterMessageFromException(e, this, true);
			return null;
		} finally {
			CAFPublicLogger.exiting(null, jARMRequest, method, logger, 2);
		}
	}

	/**
	 * creates a complete <code>AspectRow</code> with a given index adds it to the aspect row list.
	 * This method is called internally, when the transition is done from HOLLOW Aspect to CLEAN
	 * Aspect. 
	 * @return IAspectRow the new created <code>AspectRow</code>
	 */
	protected IAspectRow createAspectRow(int index) {
		final String method = jARMRequest + ":createAspectRow(int)";
		CAFPublicLogger.entering(null, jARMRequest, method, logger, 2);
		try {
			// create a new AspectRow with a known Key
			Key key = new Key(getDescriptor().getKeyDescriptor());
			AspectRow aspectRow = createAspectRowInternal(index, key);
			aspectRows.add(aspectRow);
			m_observableList.add(aspectRow); 
			// There is no need to put new row in aspectRowsMap it is done just after the method call
			return aspectRow;
		} catch (Exception e) {
			MessageFactory.createAndRegisterMessageFromException(e, this, true);
			return null;
		} finally {
			CAFPublicLogger.exiting(null, jARMRequest, method, logger, 2);
		}
	}

	/**
	 * Internal factory method to create a new AspectRow instance
	 * Can be overridden by subclasses.
	 */
	protected AspectRow createAspectRowInternal(int index, Key key) {
		return new AspectRow(this, index, key);
	}

	/**
	 * removes an <code>AspectRow</code> from the aspect row list locally.
	 * Additionally the local delete is registered
	 * @return boolean returns true if the operation was successful, otherwise false 
	 */
	public boolean removeAspectRow(IAspectRow aspectRow) {
		return removeAspectRow(aspectRow, LockStrategy.SHARED_READ_ONLY);
	}

	/**
	 * removes an <code>AspectRow</code> from the aspect row list locally.
	 * Additionally the local delete is registered
	 * @param aspectRow the row to be deleted
	 * @param lockMode indicates how the target aspect row should be locked
	 * @return boolean returns true if the operation was successful, otherwise false 
	 */
	public boolean removeAspectRow(
		IAspectRow aspectRow,
		LockStrategy lockMode) {
		final String method = jARMRequest + ":removeAspectRow(IAspectRow, LockStrategy)";
		CAFPublicLogger.entering(null, jARMRequest, method, logger,1);
		try {
			boolean result = false;
			int index = indexOf(aspectRow);
			if (index >= 0) {
				result = removeAspectRowSilently(aspectRow, lockMode);
				super.fireElementRemoved(aspectRow, index);
			}
			return result;
		} catch (Exception e) {
			MessageFactory.createAndRegisterMessageFromException(e, this, true);
			return false;
		} finally {
			CAFPublicLogger.exiting(null, jARMRequest, method, logger,1);
		}
	}

	/**
	 * removes an <code>AspectRow</code> from the aspect row list locally.
	 * Additionally the local delete is registered. 
	 * Doesn't notify about the remove operation.
	 * @param aspectRow the row to be deleted
	 * @param lockMode indicates how the target aspect row should be locked
	 * @return boolean returns true if the operation was successful, otherwise false 
	 */
	protected boolean removeAspectRowSilently(
		IAspectRow aspectRow,
		LockStrategy lockMode) {
		final String method = jARMRequest + ":removeAspectRowSilently(IAspectRow, LockStrategy)";
		CAFPublicLogger.entering(null, jARMRequest, method, logger, 2);
		try {
			handleAccessAspect(false);
			if (contains(aspectRow)) {
				
				if (state == DIRTY_PENDING) {
					int [] row = new int[] {((AspectRow)aspectRow).getIndex()};
					if (aspectChanges != null)
						aspectChanges.resetUpdates( row );
				}
				
				aspectRowsMap.remove(aspectRow.getKey());
				aspectRows.remove(aspectRow);
				m_observableList.remove(aspectRow);
	
				int rowIndex = ((AspectRow) aspectRow).getIndex();
				aspectData.deleteFrom(rowIndex, 1);
	
				if (state == CLEAN || state == DIRTY) {
					if (aspectChanges != null)
						aspectChanges.registerDelete((AspectRow) aspectRow);
				
					AspectRow sourceRow = getSourceAspectRowOfCreatingRelation();
					if(sourceRow!=null) {
						sourceRow.handleDirtyState("key");
					}	
				}
				// update index for all AspectRows with index > rowIndex
				for (int i = rowIndex; i < size(); i++) {
					AspectRow row = (AspectRow) aspectRows.get(i);
					row.setIndex(i);
				}
				// set state of deleted AspectRow to invalid
				 ((AspectRow) aspectRow).invalidateInternal();
				return true;
			}
			return false;
		}
		finally {
			CAFPublicLogger.exiting(null, jARMRequest, method, logger, 2);
		}
	}

	/**
	 * creates an <code>Action</code> for the given action name.
	 * if actionName is no supported Action, an Exception is thrown
	 * @todo change RuntimeException
	 * @param actionName the name of the Action
	 * @return IAction the created Action
	 * @throws IllegalArgumentException if given actionName doesn't exist
	 */
	public IAction createAction(String actionName) {
		final String method = jARMRequest + ":createAction(String)";
		CAFPublicLogger.entering(null, jARMRequest, method, logger, 2);
		try { 
			handleAccessAspect(true);
			IAspectActionDescriptor aspectActionDescriptor =
				descriptor.getAspectActionDescriptor(actionName);
			if (aspectActionDescriptor == null)
				// ActionDescriptor must not be null
				throw new IllegalArgumentException(
					"AspectActionDescriptor for Action "
						+ actionName
						+ " doesn't exist");
	
			// create action via factory method
			return serviceModule.createActionInternal(aspectActionDescriptor, this);
		} catch (Exception e) {
			MessageFactory.createAndRegisterMessageFromException(e, this, true);
			return null;
		} finally {
			CAFPublicLogger.exiting(null, jARMRequest, method, logger, 2);
		}
	}

	/**
	 * Helper that searches the AspectDescriptor for a RelationDescriptor of the given 
	 * <code>relationName</code> and returns it. If no relation with the given name 
	 * exists, an IllegalArgumentException is thrown.
	 * Used by Aspect and AspectRow.
	 */
	IRelationDescriptor getRelationDescriptorOrFail(String relationName)
		throws IllegalArgumentException {
		final String method = jARMRequest + ":getRelationDescriptorOrFail(String)";
		CAFPublicLogger.entering(null, jARMRequest, method, logger, 2);
		try { 
			// check existence of this relation name for this Aspect    
			IRelationDescriptor relationDescriptor =
				descriptor.getRelationDescriptor(relationName);
			if (relationDescriptor == null) {
				if (!descriptor.isKeyAspect()) {
					// try to find relation in Key
					relationDescriptor =
						descriptor.getKeyDescriptor().getRelationDescriptor(
							relationName);
				}
				if (relationDescriptor == null)
					throw new IllegalArgumentException(
						"aspect '"
							+ getName()
							+ "' or its Key has no relation with name '"
							+ relationName
							+ "'");
			}
			return relationDescriptor;
		}
		finally {
			CAFPublicLogger.exiting(null, jARMRequest, method, logger, 2);
		}
	}

	/**
	 * @see com.sap.tc.col.client.generic.api.IAspect#getRelatedAspect(String)
	 */
	public IAspect getRelatedAspect(String relationName) {
		return getRelatedAspect(relationName, LockStrategy.SHARED_READ_ONLY);
	}


	protected IAspect getRelatedFromCache(String relationName, LockStrategy lockMode) throws ServiceException, InvocationTargetException, IllegalAccessException {
		final String method = jARMRequest + ":getRelatedFromCache(String, LockStrategy)";
		CAFPublicLogger.entering(null, jARMRequest, method, logger, 2);
		try { 
			// first look, whether relation is cached
			Aspect targetAspect =
				dependantAspectCache.getRelatedAspect(relationName);
			if (targetAspect != null) {
					if (lockMode != LockStrategy.SHARED_READ_ONLY) {
					// first check, whether target has a state, where LOCKING is allowed
					if (targetAspect.getState() != CLEAN
						&& targetAspect.getState() != HOLLOW) {
						throw new IllegalArgumentException(
							"Locking of aspect '"
								+ targetAspect.getName()
								+ "' not allowed, cause Aspect is not CLEAN or HOLLOW!");
					}
					// refresh the target Aspect
					// TODO remove creation of related aspect, this method return only cache instance
					//targetAspect = (Aspect) createAndPopulateRelatedAspect(relationName, lockMode);
				}
			} else {
				IRelationDescriptor relationDescriptor =
					getRelationDescriptorOrFail(relationName);
				// to differentiate, whether relation starts from Aspect or Key
				String sourceAspectName =
					relationDescriptor.getSourceAspectDescriptor().getName();
				if (!sourceAspectName.equals(getName()))
					// relation starts from Key
					return getAspect(sourceAspectName).getRelatedAspect(
						relationName,
						lockMode);
	
			}
			return targetAspect;
		}
		finally {
			CAFPublicLogger.exiting(null, jARMRequest, method, logger, 2);
		}
	}

	protected IAspect createAndPopulateRelatedAspect(String relationName, LockStrategy lockMode) throws ServiceException, InvocationTargetException, IllegalAccessException {
		final String method = jARMRequest + ":createAndPopulateRelatedAspect(String, LockStrategy)";
		CAFPublicLogger.entering(null, jARMRequest, method, logger, 2);
		try { 
			//Aspect not found in cache so load
			//TODO place in util class to share
			IAspect targetAspect;
			IRelationDescriptor relationDescriptor =
				getRelationDescriptorOrFail(relationName);
			IAspectDescriptor targetDesc =
				relationDescriptor.getTargetAspectDescriptor();
		
			ServiceFacade facade = serviceModule.getServiceFacade();
			IServiceModule targetServiceModule =
				facade.getServiceModule(
					targetDesc.getServiceModuleDescriptor().getName());
			targetAspect =
				(Aspect) targetServiceModule.createAspect(targetDesc.getName());
			
			serviceModule.getAspectServiceAccess().readRelatedAspects(descriptor.getName(), relationName, getKeyList(true));		
			//populateRelatedAspect(lockMode, targetAspect);
	
			// cache the relation
			//TODO is this call needed? Where do I get the index table from for last arg?
			//used to be selectByRelationCall.getRelations()
			dependantAspectCache.addRelatedAspect(
				this,
				relationName,
				(Aspect)targetAspect,
				null);
			addRelatedAspect(targetAspect);
			return targetAspect;	
		}
		finally {
			CAFPublicLogger.exiting(null, jARMRequest, method, logger, 2);
		}
	}

	protected void populateRelatedAspect(LockStrategy lockMode, IAspect targetAspect) throws ServiceException, InvocationTargetException, IllegalAccessException {
		final String method = jARMRequest + ":populateRelatedAspect(LockStrategy, IAspect)";
		CAFPublicLogger.entering(null, jARMRequest, method, logger, 1);
		try {
			String methodName =
				"find" + targetAspect.getDescriptor().getName() + "By" + getName() + "Pks";
			logger.debugT("Invocation of method -->" + methodName);

			//TODO invoke service method:DEPRICATED RELATION
			//((ServiceModule)targetAspect.getServiceModule()).getAspectServiceAccess().findBy(targetAspect.getDescriptor().getName(), methodName,  );
			Object rawResult = null;
			//rowResult = query.invoke(getKeyList(true), lockMode);
			((Aspect) targetAspect).setState(Aspect.PROCESS_QUEUE_WAITING);
			try {
				if (rawResult instanceof List) {
					for (Iterator it = ((List) rawResult).iterator(); it.hasNext(); 
							createRow(targetAspect, (IDataContainerBean) it.next()));
				} else {
					createRow(targetAspect, (IDataContainerBean) rawResult);
				}
			} finally {
				((Aspect) targetAspect).setState(Aspect.CLEAN);
			}
		} finally {
			CAFPublicLogger.exiting(null, jARMRequest, method, logger, 1);
		}
	}

	/**
	 * @see com.sap.tc.col.client.generic.api.IAspect#getRelatedAspect(String, LockMode)
	 */
	public IAspect getRelatedAspect(String relationName, LockStrategy lockMode) {
		final String method = jARMRequest + ":getRelatedAspect(String, LockStrategy)";
		CAFPublicLogger.entering(null, jARMRequest, method, logger, 1);
		try {
			// navigation on HOLLOW Aspects via performance booster
			if (state != HOLLOW)
				handleAccessAspect(true);

			IKeyAspectDescriptor targetKeyAspectDescriptor = this.getDescriptor().
				getRelationDescriptor(relationName).getTargetAspectDescriptor().
				getKeyDescriptor();
				
			IServiceModule targetServiceModule = serviceModule.getServiceFacade().
				getServiceModule(getDescriptor().getRelationDescriptor(relationName).
				getTargetAspectDescriptor().getServiceModuleDescriptor().getName());

			IKeyList keyList = targetServiceModule.createKeyList(targetKeyAspectDescriptor.getName());
			if(aspectRows!=null) {
				for(int i=0;i<aspectRows.size();++i) {
					AspectRow row = (AspectRow)aspectRows.get(i);
					
					Object refKey = row.getAspectRowData().getProperty(relationName);
					if(refKey!=null) {
						if(refKey instanceof Collection) {
							String[] keys = (String[])((Collection)refKey).toArray(new String[0]);
							for(int j=0;j<keys.length;++j) {
								Key key = new Key(targetKeyAspectDescriptor);
								key.setKeyFields(new String[] {(String)keys[j]});
								keyList.add(key);
							}
						} else {
							Key key = new Key(targetKeyAspectDescriptor);
							key.setKeyFields(new String[] {(String)refKey});
							keyList.add(key);
						}
					}
				}
			}
			
			Aspect targetAspect = new Aspect((ServiceModule) targetServiceModule,
				this.getDescriptor().
				getRelationDescriptor(relationName).getTargetAspectDescriptor());
			targetAspect.loadAspectRows(keyList, LockStrategy.SHARED_READ_ONLY);
							
			return targetAspect;
		} catch (Exception e) {
			MessageFactory.createAndRegisterMessageFromException(e, this, true);
			return null;
		} finally {
			CAFPublicLogger.exiting(null, jARMRequest, method, logger, 1);
		}
	}

	//TODO move to util class
	private void createRow(IAspect result, IDataContainerBean bean) {
			AspectRow row = (AspectRow)result.createAspectRow();
			row.supplyRowWithData(bean);
	}
	/**
	 * @see com.sap.tc.col.client.generic.api.IAspect#getRelatedAspect(String, String)
	 */
	public IAspect getRelatedAspect(
		String relationName,
		String targetAspectName) {
		return getRelatedAspect(
			relationName,
			targetAspectName,
			LockStrategy.SHARED_READ_ONLY);
	}

	/**
	 * @see com.sap.tc.col.client.generic.api.IAspect#getRelatedAspect(String, String, LockMode)
	 */
	public IAspect getRelatedAspect(
		String relationName,
		String targetAspectName,
		LockStrategy lockMode) {
			return getRelatedAspect(relationName, LockStrategy.SHARED_READ_ONLY);
	}

	/**
	 * Shortcut to retrieve KeyAspect. Follows the same caching conventions as getAspect(String).
	 */
	public IAspect getKeyAspect() {
		//TODO ARIEL added this, need to resolve usage of key aspects
		if (descriptor.getKeyDescriptor().getName().equals(getName()))
			return this;
		//TODO make this call work once key aspects resolved
		return getAspect(descriptor.getKeyDescriptor().getName());
	}

	/**
	 * Returns an <code>Aspect</code> with given name for all keys from this <code>Aspect</code> instance.
	 * @param aspectName the name of the <code>Aspect</code>
	 * @return IAspect an <code>Aspect</code> with given name for all keys from this <code>Keys</code> instance.
	 */
	public IAspect getAspect(String aspectName) {
		// get with no lock
		return getAspect(aspectName, LockStrategy.SHARED_READ_ONLY);
	}

	/**
	 * returns an <code>Aspect</code> with given name for all keys from this <code>Aspect</code> instance.
	 * @param aspectName the name of the <code>Aspect</code>
	 * @param lockMode indicates how the target aspect rows should be locked
	 * @return IAspect an <code>Aspect</code> with given name for all keys from this <code>Keys</code> instance.
	 */
	public IAspect getAspect(String aspectName, LockStrategy lockMode) {
		final String method = jARMRequest + ":getAspect(String, LockStrategy)";
		CAFPublicLogger.entering(null, jARMRequest, method, logger, 2);
		try {
			// navigation on HOLLOW Aspects via performance booster
			if (state != HOLLOW)
				handleAccessAspect(true);

			// first check whether aspectName is a valid name
			if (!isValidAspectName(aspectName)) {
				// throw an exception
				throw new IllegalArgumentException(
					"No select from aspect '"
						+ getName()
						+ "' to Aspect with name '"
						+ aspectName
						+ "'");
			}

			// first look in the cache
			Aspect resultAspect =
				dependantAspectCache.getSiblingAspect(aspectName);
			if (resultAspect != null) {
				if (lockMode != LockStrategy.SHARED_READ_ONLY) {
					// first check, whether target has a state, where LOCKING is allowed
					if (resultAspect.getState() != CLEAN
						&& resultAspect.getState() != HOLLOW) {
						throw new IllegalArgumentException(
							"Locking of aspect '"
								+ aspectName
								+ "' not allowed, cause Aspect is not CLEAN or HOLLOW!");
					}
					resultAspect.lockAndRefresh(lockMode);
				}
				return resultAspect;
			}

			// otherwise select aspect data by keys
			resultAspect =
				(Aspect) serviceModule.getAspect(
					this,
					aspectName,
					liveKeyList,
					lockMode);

			// and cache aspect locally
			dependantAspectCache.addSiblingAspect(aspectName, resultAspect);

			return resultAspect;
		} catch (Exception e) {
			MessageFactory.createAndRegisterMessageFromException(e, this, true);
			return null;
		} finally {
			CAFPublicLogger.exiting(null, jARMRequest, method, logger, 2);
		}
	}

	/**
	 * method locks an <code>AspectRow</code> and refreshes it at the same time
	 * @param lockMode the locking mode
	 */
	void lockAndRefresh(AspectRow row, LockStrategy lockMode) {
		//TODO lock and refresh
		IKeyList keyList =
			new KeyList(getKeyAspect().getDescriptor().getKeyDescriptor());
		keyList.add(row.getKey());
		row.setState(CLEAN);
	}

	/**
	 * method locks an aspect rows from the <code>IKeyList</code> 
	 * and refreshes they at the same time
	 * @param keyList keys of aspect rows to lock and refresh
	 * @param lockMode the locking mode
	 */
	void lockAndRefresh(IKeyList keyList, LockStrategy lockMode) {
		//TODO verify this is correct

		if (state == HOLLOW) {
			//simply lock the rows
			lock(keyList, lockMode);
		} else if (state == CLEAN) {
			//reload the rows based on the key list
			loadAspectRows(keyList, lockMode);
		}
	}

	/**
	 * method locks an <code>Aspect</code> and refreshes it at the same time
	 * @param lockMode the locking mode
	 */
	void lockAndRefresh(LockStrategy lockMode) {
		lockAndRefresh(getKeyList(true), lockMode);
	}

	/**
	 * Loads the AspectRows for this aspect based on the list of keys in this Aspect
	 * @param LockMode the lock mode
	 */
	private void loadAspectRows(IKeyList keyList, LockStrategy lockMode) {
		final String method = jARMRequest + ":loadAspectRows(IKeyList, LockStrategy)";
		CAFPublicLogger.entering(null, jARMRequest, method, logger, 2);
		try {
			try {
				//create the findByPks query for this service module
				//execute the query with the primary keys
				try { 
					setState(Aspect.PROCESS_QUEUE_WAITING);
					Object rawResult = serviceModule.getAspectServiceAccess().readAspectObjects (descriptor.getName(), keyList);
					
					//get the primary key descriptor to be able to get the pk from the results
					//and thus match to existing AspectRow objects and fill them 
					IKeyAspectDescriptor keyDesc = getDescriptor().getKeyDescriptor();
					IStructureDescriptor keyStruct = keyDesc.getStructure();
					String keyFieldValues[] = new String[keyStruct.size()];
	
					//loop through the query results
					Iterator it = ((List) rawResult).iterator();
					while (it.hasNext()) {
						IDataContainerBean bean = (IDataContainerBean) it.next();
						//for each bean, get the primary key fields
						for (int i = 0; i < keyFieldValues.length; i++) {
							String nextName = keyStruct.getFieldDescriptor(i).getName();
							//				fill the values in the key
							keyFieldValues[i] =
								bean.getProperty(nextName) == null
									? ""
									: bean.getProperty(nextName).toString();
						}
	
						Key key = new Key(keyDesc, keyFieldValues);
						//now key is complete with values find the row
						IAspectRow row = this.getAspectRow(key);
						if (row == null) {
							row = createAspectRow(key);
						}
						//now that row has been found, populate the rest of the fields
						((AspectRow) row).supplyRowWithData(bean);
					}
				} catch (Exception e) {
					MessageFactory.createAndRegisterMessageFromException(e, this, true);

/**					
				} catch (InvocationTargetException ex) {
					MessageFactory.createAndRegisterMessageFromException(ex, this);
				} catch (IllegalAccessException iae) {
					MessageFactory.createAndRegisterMessageFromException(iae, this, true);
**/					
				} finally {
					setState(Aspect.CLEAN);
				}
			} catch (Exception ex) {
				MessageFactory.createAndRegisterMessageFromException(ex, this, true);
			}
		} finally {
			CAFPublicLogger.exiting(null, jARMRequest, method, logger, 2);
		}
	}

	private void lock(IKeyList keyList, LockStrategy lockMode) {
		String serviceName = getServiceModule().getDescriptor().getName();
		//CAFMethod lock = null;
		try {
			//lock = CAFServiceAccess.getMethod(serviceName, "lockByPks");
			//lock.invoke(keyList);
			//TODO invoke service method. There is a problem with this functionality
		} catch (Throwable ex) {
			MessageFactory.createAndRegisterMessageFromException(ex, this, true);
		}
	}
	
	private void lock(LockStrategy lockMode) {
		lock(getKeyList(true), lockMode);
	}

	/**
	 * adds an <code>AspectRow</code> to this <code>Aspect</code>, additionally the insert is registered and the
	 * bidirectional association with <code>AspectRow</code> is built
	 * @param aspectRow the inserted row
	 */
	protected int addAspectRow(AspectRow aspectRow) {
		final String method = jARMRequest + ":addAspectRow(AspectRow)";
		CAFPublicLogger.entering(null, jARMRequest, method, logger, 2);
		int index = -1;
		try {
			if (aspectRow != null) {
				// handleStateAccess(false);
				if ((index = aspectRows.indexOf(aspectRow)) >= 0) {
					return index;
				}
				aspectData.append(1);
				index = aspectRows.size(); 
				aspectRows.add(aspectRow);
				m_observableList.add(aspectRow);
				aspectRowsMap.put(aspectRow.getKey(), aspectRow);
				// register insert
				if (state == CLEAN || state == DIRTY) {
					if (aspectChanges != null)
						aspectChanges.registerInsert(aspectRow.getKey());
						
					AspectRow sourceRow = getSourceAspectRowOfCreatingRelation();
					if(sourceRow!=null) {
						sourceRow.handleDirtyState("key");
					}
				}
			}
		} finally {
			CAFPublicLogger.exiting(null, jARMRequest, method, logger, 2);
		}
		return index;
	}

	/**
	 * returns the meta data of this <code>Aspect</code>.
	 * @return IAspectDescriptor the meta data of this <code>Aspect</code>
	 */
	public IAspectDescriptor getDescriptor() {
		return descriptor;
	}

	/**
	 * returns the <code>ServiceModule</code> this <code>Aspect</code> belongs to.
	 * @return IServiceModule <code>ServiceModule</code> this <code>Aspect</code> belongs to.
	 */
	public IServiceModule getServiceModule() {
		return serviceModule;
	}

	/**
	 * registers the given <code>AspectRow</code> as updated
	 * @param aspectRow the <code>AspectRow</code>,which should be marked as updated
	 */
	protected void registerUpdate(IKey key, String fieldName) {
		if (state == CLEAN || state == DIRTY) {
			if (aspectChanges != null) {
				aspectChanges.registerUpdate(key, fieldName);
				if (getState() != DIRTY)
					setState(DIRTY);
			}
		}
	}

	private void updateRows(int[] updateIndices) throws Exception {
		final String method = jARMRequest + ":updateRows(int[])";
		CAFPublicLogger.entering(null, jARMRequest, method, logger, 2);
		String serviceName = getServiceModule().getDescriptor().getName();
		try {
			for (int i = 0; i < updateIndices.length; i++) {
				IAspectRow row = this.getAspectRow(updateIndices[i]);
				((AspectRow)row).calculateReferences();
				IDataContainerBean dataBean = null;
				serviceModule.getAspectServiceAccess().updateAspect(row);				
			}
			// Exception while row update won't clear changes state.
			aspectChanges.resetAllUpdates();
		} finally {
			CAFPublicLogger.exiting(null, jARMRequest, method, logger, 2);
		}
	}

	private void deleteRows(KeyList keyList) throws Exception {
		final String method = jARMRequest + ":deleteRows(KeyList)";
		CAFPublicLogger.entering(null, jARMRequest, method, logger, 2);
		try {
			String serviceName = getServiceModule().getDescriptor().getName();
			try {
				deleteRelations(keyList);
				serviceModule.getAspectServiceAccess().deleteAspectRows(getName(), keyList);
			} finally {
				// Exception while rows deletion will clear changes state.
				aspectChanges.resetDeleteButKeyList(null);
			}
		}
		finally {
			CAFPublicLogger.exiting(null, jARMRequest, method, logger, 2);
		}
	}

	private boolean isFinderException(ServiceException se) {
		Throwable cause = se;
		while ((cause = cause.getCause()) != null 
				&& !(cause instanceof ObjectNotFoundException 
						|| cause instanceof FinderException 
						|| cause instanceof CAFFindException)) {}
		return cause != null;
	}
	
	protected void deleteRelations(IKeyList keyList) throws ServiceException {
	}

	private void insertRows(int[] updateIndices) throws Exception {
		final String method = jARMRequest + ":insertRows(int[])";
		CAFPublicLogger.entering(null, jARMRequest, method, logger, 1);
		try {
			String serviceName = getServiceModule().getDescriptor().getName();
			//TODO mode the functionality of collection handling to AspectServiceAccess
			for (int i = 0; i < updateIndices.length; i++) {
				AspectRow row = (AspectRow)this.getAspectRow(updateIndices[i]);
				IKey rowKey = row.getKey();
				row.calculateReferences();
				try{				
					serviceModule.getAspectServiceAccess().insertAspectRow(row);
					aspectChanges.resetInsert(rowKey);
				}finally{
					// resetInsert clears state of inserted related rows collection  
					//aspectChanges.resetInsert(rowKey);					
				}

/*				try {
					if (sourceAspectOfCreatingRelation != null) {
						Key relatedSourceKey = (Key) aspectChanges.getRelatedInsertedKey(rowKey);
						if (relatedSourceKey != null) {
							String relateActionName = "relate" + getName();
							IAction relateAction = sourceAspectOfCreatingRelation.createAction(relateActionName);
							IStructure sourceActionStruct = relateAction.getInputParameterStructure();
							sourceActionStruct.setAttributeValue(0, getKeyAsString(row.getKey()));
	
							// Call the action only for relatedSourceKey 
							IServiceModule sourceSM = sourceAspectOfCreatingRelation.getServiceModule();
							String sourceKeyName = sourceAspectOfCreatingRelation.getKeyAspect().getDescriptor().getName();
							IKeyList sourceKeyList = sourceSM.createKeyList(sourceKeyName);
							sourceKeyList.add(relatedSourceKey);
							//TODO invoke inser method:RELATION
							//CAFMethod relate = CAFServiceAccess.getMethod(sourceSM.getDescriptor().getName(), relateActionName);
							//relate.invoke(sourceActionStruct, sourceKeyList, LockStrategy.SHARED_READ_ONLY);
						}
					}
				} finally {
					// resetInsert clears state of inserted related rows collection  
					aspectChanges.resetInsert(rowKey);
				}
*/
			}
		} finally {
			CAFPublicLogger.exiting(null, jARMRequest, method, logger, 1);
		}
	}

	/**
	 * sends all pending changes of this <code>Aspect</code> to backend
	 * all changes are registered in the associated AspectChange instance
	 * @todo send updates of deleted AspectRows 
	 */
	public void sendChanges() {

		logger.entering("sendChanges",
			new Object[] { "Aspect Name = " + this.getName()});

		int[] insertedRowIndices;
		int[] updatedRowIndices;
		KeyList deletedKeyList;

		try {
			String isComplex = this.getDescriptor().
				getAttributeStringValue("complex_attribute");
			String isCollectionAspect = this.getDescriptor().
				getAttributeStringValue("collection_support");
			if("true".equals(isComplex) 
				|| "true".equals(isCollectionAspect)) {
				return;
			}
			
			// call 'sendChanges' in all related aspects
			for (Iterator i = m_relatedAspects.iterator(); i.hasNext(); ) {
				IAspect relatedAspect = (IAspect) i.next();

				String isCollection = relatedAspect.getDescriptor().
					getAttributeStringValue("collection_support");
				if(!"true".equals(isCollection)) {
					relatedAspect.sendChanges();
					messages.transferMessagesFrom(
						(MessageList) relatedAspect.getMessages());
				}
				
				if(getState() != DIRTY &&
					"true".equals(relatedAspect.getDescriptor().
						getAttributeStringValue("complex_attribute")) &&
					relatedAspect instanceof Aspect &&
					((Aspect)relatedAspect).getState() == DIRTY) {
					setState(DIRTY);
				}
				
				if(getState() != DIRTY &&
					"true".equals(isCollection) &&
					relatedAspect instanceof Aspect &&
					((Aspect)relatedAspect).getState() == DIRTY) {
					setState(DIRTY);
				}
			}
			
			if (getState() != DIRTY) {
				logger.infoT("sendChanges", "exit, cause Aspect is not dirty");
			} else {
				m_waitingCommit = true;
				// update rows  
				updatedRowIndices = aspectChanges.getChangedAspectRows();
				if (updatedRowIndices.length > 0) {
					// create update call
					if (!isFieldWiseChange()) {
						updateRows(updatedRowIndices);
					} else {
						throw new UnsupportedOperationException("Field wise update not supported");
					}
					logger.infoT(
						"sendChanges",
						"Update: updated AspectRows : " + updatedRowIndices.length);
				}

				// second delete rows
				deletedKeyList = aspectChanges.getDeletedKeys();
				if (deletedKeyList != null && !deletedKeyList.isEmpty()) {
					deleteRows(deletedKeyList);
				}

				// at last insert rows
				insertedRowIndices = aspectChanges.getInsertedAspectRows();
				if (insertedRowIndices.length > 0) {
					insertRows(insertedRowIndices);
					logger.infoT(
						"sendChanges",
						"inserted AspectRows : " + insertedRowIndices.length);
				}
				setState(CLEAN);
			}
			
		} catch (InvocationTargetException ite) {
			MessageFactory.createAndRegisterMessageFromException(ite, this);
		} catch (ServiceException se) {
			//if (!isFinderException(se)) {
			MessageFactory.createAndRegisterMessageFromException(se, this, true);
			//}
		} catch (Throwable ex) {
			MessageFactory.createAndRegisterMessageFromException(ex, this, true);
		} finally {
			logger.exiting();
		}
	}
	
	/**
	 * executes state transition of this <code>Aspect</code> when the instance is accessed ( read or write )
	 * @param readOnly indicates, whether a read only access is done or not.
	 */
	protected void handleAccessAspect(boolean readOnly) {
		final String method = jARMRequest + ":handleAccessAspect(boolean)";
		CAFPublicLogger.entering(null, jARMRequest, method, logger,2);
		try {
			//state == DIRTY_PENDING ||
			if ( state == HOLLOW) {
				if (EXPLICIT_FLUSH) {
					logger.fatalT(
						" Aspect'"
							+ getName()
							+ "' is in an invalid state: You first have to call flush()");
					throw new IllegalStateException(
						" Aspect'"
							+ getName()
							+ "' is in an invalid state: You first have to call flush()");
				} else {
					serviceModule.flush();
				}
			}
			if (state == INVALID) {
				logger.fatalT(
					" Aspect '"
						+ getName()
						+ "' is invalid: Fatal Access Error!!!");
				throw new IllegalStateException(
					" Aspect '"
						+ getName()
						+ "' is invalid: Fatal Access Error!!!");
			} else if (state == CLEAN && !readOnly) {
				setState(DIRTY);
			}
		}
		finally {
			CAFPublicLogger.exiting(null, jARMRequest, method, logger, 2);
		}
	}

	/**
	 * event fired before service queue is flushed.
	 * If this aspect is dirty, then automatically send changes
	 */
	public void onServiceQueueWillBeFlushed() {
		if (getState() == Aspect.DIRTY)
			sendChanges();
	}

	/**
	 * returns the aspectData.
	 * @return ISrvMgrTable
	 */
	public IEdoTableEx getAspectData() {
		return aspectData;
	}

	/**
	 * returns a string representation of this <code>Aspect</code> for test purposes only
	 * for test purposes only
	 */
	public String toString() {
		try {
			String nl = System.getProperty("line.separator");
			StringBuffer buf = new StringBuffer();
			buf.append("  <Aspect name=\"" + getName() + "\" >").append(nl);
			for (int i = 0; i < size(); i++) {
				buf.append("  <Row " + i + ">").append(nl);
				buf.append(get(i).toString());
				buf.append("  </Row>").append(nl);
			}
			buf.append("  </Aspect>").append(nl);
	
			return buf.toString();
		} catch (Exception e) {
			return "Error while converting Aspect to String. Super.toString() is: " + super.toString();
		}
	}

	// ---- List implementation ----------------------------------------------------

	/**
	 * Inserts the specified element at the specified position in this list (optional operation).
	 * Shifts the element currently at that position (if any) and any subsequent elements to the right (adds one to their indices).
	 * This method is not supported at the moment, cause we only allow adding a new AspectRow by 
	 * creating a new one.
	 * @throws UnsupportedOperationException
	 */
	public void addSilently(int index, Object element) {
		if (!(element instanceof IAspectRow)) {
			throw new IllegalArgumentException("The addSilently method must be supplied with parameter of type IAspectRow. " +
				"Actual supplied parameter class is: " + element.getClass().getName()); 
		} else if (((IAspectRow) element).getAspect() != this) {
			throw new UnsupportedOperationException("Aspect Row is invalid for the Aspect: " + this);
		}
		m_observableList.add(index, element);
	}

	/**
	 * WARNING! The method may return wrong value since setSilently() is not implemented yet.
	 * returns the aspect row as Object with given row index or an <code>ArrayIndexOutOfBoundsException</code>,
	 * if row is no valid index.<p>
	 * the method calls the typed method of this <code>Aspect</code>, <code>getAspectRow</code>. 
	 * @param row the row number
	 * @return Object the found <code>AspectRow</code> or <code>ArrayIndexOutOfBoundsException</code> if not exists
	 */
	public Object get(int index) {
		int readlIndex = aspectRows.indexOf(m_observableList.get(index));
		return getAspectRow(readlIndex);
	}

	/**
	 * WARNING! The method may remove wrong aspect row since setSilently() is not implemented yet.
	 * Removes the element at the specified position in this <code>Aspect</code> 
	 * Shifts any subsequent elements to the left (subtracts one from their indices). Returns the element that was removed from the list.
	 * @param index the index of the element to removed.
	 * @return Object the <code>AspectRow</code> previously at the specified position
	 * @throws IndexOutOfBoundsException if the index is out of range <pre>(index < 0 oder index > size())</pre>.
	 */
	public Object removeSilently(int index) {
		try {
			int readlIndex = aspectRows.indexOf(m_observableList.get(index));
			IAspectRow row = getAspectRow(readlIndex);
			removeAspectRowSilently(row, LockStrategy.SHARED_READ_ONLY);
			return row;
		} catch (Exception e) {
			MessageFactory.createAndRegisterMessageFromException(e, this, true);
			return null;
		}
	}

	/**
	 * Replaces the element at the specified position in this list with the specified element (optional operation).
	 * @throws UnsupportedOperationException
	 */
	public Object setSilently(int index, Object element) {
		if (aspectRows.indexOf(element) < 0) {
			throw new UnsupportedOperationException("Aspect doesn't support changing rows via its List interface");
		} else {
			m_observableList.set(index, element);
		}
		return element;
	}

	/**
	 * returns how many aspect rows this <code>Aspect</code> contains
	 * @return int the number of aspect rows
	 */
	public int size() {
		try {
			handleAccessAspect(true);
			return aspectRows.size();
		} catch (Exception e) {
			MessageFactory.createAndRegisterMessageFromException(e, this, true);
			return 0;
		} 
	}

	/**
	 * Aspect specific implementation of equals. Must be overridden as HOLLOW handling requires not
	 * to access aspect data to check equality.
	 * A more sophisticated implementation could check equalitiy based on state.
	 */
	public boolean equals(Object o) {
		return this == o;
	}

	/**
	 * Aspect specific implementation of hashCode. Must fit implementation of equals(Object).
	 */
	public int hashCode() {
		return System.identityHashCode(this);
	}

	// ---- end of list implementation -------------------------------------------

	/**
	 * invalidate this <code>Aspect</code>, where this <code>Aspect</code> is root
	 * object of an <code>AspectCache</code>.<p>
	 * @throws UnsupportedOperationException if this <code>Aspect</code> is not root of an <code>AspectCache</code>
	 */
	public void invalidate() {
		final String method = jARMRequest + ":invalidate()";
		CAFPublicLogger.entering(null, jARMRequest, method, logger, 2);
		try {
			if (!isCacheRootObject())
				throw new UnsupportedOperationException("Aspect is not root of an AspectCache!");
			// first clear cached Relations and realted Aspects
			this.invalidateInternal();
			// then remove cached Aspects
			aspectCache.clear();
			
			sourceAspectRowOfCreatingRelation = null;
		} catch (Exception e) {
			MessageFactory.createAndRegisterMessageFromException(e, this, true);
		} finally {
			CAFPublicLogger.exiting(null, jARMRequest, method, logger, 2);
		}
	}

	/**
	 * invalidation of cached data
	 */
	protected void invalidateInternal() {
		if (getState() == INVALID) {
			// ignore
			return;
		}
		serviceModule.unregisterAspect(this);
		setState(INVALID);
		dependantAspectCache.invalidate();

		// now the same for all AspectRows of this Aspect
		Iterator rowsIterator = aspectRows.iterator();
		while (rowsIterator.hasNext()) {
			AspectRow row = (AspectRow) rowsIterator.next();
			row.invalidateInternal();
		}
	}

	/**
	 * bind AspectCache to RootObject
	 */
	protected void bindAspectCache(AspectCache aspectCache) {
		this.aspectCache = aspectCache;
	}

	/**
	 * Returns <code>true</code>, if this <code>Aspect</code> is root of
	 * a cache
	 * @return boolean <code>true</code>, if this <code>Aspect</code> is root of
	 * a cache, otherwise <code>false</code>
	 */
	public boolean isCacheRootObject() {
		return cacheRootObject;
	}

	/**
	 * Sets the cacheRootObject flag
	 * @param cacheRootObject The cacheRootObject to set
	 */
	protected void setCacheRootObject(boolean cacheRootObject) {
		this.cacheRootObject = cacheRootObject;
	}

	private final DependantAspectCache dependantAspectCache =
		new DependantAspectCache();

	/**
	 * returns the Relation with given name or <code>null</code>, if Relation
	 * is not buffered.
	 */
	protected Relation getRelation(String relationName) {
		return dependantAspectCache.getRelation(relationName);
	}

	/**
	 * @see com.sap.tc.col.client.generic.core.ICacheRootObject#getAspectCache()
	 */
	public AspectCache getAspectCache() {
		return aspectCache;
	}

	/**
	 * add selected Aspects
	 */
	protected Aspect getSelectedAspect(String aspectName) {
		return dependantAspectCache.getSiblingAspect(aspectName);
	}

	/**
	 * returns a <code>KeyList</code> with all <code>Key</coce>s of this
	 * <code>Aspect</code>.
	 * @return IKeyList a <code>KeyList</code> with all <code>Key</coce>s of this
	 * <code>Aspect</code>.
	 */
	public IKeyList getKeyList() {
		return getKeyList(false);
	}
	
	/**
	 * returns a <code>KeyList</code> with all <code>Key</coce>s of this
	 * <code>Aspect</code>.
	 * @return IKeyList a <code>KeyList</code> with all <code>Key</coce>s of this
	 * <code>Aspect</code>.
	 */
	public IKeyList getKeyList(boolean excludeLocal) {
		final String method = jARMRequest + ":getKeyList(boolean)";
		CAFPublicLogger.entering(null, jARMRequest, method, logger, 2);
		try {
			handleAccessAspect(true);
			KeyList keyList =
				(KeyList) serviceModule.createKeyList(
					descriptor.getKeyDescriptor().getName());
			// fill this KeyList with Keys from AspectRows
			Iterator it = aspectRows.iterator();
			// @todo why use internal iterator here?
			while (it.hasNext()) {
				AspectRow aspectRow = (AspectRow) it.next();
				IKey k = aspectRow.getKey();
				if (excludeLocal && k.isLocalKey()) {
					continue;
				} else {
					keyList.add(k);
				}
			}
			return keyList;
		} catch (Exception e) {
			MessageFactory.createAndRegisterMessageFromException(e, this, true);
			return null;
		} finally {
			CAFPublicLogger.exiting(null, jARMRequest, method, logger, 2 );
		}
	}

	/**
	 * lazy initialization of the invalidation hints, the default information is taken from meta data of this <code>Aspect</code>, when
	 * this method is called first time
	 */
	private BitSet getInvalidationHints() {
		final String method = jARMRequest + ":getInvalidationHints()";
		CAFPublicLogger.entering(null, jARMRequest, method, logger, 2);
		try {
			if (invalidationHints == null) {
				invalidationHints = new BitSet(NUMBER_OF_HINTS);
				if (affectsMoreThanOutRecords(IAspectActionDescriptor
					.ACTION_UPDATE_FIELDS)
					|| affectsMoreThanOutRecords(
						IAspectActionDescriptor.ACTION_UPDATE_ROW)) {
					invalidationHints.set(INVALIDATE_ON_UPDATE);
				}
				if (affectsMoreThanOutRecords(IAspectActionDescriptor
					.ACTION_INSERT)) {
					invalidationHints.set(INVALIDATE_ON_INSERT);
				}
				if (affectsMoreThanOutRecords(IAspectActionDescriptor
					.ACTION_DELETE)) {
					invalidationHints.set(INVALIDATE_ON_DELETE);
				}
				// if at least one Action affects more than outRecords default is set to true for Actions
				IAspectActionDescriptor[] actionDescriptors =
					descriptor.getAspectActionDescriptors();
				for (int i = 0; i < actionDescriptors.length; i++) {
					if (affectsMoreThanOutRecords(actionDescriptors[i]
						.getName())) {
						invalidationHints.set(INVALIDATE_ON_ACTION);
						break;
					}
				}
	
				// default for other Actions stays false, cause there could be more than one Action per Aspect
			}
			return invalidationHints;
		}
		finally {
			CAFPublicLogger.exiting(null, jARMRequest, method, logger, 2);
		}
	}

	/**
	 * helper method which checks meta data information for invalidation hints of Aspect Actions
	 * if the meta data information returns the information "AFFECTS_ASPECT" or "AFFECTS_ALL" <code>true</code>
	 * is returned, otherwise <code>false</code>.
	 * if meta data method throws <code>UnsupportedOperationException</code>, <code>false</code> is returned.
	 */
	private boolean affectsMoreThanOutRecords(String actionName) {
		final String method = jARMRequest + ":affectsMoreThanOutRecords(String)";
		CAFPublicLogger.entering(null, jARMRequest, method, logger, 2);
		try {
			if (descriptor.getActionAttributeAffects(actionName)
				== IAspectActionDescriptor.AFFECTS_ALL
				|| descriptor.getActionAttributeAffects(actionName)
					== IAspectActionDescriptor.AFFECTS_ASPECT)
				return true;
			else
				return false;
		} catch (UnsupportedOperationException e) {
			return false;
		}
		finally {
			CAFPublicLogger.exiting(null, jARMRequest, method, logger, 2 );
		}
	}

	/**
	 * sets invalidation hints for this <code>Aspect</code>. <p>
	 * 
	.  * Since invalidating the cache on every change - however trivial it may be - would lead to bad performance.
	 * So with this method the <cool> client can tell the GCP, if the triggered operations on Aspect have no side-effects or if it is 
	 * interested to see the effects of potential side-effects immediately. 
	 * If such a hint flag is set, GCP will invalidate the cached data implicitly (always the complete cache, this Aspect belongs to), 
	 * if the corresponding operation is executed.<p>
	 * Default: information read from meta data.<p>
	 * Example:
	 * <pre>
	 *  setInvalidationHints(true,  false, false, false) 
	 * </pre>
	 * means, that an insert on this <code>Aspect</code> will lead to an cache invalidation.<p>
	 * @param invalidateOnInsert if <code>true</code>, this leads to an cache invalidation on insert otherwise <code>false</code> 
	 * @param invalidateOnUpdate if <code>true</code>, this leads to an cache invalidation on update otherwise <code>false</code> 
	 * @param invalidateOnDelete if <code>true</code>, this leads to an cache invalidation on delete otherwise <code>false</code> 
	 * @param invalidateOnAction if <code>true</code>, this leads to an cache invalidation when Action is executed otherwise <code>false</code> 
	 */
	public void setInvalidationHints(
		boolean invalidateOnInsert,
		boolean invalidateOnUpdate,
		boolean invalidateOnDelete,
		boolean invalidateOnAction) {
		BitSet invalidationHints = getInvalidationHints();
		if (invalidateOnInsert) {
			invalidationHints.set(INVALIDATE_ON_INSERT);
		} else {
			invalidationHints.clear(INVALIDATE_ON_INSERT);
		}
		if (invalidateOnUpdate) {
			invalidationHints.set(INVALIDATE_ON_UPDATE);
		} else {
			invalidationHints.clear(INVALIDATE_ON_UPDATE);
		}
		if (invalidateOnDelete) {
			invalidationHints.set(INVALIDATE_ON_DELETE);
		} else {
			invalidationHints.clear(INVALIDATE_ON_DELETE);
		}
		if (invalidateOnAction) {
			invalidationHints.set(INVALIDATE_ON_ACTION);
		} else {
			invalidationHints.clear(INVALIDATE_ON_ACTION);
		}
	}

	/**
	 * checks, whether this <code>Aspect</code> should be invalidated and returns <code>true</code> if invalidation of the
	 * cache this <code>Aspect</code> belongs to should take place, otherwise <code>false</code>.<p>
	 * 
	 * The decision depends first on the pending changes (insert, update, delete, Action) and the on the
	 * invalidation hints settings
	 * @todo consider Action
	 * @return boolean <code>true</code> if invalidation of the
	 * cache this <code>Aspect</code> belongs to should take place, otherwise <code>false</code>
	 */
	protected boolean isInvalidationNeeded() {
		final String method = jARMRequest + ":isInvalidationNeeded()";
		CAFPublicLogger.entering(null, jARMRequest, method, logger, 2);
		try {
			BitSet changes = aspectChanges.getChangesState();
			changes.and(getInvalidationHints());
			if (changes.equals(NO_INVALIDATION)) {
				// no bit set corresponding
				logger.infoT("isInvalidationNeeded", "no invalidation needed!");
				return false;
			}
			return true;
		} finally {
			CAFPublicLogger.exiting(null, jARMRequest, method, logger, 2);
		}
	}

	/**
	 * helper method, which checks, whether an aspect name is valid for an select service
	 */
	private boolean isValidAspectName(String aspectName) {
		// get the KeyDescriptor of this Aspect
		if (aspectName == null || aspectName.equals(getName()))
			return false;

		IKeyAspectDescriptor keyDescriptor = descriptor.getKeyDescriptor();

		// the aspect to select corresponds to the name of this Aspects KeyDescriptor
		// so a lokal Keys Aspect can be created locally
		if (keyDescriptor.getName().equals(aspectName))
			return true;
		IAspectDescriptor target =
			keyDescriptor.getAspectDescriptor(aspectName);
		if (target == null) {
			return false;
		} else {
			return true;
		}
	}


	/**
	 * Immutable KeyList that always represents the keys of this 
	 * Aspect (therefore "live"). Intended for internal use only.
	 */
	private class LiveKeyList extends AbstractList implements IKeyList {

		/**
		 * Returns the KeyDescriptor of this KeyList. 
		 * This is the same as the KeyDescriptor of the owning aspect.
		 */
		public IKeyAspectDescriptor getDescriptor() {
			return Aspect.this.getDescriptor().getKeyDescriptor();
		}

		public IKey getKey(int index) {
			return getAspectRow(index).getKey();
		}

		public Object get(int index) {
			return getKey(index);
		}

		public int size() {
			return Aspect.this.size();
		}

	}

	/**
	 * Promote all SHARED_PROMOTABLE locks to EXCLUSIVE locks. </p>
	 * 
	 * Lock Mode Promotion is processed in the queue as well, therefore the result of 
	 * the lock promotion is only available after flushing the queue.</p>
	 * 
	 * @todo how to get a lock result?
	 */
	public void promoteLock() {
		//TODO is this needed for locking?
		/**
		handleAccessAspect(true);
		ISrvMgrLock lockCall = serviceModule.getSrvMgrServiceModule().createLock(getName());
		// copy keys to inrecords Keys table
		GenericClientUtils.copyFromKeyListToTable(liveKeyList, lockCall.getInKeys());
		lockCall.setLockMode(ISrvMgrLock.EXCLUSIVE);
		serviceModule.registerSrvMgrCallObject(lockCall, this);**/
	}

	/**
	 * Release any lock previously acquired for rows of this aspect.
	 */
	public void unlock() {
		//TODO is this needed?
	}

	/**
	 * helper method, which processes the results of a ServiceManager call object
	 * @param srvMgrCall
	 */
	//TODO set the state according to this method when loading data

	public IMessageList getMessages() {
		return messages;
	}


	/**
	 * helper method, which extends the key mapping of AspectRows
	 * @param row
	 * @param iKey
	 */
	protected void extendKeyMap(AspectRow row, Key key) {
		key.takeFieldsFromRow(row);
		aspectRowsMap.put(key, row);
	}

	/**
	 * Sets a new IEdoTable as this aspects data and wraps all records 
	 * contained in that table with an AspectRow. 
	 * Can be called in state HOLLOW only, performs the transition to CLEAN.
	 * @param newAspectData
	 * @todo make this method more robust and clear rows first?
	 */
	void setAspectData(IEdoTableEx newAspectData) {
		final String method = jARMRequest + ":setAspectData(IEdoTableEx)";
		CAFPublicLogger.entering(null, jARMRequest, method, logger,2);
		try {
			setState(PROCESS_QUEUE_WAITING);
	
			this.aspectData = newAspectData;
	
			// now wrap each record in the EDO table
	
			// handle scenario, if one HOLLOW AspectRow was created before, but the result doesn't provide a Correct AspectRow
			int recordSize = aspectData.getRecordCount();
			if (recordSize == 0 && size() == 1) {
				((AspectRow) getAspectRow(0)).setState(Aspect.INVALID);
			}
			for (int i = 0; i < recordSize; i++) {
				AspectRow row;
				if (i == 0 && size() == 1) {
					row = (AspectRow) getAspectRow(0);
					row.setState(Aspect.CLEAN);
				} else {
					row = (AspectRow) createAspectRow(i);
				}
				// merge returned values to key and map key to row
				extendKeyMap(row, (Key) row.getKey());
			}
	
			setState(CLEAN);
		}
		finally {
			CAFPublicLogger.exiting(null, jARMRequest, method, logger, 2);
		}
	}

	/**
	 * Returns <code>true</code> if this <code>Aspect</code> is valid, otherwise <code>false</code>. If
	 * this <code>Aspect</code> is not valid, accessing the Aspect leads to an IllegalStateException.</p>
	 */
	public boolean isValid() {
		return (state != INVALID);
	}

	/**
	 * method returns <code>true</code>, if field wise changes are allowed for this <code>Aspect</code>
	 */
	private boolean isFieldWiseChange() {
		final String method = jARMRequest + ":isFieldWiseChange()";
		CAFPublicLogger.entering(null, jARMRequest, method, logger, 2);
		try {
			if (fieldWiseChange == null) {
				boolean rowWiseFlag = false, fieldWiseFlag = false;
				try {
					rowWiseFlag = descriptor.getAttributeRowwiseOperation();
				} catch (UnsupportedOperationException e) {
					// can be ignored, this exception is handled like flag is false
				}
				try {
					fieldWiseFlag = descriptor.getAttributeFieldwiseOperation();
				} catch (UnsupportedOperationException e) {
					// can be ignored, this exception is handled like flag is false
				}
				// default is row wise, if nothing is set or exceptions are thrown
				if (rowWiseFlag || !fieldWiseFlag)
					fieldWiseChange = Boolean.FALSE;
				else
					fieldWiseChange = Boolean.TRUE;
			}
			return fieldWiseChange.booleanValue();
		}
		finally {
			CAFPublicLogger.exiting(null, jARMRequest, method, logger, 2);
		}
	}

	/**
	 * sets the association to the source aspect of the creating relation.<p>
	 * This <code>sourceAspectOfCreatingRelation</code> is needed, when method createRelatedAspectRow() is used and the
	 * return of this call is merged locally.
	 */
	void setSourceAspectOfCreatingRelation(Aspect aspect) {
		sourceAspectOfCreatingRelation = aspect;
	}
	
	void setSourceAspectRowOfCreatingRelation(AspectRow aspectRow) {
		sourceAspectRowOfCreatingRelation = aspectRow;
	}

	/**
	 * @see com.sap.tc.col.client.generic.api.IAspect#createValueSet(java.lang.String)
	 */
	public IValueSet createValueSet(String arg0) {
		// TODO Auto-generated method stub
		return null;
	}

	/**
	 * @see com.sap.tc.col.client.generic.api.IAspect#getRelatedAspect(java.lang.String, com.sap.tc.col.client.generic.api.LockMode, com.sap.tc.col.client.generic.api.SortingCriteria)
	 */
	public IAspect getRelatedAspect(
		String arg0,
		LockStrategy arg1,
		SortingCriteria arg2) {
		return getRelatedAspect(arg0, arg1);
	}

	/**
	 * @see com.sap.tc.col.client.generic.api.IAspect#refresh()
	 */
	public void refresh() {
		final String method = jARMRequest + ":refresh()";
		CAFPublicLogger.entering(null, jARMRequest, method, logger, 2);
		try {
			aspectChanges.reset();
			setState(HOLLOW);
			aspectData.clear();
			aspectRows.clear();
			m_observableList.clear();
			aspectRowsMap.clear();
			// Load original aspect rows
			loadAspectRows(m_originalKeyList, LockStrategy.SHARED_READ_ONLY);
			setState(CLEAN);
			for (Iterator i = m_relatedAspects.iterator(); i.hasNext(); ((IAspect)i.next()).refresh()) {}
		} catch (Exception e) {
			MessageFactory.createAndRegisterMessageFromException(e, this, true);
		} finally {
			CAFPublicLogger.exiting(null, jARMRequest, method, logger, 2);
		}
	}

	/**
	 * @see com.sap.tc.col.client.generic.api.IAspect#setInvalidationHint(java.lang.String, int)
	 */
	public void setInvalidationHint(String arg0, int arg1) {
		// TODO Auto-generated method stub

	}

	private void refreshAspectRow(IAspectRow row, IDataContainerBean dataBean)
		throws ServiceException {
		final String method = jARMRequest + ":refreshAspectRow(IAspectRow, IDataContainerBean)";
		CAFPublicLogger.entering(null, jARMRequest, method, logger, 2);
		try {
			IStructureDescriptor desc =
				row.getAspect().getDescriptor().getStructure();

			IFieldDescriptor resultFields[] = desc.getFieldDescriptors();
			int size = resultFields.length;
//			for (int i = 0; i < size; ++i) {
//				String fieldName = resultFields[i].getName();
//				row.setAttributeValue(
//					fieldName,
//					dataBean.getProperty(fieldName));
//			}
			((AspectRow)row).setAttributeValue(dataBean);//???
		} catch (Exception e) {
			throw new ServiceException(
				"Error while refreshing aspect row. Please check module description and module implementation consistency.",
				null,
				e);
		}
		finally {
			CAFPublicLogger.exiting(null, jARMRequest, method, logger, 2);
		}
	}

	/* this method converts key to string */
	protected String getKeyAsString(IKey key) throws ServiceException {
		try {
			String strKey = key.toString();
			return strKey.substring(1, strKey.length() - 1);
		} catch (Exception ex) {
			throw new ServiceException(ex);
		}
	}
	
	/**
	 * Return collection of values of "key" attributes.
	 */	
	protected Collection getCollectionStringKeys(){
		Collection result = new java.util.HashSet();
		for(int i = 0 ; i < this.size(); i ++){
			String key =this.getAspectData().getStringValue(i, "key");
			if((key != null) && (!"".equals(key))){
				result.add(key);
			}
		}
		return result;
	}
	
	/**
	 * Return collection of values of "propertyName" attributes.
	 */	
	protected Collection getCollectionValues(String propertyName) {
		Collection result = new java.util.ArrayList();
		for(int i = 0 ; i < this.size(); i ++){
			Object value =this.getAspectData().getValue(i, propertyName);
			if(value != null){
				result.add(value);
			}
		}
		return result;
	}

	protected void addRelatedAspect(IAspect aspect) {
		if (m_relatedAspects.indexOf(aspect) < 0) {
			m_relatedAspects.add(aspect);
		}
	}
	
	protected boolean isWaitingForCommit() {
		return m_waitingCommit;
	}
	
	protected static synchronized void clearAspectWaitingStates() {
		for (Iterator i = m_aspects.iterator(); i.hasNext(); ) {
			Aspect a = (Aspect) i.next();
			if (a != null) {
				a.m_waitingCommit = false;
				a.aspectChanges.commitChanges();
			}
		}
	}

	protected static synchronized void setDirtyStateForChangedAspects() {
		for (Iterator i = m_aspects.iterator(); i.hasNext(); ) {
			Aspect a = (Aspect) i.next();
			if (a != null && a.m_waitingCommit) {
				a.m_waitingCommit = false;
				a.setState(DIRTY);
				a.aspectChanges.rollbackChanges();
			}
		}
	}
	
	/**
	 * Removes obsolete elements from the list of references. Element of the list becomes obsolete if it referes garbage collected object. 
	 * @return number of obsolete object that were removed from the list.
	 */
	private static synchronized int cleanupList() {
		int result = 0;
		for (Iterator i = m_aspects.iterator(); i.hasNext(); ) {
			if (i.next() == null) {
				i.remove();
				result++;
			}
		} 
		return result;
	}
	
	/**
	 * @return
	 */
	public AspectRow getSourceAspectRowOfCreatingRelation() {
		return sourceAspectRowOfCreatingRelation;
	}
	
	/**
	 * Return Dirty flag
	 * @return
	 */
	public boolean isDirty() {
		for (Iterator i = aspectRows.iterator(); i.hasNext(); ) {
			AspectRow row = (AspectRow) i.next();
			if (row.isDirty()) {
				return true;
			}
		}
		return !aspectChanges.getChangesState().isEmpty();
	}


	/**
	 * The class WeakArrayList is intended to "weakly" store list of objects like WeaklyHashMap do for key-value pairs.
	 * @author pavel_henrykhsen
	 */
	private static class WeakArrayList extends AbstractList {
		private List internalList;
		
		public WeakArrayList() {
			internalList = new ArrayList();
		} 

		public WeakArrayList(int initialCapacity) {
			internalList = new ArrayList(initialCapacity);
		} 

		public WeakArrayList(Collection c) {
			internalList = new ArrayList(c);
		}
		
		public int size() {
			return internalList.size();
		}
		
		public Object get(int index) {
			return ((WeakReference) internalList.get(index)).get();
		}
		
		public Object set(int index, Object element) {
			return ((WeakReference) internalList.set(index, new WeakReference(element))).get();
		}
		
		public Object remove(int index) {
			return ((WeakReference) internalList.remove(index)).get();
		}
		
		public boolean add(Object o) {
			return internalList.add(new WeakReference(o)); 
		}
	}
	
}
