/* Generated by Together */

package com.sap.caf.rt.ui.cool.generic;

import com.sap.caf.rt.util.CAFPublicLogger;
import com.sap.tc.cmi.metadata.ICMIModelClassInfo;
import com.sap.tc.cmi.model.ICMIModel;
import com.sap.tc.cmi.model.ICMIModelClass;
import com.sap.tc.col.client.generic.api.IAction;
import com.sap.tc.col.client.generic.api.IAspect;
import com.sap.tc.col.client.generic.api.IKey;
import com.sap.tc.col.client.generic.api.IKeyList;
import com.sap.tc.col.client.generic.api.IStructure;
import com.sap.tc.col.client.generic.api.LockStrategy;
import com.sap.tc.col.client.metadata.api.IAspectActionDescriptor;
import com.sap.tc.col.edo.IEdoStructure;
import com.sap.caf.rt.ui.cool.generic.EdoStructure;
import com.sap.tc.logging.Location;

/**
 * @author d022323
 */
/**
 * realizes class of an <code>Action</code>.
 * an <code>Action</code> is an operation on Keys of Aspects other than the
 * standard operations like insert, update, delete. Examples for actions are
 * "printing", "booking of flights" ...
 * An example using an <code>Action</code> could be:
 * <pre>
 *   IAction action = aspect.createAction("BOOKING_CANCEL");
 *   IStructure inputParameter = action.getInputParameter();
 *   // setting input parameter
 *   inputParameter.setAttributeValue("BOOKING", "000001");
 *   ..
 *   action.execute();
 *   ..
 * </pre> 
 * 
 * Additionally <code>Action</code> implements <code>ICMIGenericModelClass</code> and <code>ICMIModelClassExecutable</code>.<p>
 * This is necessary to use an Action from Web Dynpro. Web Dynpro framework only knows this interfaces and uses the implicit
 * relations <code>inputParameter</code> for setting parameters.<p>
 *
 * @author Helmut Mueller
 */
public class Action extends AbstractModelClass implements IAction {
	
	/** Logging properites for this class */
	private static final String APPLICATION	= Action.class.getName();
	private static final String jARMRequest = jARMReqPrefix+APPLICATION;
	private static final Location logger = Location.getLocation(APPLICATION);
	
	/**
	 * protected constructor, is only called from <code>Aspect</code>
	 */
	protected Action(IAspectActionDescriptor descriptor, Aspect inputAspect) {
		final String method = jARMRequest + ":Action(IAspectActionDescriptor, Aspect)";
		CAFPublicLogger.entering(null, jARMRequest, method, logger, 1);
		try {
			if (descriptor == null)
				// descriptor must not be null
				throw new IllegalArgumentException("AspectActionDescriptor must not be null");
			this.descriptor = descriptor;
			this.inputAspect = inputAspect;
	
			// create new Query service call object
			ServiceModule serviceModule =
				(ServiceModule) inputAspect.getServiceModule();
	
			IEdoStructure edoStruct =
				(IEdoStructure) new EdoStructure(descriptor.getInputParameters());
	
			//serviceModule.getServiceManager().createStructure(mActionTypeInfo.type_input_parameters);
			if (descriptor.hasInputParameters())
				this.inputParameter =
					(Structure) serviceModule.createStructureInternal(
						descriptor.getInputParameters(),
						edoStruct);
			this.modelClassInfo =
				(
					(ColModelInfo) associatedModel()
						.associatedModelInfo())
						.getOrCreateModelClassInfo(
					descriptor);
		}
		finally {
			CAFPublicLogger.exiting(null, jARMRequest, method, logger,1);
		}
	}

	/**
	 * @see com.sap.tc.cmi.model.ICMIModelClass#associatedModel()
	 */
	public ICMIModel associatedModel() {
		return inputAspect.associatedModel();
	}

	/**
	 * The ICMIModelClassInfo for this action. A reference is stored for performance reasons only. 
	 * The info could be easily retrieved from the serviceModule whenever needed.
	 */
	private final ICMIModelClassInfo modelClassInfo;

	/**
	 * @see com.sap.tc.cmi.model.ICMIGenericModelClass#associatedModelClassInfo()
	 */
	public ICMIModelClassInfo associatedModelClassInfo() {
		return modelClassInfo;
	}

	/**
	 /**
	 * executes this <code>Action</code>.
	 * this doesn't mean, that the action is now executed synchrounously in backend
	 * but it is sent to a service queue.<p>
	 * before this is done all pending changes of the associated <code>Aspect</code> are sent to service queue, to avoid
	 * executing the Action, on old data.
	 * ( a implicit sendChanges() on Aspect level )
	 */
	public void execute() {
		final String method = jARMRequest + ":execute()";
		CAFPublicLogger.entering(null, jARMRequest, method, logger, 1);
		try {
			ServiceModule sm = (ServiceModule)inputAspect.getServiceModule();
			//sm.sendChanges();
			sm.getServiceFacade().save();
			sm.getAspectServiceAccess().invokeOperation(descriptor.getName(), inputParameter, inputAspect.getKeyList());
			inputAspect.lockAndRefresh(LockStrategy.SHARED_READ_ONLY);
		} catch (Throwable ex) {
			logger.throwing("Error getting method ", ex);
			MessageFactory.createAndRegisterMessageFromException(ex, inputAspect, true);
		}
		finally {
			CAFPublicLogger.exiting(null, jARMRequest, method, logger, 1);
		}
	}

	/**
	 * @shapeType AssociatesLink 
	 * @label
	 * @supplierCardinality 1
	 * @clientCardinality 0..*
	 * @directed
	 */
	private IAspectActionDescriptor descriptor;

	/**
	 * return meta data of <code>Action</code>
	 */
	public IAspectActionDescriptor getDescriptor() {
		return descriptor;
	}

	/**
	 * the <code>Aspect</code> this <code>Action</code> belongs to.
	 */
	private Aspect inputAspect;

	/**
	 * @shapeType AssociatesLink 
	 * @label
	 * @supplierRole inputParameter
	 * @supplierCardinality 0..1
	 * @clientCardinality 0..*
	 * @directed
	 */
	private Structure inputParameter;

	/**
	 * returns the input parameter structure of this <code>Action</code> or throws an <code>UnsupportedOperationException</code>, if 
	 * this <code>Action</code> has no input parameter.
	 * @return IStructure the input parameter of this <code>Action</code>
	 * @exception throws an <code>UnsupportedOperationException</code>, if this <code>Action</code> has no input parameter.
	 */
	public IStructure getInputParameterStructure() {
		if (inputParameter == null) {
			MessageFactory.createAndRegisterMessageFromException(
					new UnsupportedOperationException("Action '"
							+ descriptor.getName()
							+ "'doesn't support input parameter!"), inputAspect);
		}
		return inputParameter;
	}
	
	// TODO Added to fix compilation error and should be implemented
	public IStructure getInputParameter() {
		throw new UnsupportedOperationException("This operation isn't supported yet");		
	}

	private IKeyList m_keyList;

	/**
	 * returns the input <code>KeyList</code> of this <code>Action</code>
	 * @return the input <code>KeyList</code> of this <code>Action</code>
	 */
	public IKeyList getInputKeyList() {
		try {
			IKeyList aspectKeyList = inputAspect.getKeyList();
			if (m_keyList == null /*|| !m_keyList.equals(aspectKeyList)*/) {
				ServiceModule serviceModule = (ServiceModule) inputAspect.getServiceModule();
				m_keyList = serviceModule.createKeyList(
						inputAspect.getDescriptor().getKeyDescriptor().getName());
				m_keyList.addAll(inputAspect.getKeyList());
			}
			return m_keyList;
		} catch (Exception e) {
			MessageFactory.createAndRegisterMessageFromException(e, inputAspect);
			return null;
		} 
	}

	/**
	* returns the input parameters model class of type ICMIModelClass which has the cardinality 1<p>
	* This is the only valid related model class and so otherwise a
	* <code>java.lang.IllegalArgumentException</code> is thrown.
	* @param rolename the rolename, valid are: inputParameter
	*/
	public ICMIModelClass getRelatedModelObject(String rolename) {
		if (rolename.equalsIgnoreCase(INPUT_PARAMETER)) {
			return getInputParameterStructure();
		} else {
			return super.getRelatedModelObject(rolename);
		}
	}

	/**
	 * returns the name of this <code>Action</code>
	 */
	public String getName() {
		return descriptor.getName();
	}

	/**
	 * @see com.sap.tc.col.client.generic.api.IAction#setRelationTargetKey(com.sap.tc.col.client.generic.api.IKey)
	 */
	public void setRelationTargetKey(IKey arg0) {
		// TODO Auto-generated method stub
		MessageFactory.createAndRegisterMessageFromException(
				new UnsupportedOperationException("Method setRelationTargetKey() is not supported."), inputAspect);
	}

	/**
	 * Sets input parameter with the given <code>name</code>.
	 */
	public void setAttributeValue(String name, Object value) {
		try {
			if (inputParameter != null) {
				inputParameter.setAttributeValue(name, value);
			} //  TODO What else ?
		} catch (Exception e) {
			MessageFactory.createAndRegisterMessageFromException(e, inputAspect);
		} 
	}
	
	public IAspect getInputAspect() {
		return inputAspect;
	}

}
