/*
 * Copyright (c) 2002 SAP AG - All Rights Reserved.
 *
 * @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_progmodel/java/com/sap/tc/webdynpro/progmodel/model/api/WDModelException.java#1 $
 */

package com.sap.tc.webdynpro.progmodel.model.api;

import java.lang.Throwable;
import com.sap.tc.cmi.exception.CMIException;

/**
 * Base class for exceptions thrown by methods of the Web Dynpro Model API.
 *
 * @author SAP
 * @SAPWebDynproPart 2
 * @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_progmodel/java/com/sap/tc/webdynpro/progmodel/model/api/WDModelException.java#1 $
 */
public class WDModelException extends CMIException
{
 
	public static final String MODELCLASS_LIST_WRONG_ELEMENT_TYPE =
		"List must contain Elements of Type ''{0}'', not of ''{1}''!";
	public static final String MODELCLASS_LIST_ALLOWED_TYPE =
		"List must only allow ModelClass instances of Type ''{0}''!";
	public static final String MODEL_ALREADY_EXIST_IN_SCOPE =
		"A Model Instance of type ''{0}'' already exists in scope ''{1}''!";
	public static final String MODEL_ALREADY_EXIST_WITH_INSTANCEID =
		"A Model Instance of type ''{0}'' already exists in scope ''{1}'' with the InstanceId ''{2}''!";
	public static final String MODEL_SCOPE_CANT_BE_NULL =
		"The scope of a model must not be null!";
	public static final String MODEL_NOT_COMPATIBLE_FOR_CREATION_BY_WDMODELFACTORY =
		"The type of model represented by class ''{0}'' is not compatible for creation by WDModelFactory!";

  /**
   * Creates a web dynpro Model exception
   */
  public WDModelException(String messageText) {
    this(messageText, null, null);
  }

  /**
   * Creates a web dynpro Model exception
   */
  public WDModelException(String messageText, Throwable reason) {
    this(messageText, null, reason);
  }

  /**
   * Creates a web dynpro Model exception
   */
  public WDModelException(Throwable reason) {
    this(null, null, reason);
  }

  /**
   * Creates a web dynpro Model exception
   */
  public WDModelException(String messageText, Object[] parameters) {
    this(messageText, parameters, null);
  }

  /**
   * Creates a web dynpro Model exception
   */
  public WDModelException(String messageText, Object[] parameters, Throwable reason)
  {
    super(messageText, parameters, reason);
  }

}
