/*
 * Copyright (c) 2002 SAP AG - All Rights Reserved.
 *
 * @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_progmodel/java/com/sap/tc/webdynpro/progmodel/model/api/IWDModelRegistry.java#1 $
 */
package com.sap.tc.webdynpro.progmodel.model.api;

import com.sap.tc.cmi.model.*;

/**
 * Registry for managing Model classes by Key.
 *
 * Provides a registry for model classes as well as a finder service for model
 * class instances.</p>
 *
 * @author SAP
 * @SAPWebDynproPart 2
 * @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_progmodel/java/com/sap/tc/webdynpro/progmodel/model/api/IWDModelRegistry.java#1 $
 */

public interface IWDModelRegistry
{

  /**
   * Registers the ModelClass Instance with the key given
   * If an instance already exists under this key, the old value is replaced
   * and returned, otherwise <tt>null</tt> is returned.
   *
   * @param key key with which the ModelClass instance is to be registered.
   * @param extent name of extent or collection within which to unregister
   *               the instance associated with this key
   * @param instance ModelClass instance to be registered.
   * @return previous value associated with specified key, or <tt>null</tt>
   *	       if there was no mapping for key.
   */
   public ICMIModelClass register(Object key, String extent, ICMIModelClass instance);

  /**
   * Unregisters the Instance registered under the key given
   * and returns the previously registered instance
   * (or <tt>null<tt> if no instance was registered)
   *
   * @param key key to be unregistered.
   * @param extent name of extent or collection within which to unregister
   *               the instance associated with this key
   * @return ModelClass instance previously registered with the specified key,
   *           or <tt>null</tt> if no object was registered.
   */
   public ICMIModelClass unregister(Object key, String extent);

  /**
   * Lookups the ModelClass Instance with the key given in the extent
   * If an instance already exists under this key/extent, the old value is replaced
   * and returned, otherwise <tt>null</tt> is returned.
   *
   * @param key key with which the ModelClass instance is to be registered.
   * @param extent name of extent or collection within which to unregister
   *               the instance associated with this key
   * @param instance ModelClass instance to be registered.
   * @return previous value associated with specified key, or <tt>null</tt>
   *	       if there was no mapping for key.
   */
   public ICMIModelClass lookup(Object key, String extent);

  /**
   * unregisters all ModelClass Instances registered with this model
   */
   public void unregisterAll();
}
