/*
 * Copyright (c) 2002 SAP AG - All Rights Reserved.
 *
 * @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_progmodel/java/com/sap/tc/webdynpro/progmodel/model/api/IWDModelClassRegistrable.java#1 $
 */
package com.sap.tc.webdynpro.progmodel.model.api;

import com.sap.tc.cmi.model.*;

/**
 * Model Classes implementing this interface can be registered by key
 * with their corresponding model.
 *
 * @author SAP
 * @SAPWebDynproPart 2
 * @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_progmodel/java/com/sap/tc/webdynpro/progmodel/model/api/IWDModelClassRegistrable.java#1 $
 */
public interface IWDModelClassRegistrable
{

  /**
   * Registers this ModelClass Instance with its associated model under the key given
   * If an instance already exists under this key, the old value is replaced.
   *
   * @param key key with which this ModelClass instance is to be associated.
   * @return previous value associated with specified key, or <tt>null</tt>
   *	       if there was no mapping for key.
   */
  public ICMIModelClass register(Object key);

  /**
   * Unregisters this ModelClass Instance with its model under the key given
   * If this instance was not already registered under this name,
   * then the currently registered value is returned, otherwise <tt>null</tt>.
   *
   * @param key key with which this ModelClass instance is no longer to be associated.
   * @return current value associated with specified key if a different object was registered,
   *           or <tt>null</tt> if this object could be successfully unregistered.
   */
  public ICMIModelClass unregister(Object key);

}
