/*
 * Copyright (c) 2003 SAP AG - All Rights Reserved.
 *
 * @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_progmodel/java/com/sap/tc/webdynpro/progmodel/api/WDSimpleValueSupplier.java#1 $
 */
package com.sap.tc.webdynpro.progmodel.api;

import java.util.Locale;
import java.util.Map;

import com.sap.typeservices.IModifiableSimpleValueSet;

/**
 * Default implementation of {@link IWDValueSupplier}. The default implementation 
 * assumes that only the valueset has to be retrieved. All other features of 
 * on demand loadable valuesets are implemented here. </p>
 * 
 * The following methods must be implemented in any derived class:<br>
 * <ul>
 * <li>public boolean {@link IWDValueSupplier#supplyValues(IModifiableSimpleValueSet initialSet, Locale locale)}
 * <li>public String {@link IWDValueSetSource#supplyValue(Object key, Locale locale)}
 * <li>public boolean {@link IWDValueSetSource#contains(Object key)}
 * </ul>
 * 
 * @see IWDValueSupplier
 * 
 * @author SAP
 * @SAPWebDynproPart 1
 */
abstract public class WDSimpleValueSupplier implements IWDValueSupplier {

  /**
   * @see com.sap.tc.webdynpro.progmodel.api.IWDValueSupplier#supplyValues(com.sap.typeservices.IModifiableSimpleValueSet, java.util.Locale)
   */
  abstract public boolean supplyValues(IModifiableSimpleValueSet initialSet, Locale locale);

	/**
	 * @see com.sap.tc.webdynpro.progmodel.api.IWDValueSetSource#supplyValue(java.lang.Object, java.util.Locale)
	 */
	abstract public String supplyValue(Object key, Locale locale);
	
	/**
	 * @see com.sap.tc.webdynpro.progmodel.api.IWDValueSetSource#contains(java.lang.Object)
	 */
	abstract public boolean contains(Object key);
	

  /**
   * Overwrite this method in order get filtered value help. This is recommended for large valueset 
	 *
   * @see com.sap.tc.webdynpro.progmodel.api.IWDValueSupplier#supplyFilteredValues(com.sap.typeservices.IModifiableSimpleValueSet, java.util.Locale, com.sap.tc.webdynpro.progmodel.api.IWDValueFilter)
   */
  public void supplyFilteredValues(IModifiableSimpleValueSet initialSet, Locale locale, IWDValueFilter Filter) {
		throw new UnsupportedOperationException("Cannot process filtered valuesets");
  }


  /**
   * Overwrite this method in order get lazy key to value resolution in doPostProcessing 
   * 
   * @see com.sap.tc.webdynpro.progmodel.api.IWDValueSetSource#supplyLazyValues(java.util.Map, java.util.Locale)
   */
  public void supplyLazyValues(Map keyValueMap, Locale locale) {
		throw new UnsupportedOperationException("Cannot process filtered valuesets");

  }

  /**
   * Overwrite this method in order get filtered value help. This is recommended for large valueset 
   *  
   * @see com.sap.tc.webdynpro.progmodel.api.IWDValueSetSource#supportFilter()
   */
  public int supportFilter() {
    return IWDValueSetSource.NO_FILTER_SUPPORT;
  }

	/**
	 * Overwrite this method in order get lazy key to value resolution in doPostProcessing 
	 * 
   * @see com.sap.tc.webdynpro.progmodel.api.IWDValueSetSource#supportLazyValues()
   */
  public boolean supportLazyValues() {
    return false;
  }

}
