/*
 * Copyright (c) 2002 SAP AG - All Rights Reserved.
 *
 * @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_progmodel/java/com/sap/tc/webdynpro/progmodel/api/IWDView.java#1 $
 */
package com.sap.tc.webdynpro.progmodel.api;

/**
 * Generic API of all views.
 * 
 * This type can be called by applications using Web Dynpro, but DO NOT EXTEND OR IMPLEMENT IT!
 *
 * @author SAP
 * @SAPWebDynproPart 2
 * @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_progmodel/java/com/sap/tc/webdynpro/progmodel/api/IWDView.java#1 $
 */
public interface IWDView extends IWDViewController
{
  /**
   * Creates a new view element implementing the given interface and with the
   * given optional ID.
   * 
   * @param viewElementInterface class of an interface that belongs to the API of some UI element library
   * @param id must be a legal identifier that does not start with an underscore;
   * may be <code>null</code>, in which case an ID is determined automatically
   * 
   * @throws WDRuntimeException in case a view element for the given ID already exists
   */
  public IWDViewElement createElement(Class viewElementInterface, String id);

  /**
   * Returns the view element with the given ID or <code>null</code> if no such
   * element exists.
   */
  public IWDViewElement getElement(String id);
  
  /**
   * Returns the root element of this view's tree of view elements.
   */
  public IWDViewElement getRootElement();
  
  /**
   * Resets the view's layout (i.e. its tree of view elements) to the initial state
   * declared at design time.
   * That is, all dynamic modifications to the view layout are thrown away and
   * the view returns to the state it was in when it was initialised.
   */
  public void resetView();
}
