/* Title:        Web Dynpro Java Runtime: 
 * Description:  base interface for IWDValueSupplier and IWDBoundValueSet.IWDFilterListener  
 * Copyright:    Copyright (c) 2002
 * Company:      SAP AG
 * @author SAP
 * @version      $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_progmodel/java/com/sap/tc/webdynpro/progmodel/api/IWDValueSetSource.java#1 $
 */
package com.sap.tc.webdynpro.progmodel.api;

import java.util.Locale;
import java.util.Map;

/**
 * Base interface for IWDValueSupplier and IWDBoundValueSet.IWDFilterListener.
 * 
 * @author SAP
 * @SAPWebDynproPart 1
 * @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_progmodel/java/com/sap/tc/webdynpro/progmodel/api/IWDValueSetSource.java#1 $
 */
public interface IWDValueSetSource {
  
	/**
	 * Constant used for indication of "no filter support". Used as return value for methode supportFilter
	 * 
	 * @see IWDValueSetSource#supportFilter()
	 * @see IWDValueSupplier#supplyFilteredValues(IModifiableSimpleValueSet, Locale, IWDValueFilter)
	 */	
	final static public int NO_FILTER_SUPPORT = 0;
	/**
	 * Constant used for indication of "filter supports only keys as argument". Used as return value for methode supportFilter
	 * 
	 * @see IWDValueSetSource#supportFilter()
	 * @see IWDValueSupplier#supplyFilteredValues(IModifiableSimpleValueSet, Locale, IWDValueFilter)
	 */	
	final static public int FILTER_KEY = 1;
	/**
	 * Constant used for indication of "filter supports key and values as argument". Used as return value for methode supportFilter
	 * 
	 * @see IWDValueSetSource#supportFilter()
	 * @see IWDValueSupplier#supplyFilteredValues(IModifiableSimpleValueSet, Locale, IWDValueFilter)
	 */	
	final static public int FILTER_ALL = 2;
	

	
	/**
	 * Implement this method in order to supply the value for a single key.
	 * 
	 * @param key is the key of the requested value.
	 * 
	 * @param locale of the valueset's display text. 
	 * 
	 * @return the Value for the given key
	 */
	String supplyValue(Object key, Locale locale);


	/**
	 * Implement this method in order to supply the values for a set of keys. It is legal to keep a reference to 
	 * parameter <code>keyValueSet</code> until the components doPostProcessing method is called. The typical usage 
	 * of this method is to store a reference to the keyValueSet and to fill the content later. The latest possible 
	 * point in time for filling thwe map is <code>doPostProcessing</code>.
	 * 
	 * @param keyValueMap is a map conatining a set of keys with empty values. The values have to be supplied  
	 * 
	 * @param locale of the valueset's display text. 
	 * 
	 * @exception UnsupportedOperationException in case this metod is not implemented. In this case
	 * method supportLazyValues must return <code>false</code>.
	 * 
	 * @see IWDValueSetSource#supportLazyValues()
	 * 
	 */
	void supplyLazyValues(Map keyValueMap, Locale locale);


	/**
	 * Check if this instance can process filtered value supply.
	 * 
	 * @return true, if method supplyFilteredValues is supported for this instance, else return false.
	 */
	int supportFilter();

	/**
	 * Check if this instance can process lazy value supply. In case this instance does not support
	 * this feature any call to <code>IWDOnDemandValueSetService.setCurrentKey(Object key)</code> and 
	 * <code>IWDOnDemandValueSetService.addKey(Object Key)</code> directly calls this instance's 
	 * <code>supplyValue(Object key, Locale locale)</code> method <p>
	 * 
	 * @see IWDValueSetSource#supplyValue(Object, Locale)
	 * @see IWDOnDemandValueSetService#addKey(Object) 
	 * @see IWDOnDemandValueSetService#setCurrentKey(Object)
	 * @see IWDOnDemandValueSetService
	 * @see IWDValueSetSource#supplyLazyValues(Map, Locale)
	 * 
	 * @return the supported filter operation 
	 * @see IWDValueSetSource#NO_FILTER_SUPPORT 
	 * @see IWDValueSetSource#FILTER_KEY 
	 * @see IWDValueSetSource#FILTER_ALL
	 */
	boolean supportLazyValues();


	/**
	 *   Check if key is a valid key. This method is called for validation purpose only. In case it is expensive to
	 *   check the key, it is legal to return <code>true</code> for any key. In that case the key entered by the user
	 *   is always valid in terms of framework validation and must be check somewhere else by application code. 
	 *   @return true if key is a valid key in this value set 
	 */
	boolean contains(Object key);


}
