/*
 * @(#) $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_progmodel/java/com/sap/tc/webdynpro/progmodel/api/IWDTextAccessor.java#1 $
 *
 * Copyright(c) 2003, SAP AG, All Rights Reserved.
 */
package com.sap.tc.webdynpro.progmodel.api;

/**
 * Provides access to translatable texts.
 * 
 * @author SAP
 * @SAPWebDynproPart 2
 * @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_progmodel/java/com/sap/tc/webdynpro/progmodel/api/IWDTextAccessor.java#1 $
 */
public interface IWDTextAccessor {

  /**
   * Returns a localized text for the given message.
   * 
   * This method returns the message text stored in <code>message</code>.
   * If no message text is available it is searched for the localized message
   * text for the message's key.
   * If a text is found for the key, this text is returned.
   * If neither a message text nor a valid message key is available,
   * the message key is returned. This may also be null!
   *
   * @param message message for which a localized text is returned 
   * @return the message text
   */
  String getText(IWDMessage message);

  /**
   * Returns a formatted text whose localized text is determined by
   * the given message, parameterized by the given parameters.
   *
   * This method returns the message text stored in <code>message</code>.
   * If no message text is available it is searched for the localized message
   * text for the message's key.
   * If a text is found for the key, this text is returned.
   * If neither a message text nor a valid message key is available, the 
   * message key is returned. This may also be null!
   *
   * @param message message for which a localized text is returned  
   * @param parameters object array of parameters
   * @return the message text
   */
  String getText(IWDMessage message, Object parameters[]);

  /**
   * Returns a localized text for the given key.
   * 
   * @param key the key of the localized text
   * @return the localized text
   */
  String getText(String key);

  /**
   * Returns a formatted text whose localized text is determined by
   * the given key, parameterized by the given parameters.
   * 
   * @param key the key of the localized text
   * @param parameters object array of parameters
   * @return the localized text 
   */
  String getText(String key, Object parameters[]);
}
