/* Title:        Web Dynpro Java Runtime: Loadable valuesets on demand 
 * Description:  plublic application interface for providing a loadable valueset on demand
 * Copyright:    Copyright (c) 2002
 * Company:      SAP AG
 * @author SAP
 * @version      $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_progmodel/java/com/sap/tc/webdynpro/progmodel/api/IWDOnDemandValueSetService.java#1 $
 */
package com.sap.tc.webdynpro.progmodel.api;

import com.sap.typeservices.ISimpleValueServices;
import com.sap.typeservices.ISimpleValueSet;


/**
 * Interface for providing a loadable valueset on demand
 * @SAPWebDynproPart 2
 */
public interface IWDOnDemandValueSetService extends ISimpleValueServices {
	/**
	 * Invalidate valueset, needs to to requested next time value help is needed.
	 */
	void invalidate();
	/**
	 * Sets the current valueset to a single entry containing this 
	 * key Value Pair for display of the current key. It is up to the 
	 * application developer to set the proper key - value pair 
	 * according to the context attributes current value.
	 * 
	 * @param key is the key for this value pair
	 * @param value is the human readable value
	 */
	void setCurrentKeyValuePair(Object key, String value);


	/**
	 * Sets the current valueset to a single key containing this 
	 * key. It is up to the 
	 * application developer to set the proper key to the context attributes current value.
	 * The value is requested internally by calling IWDValueSupplier.getValue(Object key).
	 * 
	 * @param key is the key for this value pair
	 */
	void setCurrentKey(Object key);

	/**
	 * Add a key value pair to the current valueset. The current value set 
	 * is a reduced valueset containing only the key value pair needed 
	 * for display. Several key value pairs may be needed for table display.
	 * For single record display usually only one key value pair is needed.
	 * 
	 * @param key is the key for this value pair
	 * @param value is the human readable value
	 */
	void addKeyValuePair(Object key, String value);

	/**
	 * Add a key to the current valueset. The current value set 
	 * is a reduced valueset containing only the key value pair needed 
	 * for display. Several key value pairs may be needed for table display.
	 * For single record display usually only one key value pair is needed.
	 * The value is requested internally by calling IWDValueSupplier.getValue(Object key).
	 * 
	 * @param key is the key for this value pair
	 */
	void addKey(Object key);
	
	/**
	 * 
	 * reset the temporary valueset for display. 
	 */
	void resetCurrentKeys();
	
}
