package com.sap.tc.webdynpro.progmodel.api;

/**
 * Interface used to set up a dynamic supply "function".
 * 
 * @author SAP
 * @SAPWebDynproPart 1
 * @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_progmodel/java/com/sap/tc/webdynpro/progmodel/api/IWDNodeCollectionSupplier.java#1 $
 */
public interface IWDNodeCollectionSupplier {
  /**
   * Method to set up the collection for a dependent node after changes in
   * the parent node. You can use {@link IWDNode#bind(java.util.Collection)} or
   * {@link IWDNode#addElement(IWDNodeElement)} to fill the node. It is possible
   * to set up child nodes in this supplier, too. In this case, their supply
   * "function" will not be called. Do <b>not</b> 
   * {@link IWDNode#invalidate() invalidate} the node; the supplier is only
   * called if the node's collection is invalid.
   * @param node The node the collection is to be determined for
   * @param parentElement The parent element
   */
  void supplyElements(IWDNode node, IWDNodeElement parentElement);
}
