/*
 * Copyright (c) 2002 SAP AG - All Rights Reserved.
 *
 * @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_progmodel/java/com/sap/tc/webdynpro/progmodel/api/IWDCustomEvent.java#1 $
 */
package com.sap.tc.webdynpro.progmodel.api;

/**
 * API of Custom Events provided to Controller Event Handlers.
 *
 * @author SAP
 * @SAPWebDynproPart 2
 * @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_progmodel/java/com/sap/tc/webdynpro/progmodel/api/IWDCustomEvent.java#1 $
 */
public interface IWDCustomEvent {

  /**
   * Returns the name of the event.
   * @return the name of the event
   */
  public String getName();

  /**
   * Returns the specified parameter as a boolean value.
   * 
   * Throws a runtime exception if the parameter is not a boolean or String
   * 
   * @param name the name of the parameter to retrieve
   * @return the parameter value (or false if it does not exist)
   */
  public boolean getBoolean(String name);

  /**
   * Returns the specified parameter as a byte value.
   * 
   * Throws a runtime exception if the parameter is not a byte or String
   * 
   * @param name the name of the parameter to retrieve
   * @return the parameter value (or 0 if it does not exist)
   */
  public byte getByte(String name);

  /**
   * Returns the specified parameter as a char value.
   * 
   * Throws a runtime exception if the parameter is not a char or one character
   * String
   * 
   * @param name the name of the parameter to retrieve
   * @return the parameter value (or 0 if it does not exist)
   */
  public char getChar(String name);

  /**
   * Returns the specified parameter as a double value.
   * 
   * Throws a runtime exception if the parameter is not a double or String
   * 
   * @param name the name of the parameter to retrieve
   * @return the parameter value (or 0 if it does not exist)
   */
  public double getDouble(String name);

  /**
   * Returns the specified parameter as a float value.
   * 
   * Throws a runtime exception if the parameter is not a float or String
   * 
   * @param name the name of the parameter to retrieve
   * @return the parameter value (or 0 if it does not exist)
   */
  public float getFloat(String name);

  /**
   * Returns the specified parameter as a integer value.
   * 
   * Throws a runtime exception if the parameter is not an int or String
   * 
   * @param name the name of the parameter to retrieve
   * @return the parameter value (or 0 if it does not exist)
   */
  public int getInt(String name);

  /**
   * Returns the specified parameter as a long value.
   * 
   * Throws a runtime exception if the parameter is not a long or String
   * 
   * @param name the name of the parameter to retrieve
   * @return the parameter value (or 0 if it does not exist)
   */
  public long getLong(String name);

  /**
   * Returns the specified parameter as an Object.
   * @param name the name of the parameter to retrieve
   * @return the parameter value (or null if it does not exist or is null)
   */
  public Object getObject(String name);

  /**
   * Returns the specified parameter as an Object of type <code>clazz</code>.
   * 
   * Throws a runtime exception if the parameter cannot be converted to the 
   * specified type.
   * 
   * @param name the name of the parameter to retrieve
   * @param class class object of desired conversion 
   * @return the parameter value (or null if it does not exist or is null)
   */
  public Object getObject(String name, Class clazz);

  /**
   * Returns the specified parameter as a short value.
   * 
   * Throws a runtime exception if the parameter is not a short or String
   * 
   * @param name the name of the parameter to retrieve
   * @return the parameter value (or 0 if it does not exist)
   */
  public short getShort(String name);

  /**
   * Returns the specified parameter as a string value.
   *
   * Throws a runtime exception if the parameter is not a String
   *
   * @param name the name of the parameter to retrieve
   * @return the parameter value (or null if it does not exist or is null)
   */
  public String getString(String name);
}
