/*
 * Copyright (c) 2002 SAP AG - All Rights Reserved.
 *
 * @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_progmodel/java/com/sap/tc/webdynpro/progmodel/api/IWDComponent.java#2 $
 */
package com.sap.tc.webdynpro.progmodel.api;

import com.sap.tc.webdynpro.progmodel.repository.IWDComponentInfo;
import com.sap.tc.webdynpro.progmodel.repository.IWDEventHandlerInfo;
import com.sap.tc.webdynpro.progmodel.repository.IWDEventInfo;
import com.sap.tc.webdynpro.services.sal.deployment.api.WDDeployableObjectPart;
import com.sap.tc.webdynpro.services.session.api.IWDWindowManager;

/**
 * Generic API of all Web Dynpro component controllers.
 * This interface is implemented by all Web Dynpro components.
 * 
 * @author SAP
 * @SAPWebDynproPart 2
 * @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_progmodel/java/com/sap/tc/webdynpro/progmodel/api/IWDComponent.java#2 $
 */
public interface IWDComponent extends IWDController {

  /**
   * This method returns the text accessor for this component.
   * The text accessor provides access to translatable texts in resource bundles.
   * 
   * @return the text accessor for this component
   */
  IWDTextAccessor getTextAccessor();

  /**
   * Returns this component's message manager.
   * There is only ever one message manager per component.
   * A message manager is the interface through which all views in a component
   * can report exceptions, warnings and success messages to the client.
   * 
   * @return this component's message manager
   */
  IWDMessageManager getMessageManager();

  /**
   * Returns the validation check interface for this component.
   * The validation check is used to check for invalid context attributes and
   * access external string representations.
   * 
   * @return the validation check interface for this component
   */
  IWDValidationCheck getValidationCheck();

  /**
   * Removes all pending user input including lead selection updates in an
   * appropriate scope.
   *
   * @deprecated This method may be withdrawn with the first new NetWeaver release in 2006
   *   as it is no longer needed. Context attributes simply may be overwritten in a 
   *   non validating action event handler, thereby removing any pending input for
   *   them. 
   */
  void removePendingUserInput();

  /**
   * Returns the metadata describing this component. 
   * @return the component metadata object
   */
  IWDComponentInfo getComponentInfo();

  /**
   * Returns the factory object to create windows.
   * A window represents the internal interface to the interface view of the
   * component.
   * @return the factory to create windows
   */
  IWDWindowManager getWindowManager();

  /**
   * Returns the deployable object part of this component.
   * @return the deployable object part of this component
   */
  WDDeployableObjectPart getDeployableObjectPart();

  /**
   * Subscribe the specified event handler to the specified event.
   * Event and event handler must be owned by controllers of this component.
   * @param event Repository object of the event to subscribe to
   * @param eventHandler Repository object of the event handler
   * @param controller Controller which owns the event handler
   */
  public void addEventHandler(IWDEventInfo event, IWDEventHandlerInfo eventHandler, IWDController controller);

  /**
   * Unsubscribe the specified event handler from the specified event.
   * The event must have been registered with the corresponding event before.
   * @param event Repository object of the event to unsubscribe from
   * @param eventHandler Repository object of the event handler
   * @param controller Controller which owns the event handler
   */
  public void removeEventHandler(IWDEventInfo event, IWDEventHandlerInfo eventHandler, IWDController controller);

  /**
   * Returns true, iff this component is the toplevel component of the
   * application.
   * @return true, iff this component is the toplevel component of the
   * application.
   */
  public boolean isApplicationRoot();

  /**
   * Returns the application to which this component belongs.
   * To ensure that components will be reusable, only call this method if
   * isApplicationRoot() == true.
   */
  public IWDApplication getApplication();
}
